/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.common.block.column;

import io.airlift.slice.SizeOf;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnEncoding;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnUtil;
import org.apache.iotdb.tsfile.read.common.block.column.LongColumn;
import org.openjdk.jol.info.ClassLayout;

public class TimeColumn
implements Column {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(LongColumn.class).instanceSize();
    public static final int SIZE_IN_BYTES_PER_POSITION = 8;
    private final int arrayOffset;
    private final int positionCount;
    private final long[] values;
    private final long retainedSizeInBytes;

    public TimeColumn(int positionCount, long[] values) {
        this(0, positionCount, values);
    }

    TimeColumn(int arrayOffset, int positionCount, long[] values) {
        if (arrayOffset < 0) {
            throw new IllegalArgumentException("arrayOffset is negative");
        }
        this.arrayOffset = arrayOffset;
        if (positionCount < 0) {
            throw new IllegalArgumentException("positionCount is negative");
        }
        this.positionCount = positionCount;
        if (values.length - arrayOffset < positionCount) {
            throw new IllegalArgumentException("values length is less than positionCount");
        }
        this.values = values;
        this.retainedSizeInBytes = (long)INSTANCE_SIZE + SizeOf.sizeOfLongArray((int)positionCount);
    }

    @Override
    public TSDataType getDataType() {
        return TSDataType.INT64;
    }

    @Override
    public ColumnEncoding getEncoding() {
        return ColumnEncoding.INT64_ARRAY;
    }

    @Override
    public long getLong(int position) {
        return this.values[position + this.arrayOffset];
    }

    public long getLongWithoutCheck(int position) {
        return this.values[position + this.arrayOffset];
    }

    @Override
    public Object getObject(int position) {
        return this.getLong(position);
    }

    @Override
    public boolean mayHaveNull() {
        return false;
    }

    @Override
    public boolean isNull(int position) {
        return false;
    }

    @Override
    public boolean[] isNull() {
        return null;
    }

    @Override
    public int getPositionCount() {
        return this.positionCount;
    }

    @Override
    public long getRetainedSizeInBytes() {
        return this.retainedSizeInBytes;
    }

    @Override
    public Column getRegion(int positionOffset, int length) {
        ColumnUtil.checkValidRegion(this.getPositionCount(), positionOffset, length);
        return new TimeColumn(positionOffset + this.arrayOffset, length, this.values);
    }

    @Override
    public Column subColumn(int fromIndex) {
        if (fromIndex > this.positionCount) {
            throw new IllegalArgumentException("fromIndex is not valid");
        }
        return new TimeColumn(this.arrayOffset + fromIndex, this.positionCount - fromIndex, this.values);
    }

    @Override
    public void reverse() {
        int i = this.arrayOffset;
        for (int j = this.arrayOffset + this.positionCount - 1; i < j; ++i, --j) {
            long time = this.values[i];
            this.values[i] = this.values[j];
            this.values[j] = time;
        }
    }

    public long getStartTime() {
        return this.values[this.arrayOffset];
    }

    public long getEndTime() {
        return this.values[this.getPositionCount() + this.arrayOffset - 1];
    }

    public long[] getTimes() {
        return this.values;
    }

    @Override
    public int getInstanceSize() {
        return INSTANCE_SIZE;
    }
}

