/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.filter.operator;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.filter.factory.FilterSerializeId;
import org.apache.iotdb.tsfile.read.filter.factory.FilterType;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class Between<T extends Comparable<T>>
implements Filter,
Serializable {
    private static final long serialVersionUID = -537390606419370764L;
    protected T value1;
    protected T value2;
    protected boolean not;
    protected FilterType filterType;

    public Between() {
    }

    public Between(T value1, T value2, FilterType filterType, boolean not) {
        this.value1 = value1;
        this.value2 = value2;
        this.filterType = filterType;
        this.not = not;
    }

    @Override
    public boolean satisfy(Statistics statistics) {
        if (this.filterType == FilterType.TIME_FILTER) {
            return this.satisfyStartEndTime(statistics.getStartTime(), statistics.getEndTime());
        }
        if (statistics.getType() == TSDataType.TEXT || statistics.getType() == TSDataType.BOOLEAN) {
            return true;
        }
        return this.not ? ((Comparable)statistics.getMinValue()).compareTo(this.value1) < 0 || ((Comparable)statistics.getMaxValue()).compareTo(this.value2) > 0 : ((Comparable)statistics.getMaxValue()).compareTo(this.value1) >= 0 && ((Comparable)statistics.getMinValue()).compareTo(this.value2) <= 0;
    }

    @Override
    public boolean allSatisfy(Statistics statistics) {
        if (this.filterType == FilterType.TIME_FILTER) {
            return this.containStartEndTime(statistics.getStartTime(), statistics.getEndTime());
        }
        if (statistics.getType() == TSDataType.TEXT || statistics.getType() == TSDataType.BOOLEAN) {
            return false;
        }
        return this.not ? ((Comparable)statistics.getMinValue()).compareTo(this.value2) > 0 || ((Comparable)statistics.getMaxValue()).compareTo(this.value1) < 0 : ((Comparable)statistics.getMinValue()).compareTo(this.value1) >= 0 && ((Comparable)statistics.getMaxValue()).compareTo(this.value2) <= 0;
    }

    @Override
    public boolean satisfy(long time, Object value) {
        Object v = this.filterType == FilterType.TIME_FILTER ? Long.valueOf(time) : value;
        return (this.value1.compareTo((Comparable)((Comparable)v)) <= 0 && ((Comparable)v).compareTo(this.value2) <= 0) ^ this.not;
    }

    @Override
    public boolean satisfyStartEndTime(long startTime, long endTime) {
        if (this.filterType == FilterType.TIME_FILTER) {
            return this.not ? startTime < (Long)this.value1 || endTime > (Long)this.value2 : endTime >= (Long)this.value1 && startTime <= (Long)this.value2;
        }
        return true;
    }

    @Override
    public boolean containStartEndTime(long startTime, long endTime) {
        if (this.filterType == FilterType.TIME_FILTER) {
            return this.not ? startTime > (Long)this.value2 || endTime < (Long)this.value1 : startTime >= (Long)this.value1 && endTime <= (Long)this.value2;
        }
        return false;
    }

    @Override
    public void serialize(DataOutputStream outputStream) {
        try {
            outputStream.write(this.getSerializeId().ordinal());
            outputStream.write(this.filterType.ordinal());
            ReadWriteIOUtils.write((Boolean)this.not, (OutputStream)outputStream);
            ReadWriteIOUtils.writeObject(this.value1, outputStream);
            ReadWriteIOUtils.writeObject(this.value2, outputStream);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void deserialize(ByteBuffer buffer) {
        this.filterType = FilterType.values()[buffer.get()];
        this.not = ReadWriteIOUtils.readBool(buffer);
        this.value1 = (Comparable)ReadWriteIOUtils.readObject(buffer);
        this.value2 = (Comparable)ReadWriteIOUtils.readObject(buffer);
    }

    @Override
    public FilterSerializeId getSerializeId() {
        return FilterSerializeId.BETWEEN;
    }

    @Override
    public Filter copy() {
        return new Between<T>(this.value1, this.value2, this.filterType, this.not);
    }

    public boolean equals(Object o) {
        if (!(o instanceof Between)) {
            return false;
        }
        Between between = (Between)o;
        return this.not == between.not && this.value1.equals(between.value1) && this.value2.equals(between.value2) && this.filterType == between.filterType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.value1, this.value2, this.not, this.filterType});
    }

    @Override
    public Filter reverse() {
        return new Between<T>(this.value1, this.value2, this.filterType, !this.not);
    }
}

