/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.metrics.core.uitls;

import com.codahale.metrics.Clock;
import java.lang.ref.WeakReference;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.ToDoubleFunction;
import org.apache.iotdb.metrics.core.uitls.IoTDBCachedGaugeMBean;
import org.apache.iotdb.metrics.type.AutoGauge;
import org.apache.iotdb.metrics.utils.AbstractMetricMBean;

public class IoTDBCachedGauge<T>
extends AbstractMetricMBean
implements AutoGauge,
IoTDBCachedGaugeMBean {
    private final Clock clock;
    private final AtomicLong reloadAt;
    private final long timeoutNS;
    private final AtomicReference<Double> value;
    private final WeakReference<T> refObj;
    private final ToDoubleFunction<T> mapper;

    protected IoTDBCachedGauge(WeakReference<T> refObj, ToDoubleFunction<T> mapper, long timeout, TimeUnit timeoutUnit) {
        this(Clock.defaultClock(), refObj, mapper, timeout, timeoutUnit);
    }

    protected IoTDBCachedGauge(Clock clock, WeakReference<T> refObj, ToDoubleFunction<T> mapper, long timeout, TimeUnit timeoutUnit) {
        this.clock = clock;
        this.refObj = refObj;
        this.mapper = mapper;
        this.reloadAt = new AtomicLong(clock.getTick());
        this.timeoutNS = timeoutUnit.toNanos(timeout);
        this.value = new AtomicReference();
    }

    @Override
    public double getValue() {
        return this.getGaugeValue();
    }

    private double loadValue() {
        if (this.refObj.get() == null) {
            return 0.0;
        }
        return this.mapper.applyAsDouble(this.refObj.get());
    }

    public double getGaugeValue() {
        Double currentValue = this.value.get();
        if (this.shouldLoad() || currentValue == null) {
            double newValue = this.loadValue();
            if (!this.value.compareAndSet(currentValue, newValue)) {
                return this.value.get();
            }
            return newValue;
        }
        return currentValue;
    }

    private boolean shouldLoad() {
        long time;
        long current;
        do {
            time = this.clock.getTick();
            current = this.reloadAt.get();
            if (current <= time) continue;
            return false;
        } while (!this.reloadAt.compareAndSet(current, time + this.timeoutNS));
        return true;
    }
}

