/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.metrics.core.uitls;

import com.codahale.metrics.Clock;
import com.codahale.metrics.EWMA;
import com.codahale.metrics.MovingAverages;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class IoTDBMovingAverage
implements MovingAverages {
    private static final long TICK_INTERVAL = TimeUnit.SECONDS.toNanos(5L);
    private final EWMA m1Rate = EWMA.oneMinuteEWMA();
    private final AtomicLong lastTick;
    private final Clock clock;

    public IoTDBMovingAverage() {
        this(Clock.defaultClock());
    }

    public IoTDBMovingAverage(Clock clock) {
        this.clock = clock;
        this.lastTick = new AtomicLong(this.clock.getTick());
    }

    public void update(long n) {
        this.m1Rate.update(n);
    }

    public void tickIfNecessary() {
        long newIntervalStartTick;
        long oldTick = this.lastTick.get();
        long newTick = this.clock.getTick();
        long age = newTick - oldTick;
        if (age > TICK_INTERVAL && this.lastTick.compareAndSet(oldTick, newIntervalStartTick = newTick - age % TICK_INTERVAL)) {
            long requiredTicks = age / TICK_INTERVAL;
            for (long i = 0L; i < requiredTicks; ++i) {
                this.m1Rate.tick();
            }
        }
    }

    public double getM1Rate() {
        return this.m1Rate.getRate(TimeUnit.SECONDS);
    }

    public double getM5Rate() {
        return 0.0;
    }

    public double getM15Rate() {
        return 0.0;
    }
}

