/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.auth.entity;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.commons.auth.entity.PathPrivilege;
import org.apache.iotdb.commons.auth.entity.Role;
import org.apache.iotdb.commons.utils.SerializeUtils;

public class User
extends Role {
    private String password;
    private List<String> roleList;
    private boolean isOpenIdUser = false;
    private boolean useWaterMark = false;

    public User() {
    }

    public User(String name, String password) {
        super(name);
        this.password = password;
        this.roleList = new ArrayList<String>();
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setUseWaterMark(boolean useWaterMark) {
        this.useWaterMark = useWaterMark;
    }

    public void setOpenIdUser(boolean openIdUser) {
        this.isOpenIdUser = openIdUser;
    }

    public void setRoleList(List<String> roles) {
        this.roleList = roles;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isUseWaterMark() {
        return this.useWaterMark;
    }

    public boolean isOpenIdUser() {
        return this.isOpenIdUser;
    }

    public boolean hasRole(String role) {
        return this.roleList.contains(role);
    }

    public List<String> getRoleList() {
        return this.roleList;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        User user = (User)o;
        return this.contentEquals(user);
    }

    private boolean contentEquals(User user) {
        return Objects.equals(super.getName(), user.getName()) && Objects.equals(this.password, user.password) && Objects.equals(super.getPathPrivilegeList(), user.getPathPrivilegeList()) && Objects.equals(super.getSysPrivilege(), user.getSysPrivilege()) && Objects.equals(this.roleList, user.roleList);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.getName(), this.password, super.getPathPrivilegeList(), super.getSysPrivilege(), this.roleList, this.isOpenIdUser);
    }

    @Override
    public ByteBuffer serialize() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        SerializeUtils.serialize(super.getName(), dataOutputStream);
        SerializeUtils.serialize(this.password, dataOutputStream);
        try {
            dataOutputStream.writeInt(super.getSysPrivilege().size());
            for (Integer item : super.getSysPrivilege()) {
                dataOutputStream.writeInt(item);
            }
            dataOutputStream.writeInt(super.getSysPriGrantOpt().size());
            for (Integer item : super.getSysPriGrantOpt()) {
                dataOutputStream.writeInt(item);
            }
            dataOutputStream.writeInt(super.getPathPrivilegeList().size());
            for (PathPrivilege pathPrivilege : super.getPathPrivilegeList()) {
                dataOutputStream.write(pathPrivilege.serialize().array());
            }
            dataOutputStream.writeBoolean(this.useWaterMark);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        SerializeUtils.serializeStringList(this.roleList, dataOutputStream);
        return ByteBuffer.wrap(byteArrayOutputStream.toByteArray());
    }

    @Override
    public void deserialize(ByteBuffer buffer) {
        super.setName(SerializeUtils.deserializeString(buffer));
        this.password = SerializeUtils.deserializeString(buffer);
        int systemPriSize = buffer.getInt();
        HashSet<Integer> sysPri = new HashSet<Integer>();
        for (int i = 0; i < systemPriSize; ++i) {
            sysPri.add(buffer.getInt());
        }
        super.setSysPrivilegeSet(sysPri);
        int sysPriGrantOptSize = buffer.getInt();
        HashSet<Integer> grantOpt = new HashSet<Integer>();
        for (int i = 0; i < sysPriGrantOptSize; ++i) {
            grantOpt.add(buffer.getInt());
        }
        super.setSysPriGrantOpt(grantOpt);
        int privilegeListSize = buffer.getInt();
        ArrayList<PathPrivilege> privilegeList = new ArrayList<PathPrivilege>(privilegeListSize);
        for (int i = 0; i < privilegeListSize; ++i) {
            PathPrivilege pathPrivilege = new PathPrivilege();
            pathPrivilege.deserialize(buffer);
            privilegeList.add(pathPrivilege);
        }
        super.setPrivilegeList(privilegeList);
        this.useWaterMark = buffer.get() == 1;
        this.roleList = SerializeUtils.deserializeStringList(buffer);
    }

    @Override
    public String toString() {
        return "User{name='" + super.getName() + '\'' + ", password='" + this.password + '\'' + ", pathPrivilegeList=" + super.getPathPrivilegeList() + ", sysPrivilegeSet=" + super.getSysPrivilege() + ", roleList=" + this.roleList + ", isOpenIdUser=" + this.isOpenIdUser + ", useWaterMark=" + this.useWaterMark + '}';
    }
}

