/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.execution.scheduler;

import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.apache.iotdb.commons.pipe.execution.executor.PipeSubtaskExecutor;

public class PipeSubtaskScheduler {
    private final PipeSubtaskExecutor executor;
    private boolean isFirstSchedule = true;
    private static final int BASIC_CHECKPOINT_INTERVAL_BY_CONSUMED_EVENT_COUNT = PipeConfig.getInstance().getPipeSubtaskExecutorBasicCheckPointIntervalByConsumedEventCount();
    private int consumedEventCountCheckpointInterval;
    private int consumedEventCount;
    private static final long BASIC_CHECKPOINT_INTERVAL_BY_TIME_DURATION = PipeConfig.getInstance().getPipeSubtaskExecutorBasicCheckPointIntervalByTimeDuration();
    private long timeDurationCheckpointInterval;
    private long lastCheckTime;

    public PipeSubtaskScheduler(PipeSubtaskExecutor executor) {
        this.executor = executor;
    }

    public boolean schedule() {
        if (this.isFirstSchedule) {
            this.isFirstSchedule = false;
            this.adjustCheckpointIntervalBasedOnExecutorStatus();
            ++this.consumedEventCount;
            return true;
        }
        if (this.consumedEventCount < this.consumedEventCountCheckpointInterval && System.currentTimeMillis() - this.lastCheckTime < this.timeDurationCheckpointInterval) {
            ++this.consumedEventCount;
            return true;
        }
        return false;
    }

    private void adjustCheckpointIntervalBasedOnExecutorStatus() {
        this.consumedEventCount = 0;
        this.lastCheckTime = System.currentTimeMillis();
        int corePoolSize = Math.max(1, this.executor.getCorePoolSize());
        int runningSubtaskNumber = Math.max(1, this.executor.getRunningSubtaskNumber());
        this.consumedEventCountCheckpointInterval = Math.max(1, (int)((float)BASIC_CHECKPOINT_INTERVAL_BY_CONSUMED_EVENT_COUNT / (float)runningSubtaskNumber * (float)corePoolSize));
        this.timeDurationCheckpointInterval = Math.max(1L, (long)((float)BASIC_CHECKPOINT_INTERVAL_BY_TIME_DURATION / (float)runningSubtaskNumber * (float)corePoolSize));
    }

    public void reset() {
        this.isFirstSchedule = true;
    }
}

