/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.schema.node.common;

import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.schema.node.IMNode;
import org.apache.iotdb.commons.schema.node.MNodeType;
import org.apache.iotdb.commons.schema.node.info.IMeasurementInfo;
import org.apache.iotdb.commons.schema.node.role.IDatabaseMNode;
import org.apache.iotdb.commons.schema.node.role.IDeviceMNode;
import org.apache.iotdb.commons.schema.node.role.IInternalMNode;
import org.apache.iotdb.commons.schema.node.role.IMeasurementMNode;
import org.apache.iotdb.commons.schema.node.utils.IMNodeContainer;
import org.apache.iotdb.commons.schema.node.visitor.MNodeVisitor;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMeasurementMNode<N extends IMNode<N>, BasicNode extends IMNode<N>>
implements IMeasurementMNode<N> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractMeasurementMNode.class);
    private final IMeasurementInfo measurementInfo;
    protected final BasicNode basicMNode;

    public AbstractMeasurementMNode(BasicNode basicMNode, IMeasurementInfo measurementInfo) {
        this.basicMNode = basicMNode;
        this.measurementInfo = measurementInfo;
    }

    public BasicNode getBasicMNode() {
        return this.basicMNode;
    }

    @Override
    public String getName() {
        return this.basicMNode.getName();
    }

    @Override
    public void setName(String name) {
        this.basicMNode.setName(name);
    }

    @Override
    public N getParent() {
        if (this.basicMNode.getParent() == null) {
            return null;
        }
        return this.basicMNode.getParent();
    }

    @Override
    public void setParent(N parent) {
        this.basicMNode.setParent(parent);
    }

    @Override
    public MeasurementPath getMeasurementPath() {
        MeasurementPath result = new MeasurementPath(this.getPartialPath(), this.getSchema());
        result.setUnderAlignedEntity(this.getParent().getAsDeviceMNode().isAlignedNullable());
        return result;
    }

    @Override
    public IMeasurementSchema getSchema() {
        return this.measurementInfo.getSchema();
    }

    @Override
    public void setSchema(IMeasurementSchema schema) {
        this.measurementInfo.setSchema(schema);
    }

    @Override
    public TSDataType getDataType() {
        return this.measurementInfo.getDataType();
    }

    @Override
    public long getOffset() {
        return this.measurementInfo.getOffset();
    }

    @Override
    public void setOffset(long offset) {
        this.measurementInfo.setOffset(offset);
    }

    @Override
    public String getAlias() {
        return this.measurementInfo.getAlias();
    }

    @Override
    public void setAlias(String alias) {
        this.measurementInfo.setAlias(alias);
    }

    @Override
    public boolean isPreDeleted() {
        return this.measurementInfo.isPreDeleted();
    }

    @Override
    public void setPreDeleted(boolean preDeleted) {
        this.measurementInfo.setPreDeleted(preDeleted);
    }

    @Override
    public <R, C> R accept(MNodeVisitor<R, C> visitor, C context) {
        return visitor.visitMeasurementMNode(this, context);
    }

    @Override
    public String getFullPath() {
        return this.basicMNode.getFullPath();
    }

    @Override
    public void setFullPath(String fullPath) {
        this.basicMNode.setFullPath(fullPath);
    }

    @Override
    public PartialPath getPartialPath() {
        return this.basicMNode.getPartialPath();
    }

    @Override
    public boolean hasChild(String name) {
        return false;
    }

    @Override
    public N getChild(String name) {
        logger.warn("current node {} is a MeasurementMNode, can not get child {}", (Object)this.getName(), (Object)name);
        throw new RuntimeException(String.format("current node %s is a MeasurementMNode, can not get child %s", this.getName(), name));
    }

    @Override
    public N addChild(String name, N child) {
        return null;
    }

    @Override
    public N addChild(N child) {
        return null;
    }

    @Override
    public N deleteChild(String name) {
        return null;
    }

    @Override
    public void setChildren(IMNodeContainer<N> children) {
    }

    @Override
    public boolean isAboveDatabase() {
        return false;
    }

    @Override
    public boolean isDatabase() {
        return false;
    }

    @Override
    public boolean isDevice() {
        return false;
    }

    @Override
    public boolean isMeasurement() {
        return true;
    }

    @Override
    public MNodeType getMNodeType() {
        return MNodeType.MEASUREMENT;
    }

    @Override
    public IDatabaseMNode<N> getAsDatabaseMNode() {
        throw new UnsupportedOperationException("Wrong MNode Type");
    }

    @Override
    public IDeviceMNode<N> getAsDeviceMNode() {
        throw new UnsupportedOperationException("Wrong MNode Type");
    }

    @Override
    public IInternalMNode<N> getAsInternalMNode() {
        throw new UnsupportedOperationException("Wrong MNode Type");
    }

    @Override
    public IMeasurementMNode<N> getAsMeasurementMNode() {
        return this;
    }

    @Override
    public int estimateSize() {
        return 16 + this.measurementInfo.estimateSize() + this.basicMNode.estimateSize();
    }

    protected IMeasurementInfo getMeasurementInfo() {
        return this.measurementInfo;
    }
}

