/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.udf.builtin;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

public enum BuiltinAggregationFunction {
    MIN_TIME("min_time"),
    MAX_TIME("max_time"),
    MAX_VALUE("max_value"),
    MIN_VALUE("min_value"),
    EXTREME("extreme"),
    FIRST_VALUE("first_value"),
    LAST_VALUE("last_value"),
    COUNT("count"),
    AVG("avg"),
    SUM("sum"),
    COUNT_IF("count_if"),
    TIME_DURATION("time_duration"),
    MODE("mode"),
    COUNT_TIME("count_time"),
    STDDEV("stddev"),
    STDDEV_POP("stddev_pop"),
    STDDEV_SAMP("stddev_samp"),
    VARIANCE("variance"),
    VAR_POP("var_pop"),
    VAR_SAMP("var_samp");

    private final String functionName;
    private static final Set<String> NATIVE_FUNCTION_NAMES;

    private BuiltinAggregationFunction(String functionName) {
        this.functionName = functionName;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public static Set<String> getNativeFunctionNames() {
        return NATIVE_FUNCTION_NAMES;
    }

    public static boolean canUseStatistics(String name) {
        String functionName;
        switch (functionName = name.toLowerCase()) {
            case "min_time": 
            case "max_time": 
            case "max_value": 
            case "min_value": 
            case "extreme": 
            case "first_value": 
            case "last_value": 
            case "count": 
            case "avg": 
            case "sum": 
            case "time_duration": {
                return true;
            }
            case "count_if": 
            case "mode": 
            case "count_time": 
            case "stddev": 
            case "stddev_pop": 
            case "stddev_samp": 
            case "variance": 
            case "var_pop": 
            case "var_samp": {
                return false;
            }
        }
        throw new IllegalArgumentException("Invalid Aggregation function: " + name);
    }

    public static boolean canSplitToMultiPhases(String name) {
        String functionName;
        switch (functionName = name.toLowerCase()) {
            case "min_time": 
            case "max_time": 
            case "max_value": 
            case "min_value": 
            case "extreme": 
            case "first_value": 
            case "last_value": 
            case "count": 
            case "avg": 
            case "sum": 
            case "time_duration": 
            case "mode": 
            case "stddev": 
            case "stddev_pop": 
            case "stddev_samp": 
            case "variance": 
            case "var_pop": 
            case "var_samp": {
                return true;
            }
            case "count_if": 
            case "count_time": {
                return false;
            }
        }
        throw new IllegalArgumentException("Invalid Aggregation function: " + name);
    }

    static {
        NATIVE_FUNCTION_NAMES = new HashSet<String>(Arrays.stream(BuiltinAggregationFunction.values()).map(BuiltinAggregationFunction::getFunctionName).collect(Collectors.toList()));
    }
}

