/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.udf.builtin.String;

import java.io.IOException;
import org.apache.iotdb.tsfile.common.conf.TSFileConfig;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnBuilder;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.BytesUtils;
import org.apache.iotdb.udf.api.UDTF;
import org.apache.iotdb.udf.api.access.Row;
import org.apache.iotdb.udf.api.collector.PointCollector;
import org.apache.iotdb.udf.api.customizer.config.UDTFConfigurations;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameterValidator;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameters;
import org.apache.iotdb.udf.api.customizer.strategy.AccessStrategy;
import org.apache.iotdb.udf.api.customizer.strategy.MappableRowByRowAccessStrategy;
import org.apache.iotdb.udf.api.type.Type;

public class UDTFLower
implements UDTF {
    public void validate(UDFParameterValidator validator) throws Exception {
        validator.validateInputSeriesNumber(1).validateInputSeriesDataType(0, Type.TEXT);
    }

    public void beforeStart(UDFParameters parameters, UDTFConfigurations configurations) throws Exception {
        configurations.setAccessStrategy((AccessStrategy)new MappableRowByRowAccessStrategy()).setOutputDataType(Type.TEXT);
    }

    public void transform(Row row, PointCollector collector) throws Exception {
        collector.putString(row.getTime(), row.getString(0).toLowerCase());
    }

    public Object transform(Row row) throws IOException {
        if (row.isNull(0)) {
            return null;
        }
        return BytesUtils.valueOf((String)row.getString(0).toLowerCase());
    }

    public void transform(Column[] columns, ColumnBuilder builder) throws Exception {
        Binary[] inputs = columns[0].getBinaries();
        boolean[] isNulls = columns[0].isNull();
        int count = columns[0].getPositionCount();
        for (int i = 0; i < count; ++i) {
            if (isNulls[i]) {
                builder.appendNull();
                continue;
            }
            String str = inputs[i].getStringValue(TSFileConfig.STRING_CHARSET);
            String res = str.toLowerCase();
            builder.writeBinary(BytesUtils.valueOf((String)res));
        }
    }
}

