/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.common.block;

import org.apache.iotdb.tsfile.read.common.block.column.ColumnBuilderStatus;

public class TsBlockBuilderStatus {
    private final int maxTsBlockSizeInBytes;
    private long currentSize;

    public TsBlockBuilderStatus(int maxTsBlockSizeInBytes) {
        this.maxTsBlockSizeInBytes = maxTsBlockSizeInBytes;
    }

    public ColumnBuilderStatus createColumnBuilderStatus() {
        return new ColumnBuilderStatus(this);
    }

    public int getMaxTsBlockSizeInBytes() {
        return this.maxTsBlockSizeInBytes;
    }

    public boolean isEmpty() {
        return this.currentSize == 0L;
    }

    public boolean isFull() {
        return this.currentSize >= (long)this.maxTsBlockSizeInBytes;
    }

    public void addBytes(int bytes) {
        if (bytes < 0) {
            throw new IllegalArgumentException("bytes cannot be negative");
        }
        this.currentSize += (long)bytes;
    }

    public long getSizeInBytes() {
        return this.currentSize;
    }

    public String toString() {
        return "TsBlockBuilderStatus{maxTsBlockSizeInBytes=" + this.maxTsBlockSizeInBytes + ", currentSize=" + this.currentSize + '}';
    }
}

