/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.file.metadata;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.iotdb.tsfile.file.metadata.MetadataIndexNode;
import org.apache.iotdb.tsfile.utils.BloomFilter;
import org.apache.iotdb.tsfile.utils.ReadWriteForEncodingUtils;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class TsFileMetadata {
    private BloomFilter bloomFilter;
    private MetadataIndexNode metadataIndex;
    private long metaOffset;

    public static TsFileMetadata deserializeFrom(ByteBuffer buffer) {
        TsFileMetadata fileMetaData = new TsFileMetadata();
        fileMetaData.metadataIndex = MetadataIndexNode.deserializeFrom(buffer);
        long metaOffset = ReadWriteIOUtils.readLong(buffer);
        fileMetaData.setMetaOffset(metaOffset);
        if (buffer.hasRemaining()) {
            byte[] bytes = ReadWriteIOUtils.readByteBufferWithSelfDescriptionLength(buffer);
            int filterSize = ReadWriteForEncodingUtils.readUnsignedVarInt(buffer);
            int hashFunctionSize = ReadWriteForEncodingUtils.readUnsignedVarInt(buffer);
            fileMetaData.bloomFilter = BloomFilter.buildBloomFilter(bytes, filterSize, hashFunctionSize);
        }
        return fileMetaData;
    }

    public BloomFilter getBloomFilter() {
        return this.bloomFilter;
    }

    public void setBloomFilter(BloomFilter bloomFilter) {
        this.bloomFilter = bloomFilter;
    }

    public int serializeTo(OutputStream outputStream) throws IOException {
        int byteLen = 0;
        byteLen = this.metadataIndex != null ? (byteLen += this.metadataIndex.serializeTo(outputStream)) : (byteLen += ReadWriteIOUtils.write(0, outputStream));
        return byteLen += ReadWriteIOUtils.write(this.metaOffset, outputStream);
    }

    public int serializeBloomFilter(OutputStream outputStream, BloomFilter filter) throws IOException {
        int byteLen = 0;
        byte[] bytes = filter.serialize();
        byteLen += ReadWriteForEncodingUtils.writeUnsignedVarInt(bytes.length, outputStream);
        outputStream.write(bytes);
        byteLen += bytes.length;
        byteLen += ReadWriteForEncodingUtils.writeUnsignedVarInt(filter.getSize(), outputStream);
        return byteLen += ReadWriteForEncodingUtils.writeUnsignedVarInt(filter.getHashFunctionSize(), outputStream);
    }

    public long getMetaOffset() {
        return this.metaOffset;
    }

    public void setMetaOffset(long metaOffset) {
        this.metaOffset = metaOffset;
    }

    public MetadataIndexNode getMetadataIndex() {
        return this.metadataIndex;
    }

    public void setMetadataIndex(MetadataIndexNode metadataIndex) {
        this.metadataIndex = metadataIndex;
    }
}

