/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.common.block.column;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnEncoder;
import org.apache.iotdb.tsfile.read.common.block.column.DoubleColumn;
import org.apache.iotdb.tsfile.read.common.block.column.LongColumn;
import org.apache.iotdb.tsfile.read.common.block.column.TimeColumn;

public class Int64ArrayColumnEncoder
implements ColumnEncoder {
    @Override
    public TimeColumn readTimeColumn(ByteBuffer input, int positionCount) {
        boolean[] nullIndicators = ColumnEncoder.deserializeNullIndicators(input, positionCount);
        long[] values = new long[positionCount];
        if (nullIndicators == null) {
            for (int i = 0; i < positionCount; ++i) {
                values[i] = input.getLong();
            }
            return new TimeColumn(0, positionCount, values);
        }
        throw new IllegalArgumentException("TimeColumn should not contain null values.");
    }

    @Override
    public Column readColumn(ByteBuffer input, TSDataType dataType, int positionCount) {
        boolean[] nullIndicators = ColumnEncoder.deserializeNullIndicators(input, positionCount);
        if (TSDataType.INT64.equals((Object)dataType)) {
            long[] values = new long[positionCount];
            if (nullIndicators == null) {
                for (int i = 0; i < positionCount; ++i) {
                    values[i] = input.getLong();
                }
            } else {
                for (int i = 0; i < positionCount; ++i) {
                    if (nullIndicators[i]) continue;
                    values[i] = input.getLong();
                }
            }
            return new LongColumn(0, positionCount, nullIndicators, values);
        }
        if (TSDataType.DOUBLE.equals((Object)dataType)) {
            double[] values = new double[positionCount];
            if (nullIndicators == null) {
                for (int i = 0; i < positionCount; ++i) {
                    values[i] = Double.longBitsToDouble(input.getLong());
                }
            } else {
                for (int i = 0; i < positionCount; ++i) {
                    if (nullIndicators[i]) continue;
                    values[i] = Double.longBitsToDouble(input.getLong());
                }
            }
            return new DoubleColumn(0, positionCount, nullIndicators, values);
        }
        throw new IllegalArgumentException("Invalid data type: " + dataType);
    }

    @Override
    public void writeColumn(DataOutputStream output, Column column) throws IOException {
        ColumnEncoder.serializeNullIndicators(output, column);
        TSDataType dataType = column.getDataType();
        int positionCount = column.getPositionCount();
        if (TSDataType.INT64.equals((Object)dataType)) {
            for (int i = 0; i < positionCount; ++i) {
                if (column.isNull(i)) continue;
                output.writeLong(column.getLong(i));
            }
        } else if (TSDataType.DOUBLE.equals((Object)dataType)) {
            for (int i = 0; i < positionCount; ++i) {
                if (column.isNull(i)) continue;
                output.writeLong(Double.doubleToLongBits(column.getDouble(i)));
            }
        } else {
            throw new IllegalArgumentException("Invalid data type: " + dataType);
        }
    }
}

