/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.common.block.column;

import java.util.Objects;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.block.column.BinaryColumnBuilder;
import org.apache.iotdb.tsfile.read.common.block.column.BooleanColumn;
import org.apache.iotdb.tsfile.read.common.block.column.BooleanColumnBuilder;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnEncoding;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnUtil;
import org.apache.iotdb.tsfile.read.common.block.column.DoubleColumnBuilder;
import org.apache.iotdb.tsfile.read.common.block.column.FloatColumnBuilder;
import org.apache.iotdb.tsfile.read.common.block.column.IntColumnBuilder;
import org.apache.iotdb.tsfile.read.common.block.column.LongColumnBuilder;
import org.apache.iotdb.tsfile.read.common.block.column.RunLengthEncodedColumn;
import org.openjdk.jol.info.ClassLayout;

public class NullColumn
implements Column {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(BooleanColumn.class).instanceSize();
    private final int positionCount;
    private final long retainedSizeInBytes;

    public NullColumn(int positionCount) {
        if (positionCount < 0) {
            throw new IllegalArgumentException("positionCount is negative");
        }
        this.positionCount = positionCount;
        this.retainedSizeInBytes = INSTANCE_SIZE;
    }

    public TSDataType getDataType() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public ColumnEncoding getEncoding() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public boolean mayHaveNull() {
        return true;
    }

    public boolean isNull(int position) {
        return true;
    }

    public boolean[] isNull() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public int getPositionCount() {
        return this.positionCount;
    }

    public long getRetainedSizeInBytes() {
        return this.retainedSizeInBytes;
    }

    public Column getRegion(int positionOffset, int length) {
        ColumnUtil.checkValidRegion(this.getPositionCount(), positionOffset, length);
        return new NullColumn(length);
    }

    public Column subColumn(int fromIndex) {
        if (fromIndex > this.positionCount) {
            throw new IllegalArgumentException("fromIndex is not valid");
        }
        return new NullColumn(this.positionCount - fromIndex);
    }

    public void reverse() {
    }

    public static Column create(TSDataType dataType, int positionCount) {
        Objects.requireNonNull(dataType, "dataType is null");
        switch (dataType) {
            case BOOLEAN: {
                return new RunLengthEncodedColumn(BooleanColumnBuilder.NULL_VALUE_BLOCK, positionCount);
            }
            case INT32: {
                return new RunLengthEncodedColumn(IntColumnBuilder.NULL_VALUE_BLOCK, positionCount);
            }
            case INT64: {
                return new RunLengthEncodedColumn(LongColumnBuilder.NULL_VALUE_BLOCK, positionCount);
            }
            case FLOAT: {
                return new RunLengthEncodedColumn(FloatColumnBuilder.NULL_VALUE_BLOCK, positionCount);
            }
            case DOUBLE: {
                return new RunLengthEncodedColumn(DoubleColumnBuilder.NULL_VALUE_BLOCK, positionCount);
            }
            case TEXT: {
                return new RunLengthEncodedColumn(BinaryColumnBuilder.NULL_VALUE_BLOCK, positionCount);
            }
        }
        throw new IllegalArgumentException("Unknown data type: " + dataType);
    }

    public int getInstanceSize() {
        return INSTANCE_SIZE;
    }
}

