/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.client.async.handlers.heartbeat;

import org.apache.iotdb.commons.client.ThriftClient;
import org.apache.iotdb.commons.cluster.NodeStatus;
import org.apache.iotdb.commons.cluster.NodeType;
import org.apache.iotdb.confignode.manager.IManager;
import org.apache.iotdb.confignode.manager.load.cache.LoadCache;
import org.apache.iotdb.confignode.manager.load.cache.node.NodeHeartbeatSample;
import org.apache.iotdb.confignode.rpc.thrift.TConfigNodeHeartbeatResp;
import org.apache.thrift.async.AsyncMethodCallback;

public class ConfigNodeHeartbeatHandler
implements AsyncMethodCallback<TConfigNodeHeartbeatResp> {
    private final IManager configManager;
    private final int nodeId;
    private final LoadCache loadCache;

    public ConfigNodeHeartbeatHandler(IManager configManager, int nodeId, LoadCache loadCache) {
        this.configManager = configManager;
        this.nodeId = nodeId;
        this.loadCache = loadCache;
    }

    public void onComplete(TConfigNodeHeartbeatResp resp) {
        this.loadCache.cacheConfigNodeHeartbeatSample(this.nodeId, resp);
    }

    public void onError(Exception e) {
        if (ThriftClient.isConnectionBroken((Throwable)e)) {
            this.loadCache.forceUpdateNodeCache(NodeType.ConfigNode, this.nodeId, NodeHeartbeatSample.generateDefaultSample(NodeStatus.Unknown));
        }
    }
}

