/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.conf;

import java.io.File;
import java.lang.reflect.Field;
import java.util.Arrays;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.confignode.conf.ConfigNodeConstant;
import org.apache.iotdb.confignode.manager.load.balancer.RegionBalancer;
import org.apache.iotdb.confignode.manager.partition.RegionGroupExtensionPolicy;

public class ConfigNodeConfig {
    private volatile String clusterName = "defaultCluster";
    private volatile int configNodeId = -1;
    private String internalAddress = "127.0.0.1";
    private int internalPort = 10710;
    private int consensusPort = 10720;
    private TEndPoint seedConfigNode = new TEndPoint("127.0.0.1", 10710);
    private int configRegionId = 0;
    private String configNodeConsensusProtocolClass = "org.apache.iotdb.consensus.ratis.RatisConsensus";
    private String schemaRegionConsensusProtocolClass = "org.apache.iotdb.consensus.ratis.RatisConsensus";
    private int schemaReplicationFactor = 1;
    private String dataRegionConsensusProtocolClass = "org.apache.iotdb.consensus.iot.IoTConsensus";
    private int dataReplicationFactor = 1;
    private int seriesSlotNum = 1000;
    private String seriesPartitionExecutorClass = "org.apache.iotdb.commons.partition.executor.hash.BKDRHashExecutor";
    private RegionGroupExtensionPolicy schemaRegionGroupExtensionPolicy = RegionGroupExtensionPolicy.AUTO;
    private int defaultSchemaRegionGroupNumPerDatabase = 1;
    private double schemaRegionPerDataNode = this.schemaReplicationFactor;
    private RegionGroupExtensionPolicy dataRegionGroupExtensionPolicy = RegionGroupExtensionPolicy.AUTO;
    private int defaultDataRegionGroupNumPerDatabase = 2;
    private double dataRegionPerDataNode = 5.0;
    private RegionBalancer.RegionGroupAllocatePolicy regionGroupAllocatePolicy = RegionBalancer.RegionGroupAllocatePolicy.GREEDY_COPY_SET;
    private int rpcMaxConcurrentClientNum = 65535;
    private boolean rpcAdvancedCompressionEnable = false;
    private int thriftMaxFrameSize = 0x20000000;
    private int thriftDefaultBufferSize = 1024;
    private int thriftServerAwaitTimeForStopService = 60;
    private int maxClientNumForEachNode = 300;
    private String systemDir = ConfigNodeConstant.DATA_DIR + File.separator + "system";
    private String consensusDir = ConfigNodeConstant.DATA_DIR + File.separator + "consensus";
    private String extLibDir = "ext";
    private String udfDir = "ext" + File.separator + "udf";
    private String udfTemporaryLibDir = this.udfDir + File.separator + "tmp";
    private String triggerDir = "ext" + File.separator + "trigger";
    private String triggerTemporaryLibDir = this.triggerDir + File.separator + "tmp";
    private String pipeDir = "ext" + File.separator + "pipe";
    private String pipeTemporaryLibDir = this.pipeDir + File.separator + "tmp";
    private int procedureCompletedEvictTTL = 800;
    private int procedureCompletedCleanInterval = 30;
    private int procedureCoreWorkerThreadsCount = Math.max(Runtime.getRuntime().availableProcessors() / 4, 16);
    private long heartbeatIntervalInMs;
    private long unknownDataNodeDetectInterval = this.heartbeatIntervalInMs = 1000L;
    private String leaderDistributionPolicy = "MIN_COST_FLOW";
    private boolean enableAutoLeaderBalanceForRatisConsensus = true;
    private boolean enableAutoLeaderBalanceForIoTConsensus = true;
    private String routePriorityPolicy = "LEADER";
    private String readConsistencyLevel = "strong";
    private long dataRegionRatisConsensusLogAppenderBufferSize = 0x1000000L;
    private long configNodeRatisConsensusLogAppenderBufferSize = 0x1000000L;
    private long schemaRegionRatisConsensusLogAppenderBufferSize = 0x1000000L;
    private long dataRegionRatisSnapshotTriggerThreshold = 400000L;
    private long configNodeRatisSnapshotTriggerThreshold = 400000L;
    private long schemaRegionRatisSnapshotTriggerThreshold = 400000L;
    private boolean dataRegionRatisLogUnsafeFlushEnable = false;
    private boolean configNodeRatisLogUnsafeFlushEnable = false;
    private boolean schemaRegionRatisLogUnsafeFlushEnable = false;
    private long dataRegionRatisLogSegmentSizeMax = 0x1800000L;
    private long configNodeRatisLogSegmentSizeMax = 0x1800000L;
    private long schemaRegionRatisLogSegmentSizeMax = 0x1800000L;
    private long configNodeSimpleConsensusLogSegmentSizeMax = 0x1800000L;
    private long dataRegionRatisGrpcFlowControlWindow = 0x400000L;
    private int configNodeRatisGrpcLeaderOutstandingAppendsMax = 128;
    private int schemaRegionRatisGrpcLeaderOutstandingAppendsMax = 128;
    private int dataRegionRatisGrpcLeaderOutstandingAppendsMax = 128;
    private int configNodeRatisLogForceSyncNum = 128;
    private int schemaRegionRatisLogForceSyncNum = 128;
    private int dataRegionRatisLogForceSyncNum = 128;
    private long configNodeRatisGrpcFlowControlWindow = 0x400000L;
    private long schemaRegionRatisGrpcFlowControlWindow = 0x400000L;
    private long dataRegionRatisRpcLeaderElectionTimeoutMinMs = 2000L;
    private long configNodeRatisRpcLeaderElectionTimeoutMinMs = 2000L;
    private long schemaRegionRatisRpcLeaderElectionTimeoutMinMs = 2000L;
    private long dataRegionRatisRpcLeaderElectionTimeoutMaxMs = 4000L;
    private long configNodeRatisRpcLeaderElectionTimeoutMaxMs = 4000L;
    private long schemaRegionRatisRpcLeaderElectionTimeoutMaxMs = 4000L;
    private int cqSubmitThread = 2;
    private long cqMinEveryIntervalInMs = 1000L;
    private long dataRegionRatisRequestTimeoutMs = 10000L;
    private long configNodeRatisRequestTimeoutMs = 10000L;
    private long schemaRegionRatisRequestTimeoutMs = 10000L;
    private int configNodeRatisMaxRetryAttempts = 10;
    private long configNodeRatisInitialSleepTimeMs = 100L;
    private long configNodeRatisMaxSleepTimeMs = 10000L;
    private int dataRegionRatisMaxRetryAttempts = 10;
    private long dataRegionRatisInitialSleepTimeMs = 100L;
    private long dataRegionRatisMaxSleepTimeMs = 10000L;
    private int schemaRegionRatisMaxRetryAttempts = 10;
    private long schemaRegionRatisInitialSleepTimeMs = 100L;
    private long schemaRegionRatisMaxSleepTimeMs = 10000L;
    private long configNodeRatisPreserveLogsWhenPurge = 1000L;
    private long schemaRegionRatisPreserveLogsWhenPurge = 1000L;
    private long dataRegionRatisPreserveLogsWhenPurge = 1000L;
    private long ratisFirstElectionTimeoutMinMs = 50L;
    private long ratisFirstElectionTimeoutMaxMs = 150L;
    private long configNodeRatisLogMax = 0x80000000L;
    private long schemaRegionRatisLogMax = 0x80000000L;
    private long dataRegionRatisLogMax = 0x500000000L;
    private long configNodeRatisPeriodicSnapshotInterval = 86400L;
    private long schemaRegionRatisPeriodicSnapshotInterval = 86400L;
    private long dataRegionRatisPeriodicSnapshotInterval = 86400L;
    private boolean isEnablePrintingNewlyCreatedPartition = false;
    private long forceWalPeriodForConfigNodeSimpleInMs = 100L;

    public void updatePath() {
        this.formulateFolders();
    }

    private void formulateFolders() {
        this.systemDir = this.addHomeDir(this.systemDir);
        this.consensusDir = this.addHomeDir(this.consensusDir);
        this.extLibDir = this.addHomeDir(this.extLibDir);
        this.udfDir = this.addHomeDir(this.udfDir);
        this.udfTemporaryLibDir = this.addHomeDir(this.udfTemporaryLibDir);
        this.triggerDir = this.addHomeDir(this.triggerDir);
        this.triggerTemporaryLibDir = this.addHomeDir(this.triggerTemporaryLibDir);
        this.pipeDir = this.addHomeDir(this.pipeDir);
        this.pipeTemporaryLibDir = this.addHomeDir(this.pipeTemporaryLibDir);
    }

    private String addHomeDir(String dir) {
        String homeDir = System.getProperty("CONFIGNODE_HOME", null);
        if (!new File(dir).isAbsolute() && homeDir != null && homeDir.length() > 0) {
            dir = !homeDir.endsWith(File.separator) ? homeDir + File.separatorChar + dir : homeDir + dir;
        }
        return dir;
    }

    public static String getEnvironmentVariables() {
        return "\n\tCONFIGNODE_HOME=" + System.getProperty("CONFIGNODE_HOME", "null") + ";\n\t" + "CONFIGNODE_CONF" + "=" + System.getProperty("CONFIGNODE_CONF", "null") + ";";
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public int getConfigNodeId() {
        return this.configNodeId;
    }

    public void setConfigNodeId(int configNodeId) {
        this.configNodeId = configNodeId;
    }

    public String getInternalAddress() {
        return this.internalAddress;
    }

    public void setInternalAddress(String internalAddress) {
        this.internalAddress = internalAddress;
    }

    public int getInternalPort() {
        return this.internalPort;
    }

    public void setInternalPort(int internalPort) {
        this.internalPort = internalPort;
    }

    public int getConsensusPort() {
        return this.consensusPort;
    }

    public void setConsensusPort(int consensusPort) {
        this.consensusPort = consensusPort;
    }

    public TEndPoint getSeedConfigNode() {
        return this.seedConfigNode;
    }

    public void setSeedConfigNode(TEndPoint seedConfigNode) {
        this.seedConfigNode = seedConfigNode;
    }

    public int getConfigRegionId() {
        return this.configRegionId;
    }

    public void setConfigRegionId(int configRegionId) {
        this.configRegionId = configRegionId;
    }

    public int getSeriesSlotNum() {
        return this.seriesSlotNum;
    }

    public void setSeriesSlotNum(int seriesSlotNum) {
        this.seriesSlotNum = seriesSlotNum;
    }

    public String getSeriesPartitionExecutorClass() {
        return this.seriesPartitionExecutorClass;
    }

    public void setSeriesPartitionExecutorClass(String seriesPartitionExecutorClass) {
        this.seriesPartitionExecutorClass = seriesPartitionExecutorClass;
    }

    public int getCnRpcMaxConcurrentClientNum() {
        return this.rpcMaxConcurrentClientNum;
    }

    public void setCnRpcMaxConcurrentClientNum(int rpcMaxConcurrentClientNum) {
        this.rpcMaxConcurrentClientNum = rpcMaxConcurrentClientNum;
    }

    public boolean isCnRpcAdvancedCompressionEnable() {
        return this.rpcAdvancedCompressionEnable;
    }

    public void setCnRpcAdvancedCompressionEnable(boolean rpcAdvancedCompressionEnable) {
        this.rpcAdvancedCompressionEnable = rpcAdvancedCompressionEnable;
    }

    public int getCnThriftMaxFrameSize() {
        return this.thriftMaxFrameSize;
    }

    public void setCnThriftMaxFrameSize(int thriftMaxFrameSize) {
        this.thriftMaxFrameSize = thriftMaxFrameSize;
    }

    public int getCnThriftDefaultBufferSize() {
        return this.thriftDefaultBufferSize;
    }

    public void setCnThriftDefaultBufferSize(int thriftDefaultBufferSize) {
        this.thriftDefaultBufferSize = thriftDefaultBufferSize;
    }

    public int getMaxClientNumForEachNode() {
        return this.maxClientNumForEachNode;
    }

    public ConfigNodeConfig setMaxClientNumForEachNode(int maxClientNumForEachNode) {
        this.maxClientNumForEachNode = maxClientNumForEachNode;
        return this;
    }

    public String getConsensusDir() {
        return this.consensusDir;
    }

    public void setConsensusDir(String consensusDir) {
        this.consensusDir = consensusDir;
    }

    public String getConfigNodeConsensusProtocolClass() {
        return this.configNodeConsensusProtocolClass;
    }

    public void setConfigNodeConsensusProtocolClass(String configNodeConsensusProtocolClass) {
        this.configNodeConsensusProtocolClass = configNodeConsensusProtocolClass;
    }

    public String getSchemaRegionConsensusProtocolClass() {
        return this.schemaRegionConsensusProtocolClass;
    }

    public void setSchemaRegionConsensusProtocolClass(String schemaRegionConsensusProtocolClass) {
        this.schemaRegionConsensusProtocolClass = schemaRegionConsensusProtocolClass;
    }

    public RegionGroupExtensionPolicy getSchemaRegionGroupExtensionPolicy() {
        return this.schemaRegionGroupExtensionPolicy;
    }

    public void setSchemaRegionGroupExtensionPolicy(RegionGroupExtensionPolicy schemaRegionGroupExtensionPolicy) {
        this.schemaRegionGroupExtensionPolicy = schemaRegionGroupExtensionPolicy;
    }

    public int getDefaultSchemaRegionGroupNumPerDatabase() {
        return this.defaultSchemaRegionGroupNumPerDatabase;
    }

    public void setDefaultSchemaRegionGroupNumPerDatabase(int defaultSchemaRegionGroupNumPerDatabase) {
        this.defaultSchemaRegionGroupNumPerDatabase = defaultSchemaRegionGroupNumPerDatabase;
    }

    public RegionGroupExtensionPolicy getDataRegionGroupExtensionPolicy() {
        return this.dataRegionGroupExtensionPolicy;
    }

    public void setDataRegionGroupExtensionPolicy(RegionGroupExtensionPolicy dataRegionGroupExtensionPolicy) {
        this.dataRegionGroupExtensionPolicy = dataRegionGroupExtensionPolicy;
    }

    public int getDefaultDataRegionGroupNumPerDatabase() {
        return this.defaultDataRegionGroupNumPerDatabase;
    }

    public void setDefaultDataRegionGroupNumPerDatabase(int defaultDataRegionGroupNumPerDatabase) {
        this.defaultDataRegionGroupNumPerDatabase = defaultDataRegionGroupNumPerDatabase;
    }

    public double getSchemaRegionPerDataNode() {
        return this.schemaRegionPerDataNode;
    }

    public void setSchemaRegionPerDataNode(double schemaRegionPerDataNode) {
        this.schemaRegionPerDataNode = schemaRegionPerDataNode;
    }

    public String getDataRegionConsensusProtocolClass() {
        return this.dataRegionConsensusProtocolClass;
    }

    public void setDataRegionConsensusProtocolClass(String dataRegionConsensusProtocolClass) {
        this.dataRegionConsensusProtocolClass = dataRegionConsensusProtocolClass;
    }

    public double getDataRegionPerDataNode() {
        return this.dataRegionPerDataNode;
    }

    public void setDataRegionPerDataNode(double dataRegionPerDataNode) {
        this.dataRegionPerDataNode = dataRegionPerDataNode;
    }

    public RegionBalancer.RegionGroupAllocatePolicy getRegionGroupAllocatePolicy() {
        return this.regionGroupAllocatePolicy;
    }

    public void setRegionAllocateStrategy(RegionBalancer.RegionGroupAllocatePolicy regionGroupAllocatePolicy) {
        this.regionGroupAllocatePolicy = regionGroupAllocatePolicy;
    }

    public int getThriftServerAwaitTimeForStopService() {
        return this.thriftServerAwaitTimeForStopService;
    }

    public void setThriftServerAwaitTimeForStopService(int thriftServerAwaitTimeForStopService) {
        this.thriftServerAwaitTimeForStopService = thriftServerAwaitTimeForStopService;
    }

    public String getSystemDir() {
        return this.systemDir;
    }

    public void setSystemDir(String systemDir) {
        this.systemDir = systemDir;
    }

    public String getExtLibDir() {
        return this.extLibDir;
    }

    public void setExtLibDir(String extLibDir) {
        this.extLibDir = extLibDir;
    }

    public String getUdfDir() {
        return this.udfDir;
    }

    public void setUdfDir(String udfDir) {
        this.udfDir = udfDir;
        this.updateUdfTemporaryLibDir();
    }

    public String getUdfTemporaryLibDir() {
        return this.udfTemporaryLibDir;
    }

    public void updateUdfTemporaryLibDir() {
        this.udfTemporaryLibDir = this.udfDir + File.separator + "tmp";
    }

    public String getTriggerDir() {
        return this.triggerDir;
    }

    public void setTriggerDir(String triggerDir) {
        this.triggerDir = triggerDir;
        this.updateTriggerTemporaryLibDir();
    }

    public String getTriggerTemporaryLibDir() {
        return this.triggerTemporaryLibDir;
    }

    public void updateTriggerTemporaryLibDir() {
        this.triggerTemporaryLibDir = this.triggerDir + File.separator + "tmp";
    }

    public String getPipeDir() {
        return this.pipeDir;
    }

    public void setPipeDir(String pipeDir) {
        this.pipeDir = pipeDir;
        this.updatePipeTemporaryLibDir();
    }

    public String getPipeTemporaryLibDir() {
        return this.pipeTemporaryLibDir;
    }

    public void updatePipeTemporaryLibDir() {
        this.pipeTemporaryLibDir = this.pipeDir + File.separator + "tmp";
    }

    public int getSchemaReplicationFactor() {
        return this.schemaReplicationFactor;
    }

    public void setSchemaReplicationFactor(int schemaReplicationFactor) {
        this.schemaReplicationFactor = schemaReplicationFactor;
    }

    public int getDataReplicationFactor() {
        return this.dataReplicationFactor;
    }

    public void setDataReplicationFactor(int dataReplicationFactor) {
        this.dataReplicationFactor = dataReplicationFactor;
    }

    public int getProcedureCompletedEvictTTL() {
        return this.procedureCompletedEvictTTL;
    }

    public void setProcedureCompletedEvictTTL(int procedureCompletedEvictTTL) {
        this.procedureCompletedEvictTTL = procedureCompletedEvictTTL;
    }

    public int getProcedureCompletedCleanInterval() {
        return this.procedureCompletedCleanInterval;
    }

    public void setProcedureCompletedCleanInterval(int procedureCompletedCleanInterval) {
        this.procedureCompletedCleanInterval = procedureCompletedCleanInterval;
    }

    public int getProcedureCoreWorkerThreadsCount() {
        return this.procedureCoreWorkerThreadsCount;
    }

    public void setProcedureCoreWorkerThreadsCount(int procedureCoreWorkerThreadsCount) {
        this.procedureCoreWorkerThreadsCount = procedureCoreWorkerThreadsCount;
    }

    public long getHeartbeatIntervalInMs() {
        return this.heartbeatIntervalInMs;
    }

    public void setHeartbeatIntervalInMs(long heartbeatIntervalInMs) {
        this.heartbeatIntervalInMs = heartbeatIntervalInMs;
    }

    public long getUnknownDataNodeDetectInterval() {
        return this.unknownDataNodeDetectInterval;
    }

    public void setUnknownDataNodeDetectInterval(long unknownDataNodeDetectInterval) {
        this.unknownDataNodeDetectInterval = unknownDataNodeDetectInterval;
    }

    public String getLeaderDistributionPolicy() {
        return this.leaderDistributionPolicy;
    }

    public void setLeaderDistributionPolicy(String leaderDistributionPolicy) {
        this.leaderDistributionPolicy = leaderDistributionPolicy;
    }

    public boolean isEnableAutoLeaderBalanceForRatisConsensus() {
        return this.enableAutoLeaderBalanceForRatisConsensus;
    }

    public void setEnableAutoLeaderBalanceForRatisConsensus(boolean enableAutoLeaderBalanceForRatisConsensus) {
        this.enableAutoLeaderBalanceForRatisConsensus = enableAutoLeaderBalanceForRatisConsensus;
    }

    public boolean isEnableAutoLeaderBalanceForIoTConsensus() {
        return this.enableAutoLeaderBalanceForIoTConsensus;
    }

    public void setEnableAutoLeaderBalanceForIoTConsensus(boolean enableAutoLeaderBalanceForIoTConsensus) {
        this.enableAutoLeaderBalanceForIoTConsensus = enableAutoLeaderBalanceForIoTConsensus;
    }

    public String getRoutePriorityPolicy() {
        return this.routePriorityPolicy;
    }

    public void setRoutePriorityPolicy(String routePriorityPolicy) {
        this.routePriorityPolicy = routePriorityPolicy;
    }

    public String getReadConsistencyLevel() {
        return this.readConsistencyLevel;
    }

    public void setReadConsistencyLevel(String readConsistencyLevel) {
        this.readConsistencyLevel = readConsistencyLevel;
    }

    public long getDataRegionRatisConsensusLogAppenderBufferSize() {
        return this.dataRegionRatisConsensusLogAppenderBufferSize;
    }

    public void setDataRegionRatisConsensusLogAppenderBufferSize(long dataRegionRatisConsensusLogAppenderBufferSize) {
        this.dataRegionRatisConsensusLogAppenderBufferSize = dataRegionRatisConsensusLogAppenderBufferSize;
    }

    public long getDataRegionRatisSnapshotTriggerThreshold() {
        return this.dataRegionRatisSnapshotTriggerThreshold;
    }

    public void setDataRegionRatisSnapshotTriggerThreshold(long dataRegionRatisSnapshotTriggerThreshold) {
        this.dataRegionRatisSnapshotTriggerThreshold = dataRegionRatisSnapshotTriggerThreshold;
    }

    public boolean isDataRegionRatisLogUnsafeFlushEnable() {
        return this.dataRegionRatisLogUnsafeFlushEnable;
    }

    public void setDataRegionRatisLogUnsafeFlushEnable(boolean dataRegionRatisLogUnsafeFlushEnable) {
        this.dataRegionRatisLogUnsafeFlushEnable = dataRegionRatisLogUnsafeFlushEnable;
    }

    public int getConfigNodeRatisLogForceSyncNum() {
        return this.configNodeRatisLogForceSyncNum;
    }

    public void setConfigNodeRatisLogForceSyncNum(int configNodeRatisLogForceSyncNum) {
        this.configNodeRatisLogForceSyncNum = configNodeRatisLogForceSyncNum;
    }

    public int getSchemaRegionRatisLogForceSyncNum() {
        return this.schemaRegionRatisLogForceSyncNum;
    }

    public void setSchemaRegionRatisLogForceSyncNum(int schemaRegionRatisLogForceSyncNum) {
        this.schemaRegionRatisLogForceSyncNum = schemaRegionRatisLogForceSyncNum;
    }

    public int getDataRegionRatisLogForceSyncNum() {
        return this.dataRegionRatisLogForceSyncNum;
    }

    public void setDataRegionRatisLogForceSyncNum(int dataRegionRatisLogForceSyncNum) {
        this.dataRegionRatisLogForceSyncNum = dataRegionRatisLogForceSyncNum;
    }

    public long getDataRegionRatisLogSegmentSizeMax() {
        return this.dataRegionRatisLogSegmentSizeMax;
    }

    public void setDataRegionRatisLogSegmentSizeMax(long dataRegionRatisLogSegmentSizeMax) {
        this.dataRegionRatisLogSegmentSizeMax = dataRegionRatisLogSegmentSizeMax;
    }

    public long getDataRegionRatisGrpcFlowControlWindow() {
        return this.dataRegionRatisGrpcFlowControlWindow;
    }

    public void setDataRegionRatisGrpcFlowControlWindow(long dataRegionRatisGrpcFlowControlWindow) {
        this.dataRegionRatisGrpcFlowControlWindow = dataRegionRatisGrpcFlowControlWindow;
    }

    public int getConfigNodeRatisGrpcLeaderOutstandingAppendsMax() {
        return this.configNodeRatisGrpcLeaderOutstandingAppendsMax;
    }

    public void setConfigNodeRatisGrpcLeaderOutstandingAppendsMax(int configNodeRatisGrpcLeaderOutstandingAppendsMax) {
        this.configNodeRatisGrpcLeaderOutstandingAppendsMax = configNodeRatisGrpcLeaderOutstandingAppendsMax;
    }

    public int getSchemaRegionRatisGrpcLeaderOutstandingAppendsMax() {
        return this.schemaRegionRatisGrpcLeaderOutstandingAppendsMax;
    }

    public void setSchemaRegionRatisGrpcLeaderOutstandingAppendsMax(int schemaRegionRatisGrpcLeaderOutstandingAppendsMax) {
        this.schemaRegionRatisGrpcLeaderOutstandingAppendsMax = schemaRegionRatisGrpcLeaderOutstandingAppendsMax;
    }

    public int getDataRegionRatisGrpcLeaderOutstandingAppendsMax() {
        return this.dataRegionRatisGrpcLeaderOutstandingAppendsMax;
    }

    public void setDataRegionRatisGrpcLeaderOutstandingAppendsMax(int dataRegionRatisGrpcLeaderOutstandingAppendsMax) {
        this.dataRegionRatisGrpcLeaderOutstandingAppendsMax = dataRegionRatisGrpcLeaderOutstandingAppendsMax;
    }

    public long getDataRegionRatisRpcLeaderElectionTimeoutMinMs() {
        return this.dataRegionRatisRpcLeaderElectionTimeoutMinMs;
    }

    public void setDataRegionRatisRpcLeaderElectionTimeoutMinMs(long dataRegionRatisRpcLeaderElectionTimeoutMinMs) {
        this.dataRegionRatisRpcLeaderElectionTimeoutMinMs = dataRegionRatisRpcLeaderElectionTimeoutMinMs;
    }

    public long getDataRegionRatisRpcLeaderElectionTimeoutMaxMs() {
        return this.dataRegionRatisRpcLeaderElectionTimeoutMaxMs;
    }

    public void setDataRegionRatisRpcLeaderElectionTimeoutMaxMs(long dataRegionRatisRpcLeaderElectionTimeoutMaxMs) {
        this.dataRegionRatisRpcLeaderElectionTimeoutMaxMs = dataRegionRatisRpcLeaderElectionTimeoutMaxMs;
    }

    public long getConfigNodeRatisConsensusLogAppenderBufferSize() {
        return this.configNodeRatisConsensusLogAppenderBufferSize;
    }

    public void setConfigNodeRatisConsensusLogAppenderBufferSize(long configNodeRatisConsensusLogAppenderBufferSize) {
        this.configNodeRatisConsensusLogAppenderBufferSize = configNodeRatisConsensusLogAppenderBufferSize;
    }

    public long getConfigNodeRatisSnapshotTriggerThreshold() {
        return this.configNodeRatisSnapshotTriggerThreshold;
    }

    public void setConfigNodeRatisSnapshotTriggerThreshold(long configNodeRatisSnapshotTriggerThreshold) {
        this.configNodeRatisSnapshotTriggerThreshold = configNodeRatisSnapshotTriggerThreshold;
    }

    public boolean isConfigNodeRatisLogUnsafeFlushEnable() {
        return this.configNodeRatisLogUnsafeFlushEnable;
    }

    public void setConfigNodeRatisLogUnsafeFlushEnable(boolean configNodeRatisLogUnsafeFlushEnable) {
        this.configNodeRatisLogUnsafeFlushEnable = configNodeRatisLogUnsafeFlushEnable;
    }

    public long getConfigNodeRatisLogSegmentSizeMax() {
        return this.configNodeRatisLogSegmentSizeMax;
    }

    public void setConfigNodeRatisLogSegmentSizeMax(long configNodeRatisLogSegmentSizeMax) {
        this.configNodeRatisLogSegmentSizeMax = configNodeRatisLogSegmentSizeMax;
    }

    public long getConfigNodeRatisGrpcFlowControlWindow() {
        return this.configNodeRatisGrpcFlowControlWindow;
    }

    public void setConfigNodeRatisGrpcFlowControlWindow(long configNodeRatisGrpcFlowControlWindow) {
        this.configNodeRatisGrpcFlowControlWindow = configNodeRatisGrpcFlowControlWindow;
    }

    public long getConfigNodeRatisRpcLeaderElectionTimeoutMinMs() {
        return this.configNodeRatisRpcLeaderElectionTimeoutMinMs;
    }

    public void setConfigNodeRatisRpcLeaderElectionTimeoutMinMs(long configNodeRatisRpcLeaderElectionTimeoutMinMs) {
        this.configNodeRatisRpcLeaderElectionTimeoutMinMs = configNodeRatisRpcLeaderElectionTimeoutMinMs;
    }

    public long getConfigNodeRatisRpcLeaderElectionTimeoutMaxMs() {
        return this.configNodeRatisRpcLeaderElectionTimeoutMaxMs;
    }

    public void setConfigNodeRatisRpcLeaderElectionTimeoutMaxMs(long configNodeRatisRpcLeaderElectionTimeoutMaxMs) {
        this.configNodeRatisRpcLeaderElectionTimeoutMaxMs = configNodeRatisRpcLeaderElectionTimeoutMaxMs;
    }

    public long getSchemaRegionRatisConsensusLogAppenderBufferSize() {
        return this.schemaRegionRatisConsensusLogAppenderBufferSize;
    }

    public void setSchemaRegionRatisConsensusLogAppenderBufferSize(long schemaRegionRatisConsensusLogAppenderBufferSize) {
        this.schemaRegionRatisConsensusLogAppenderBufferSize = schemaRegionRatisConsensusLogAppenderBufferSize;
    }

    public long getSchemaRegionRatisSnapshotTriggerThreshold() {
        return this.schemaRegionRatisSnapshotTriggerThreshold;
    }

    public void setSchemaRegionRatisSnapshotTriggerThreshold(long schemaRegionRatisSnapshotTriggerThreshold) {
        this.schemaRegionRatisSnapshotTriggerThreshold = schemaRegionRatisSnapshotTriggerThreshold;
    }

    public boolean isSchemaRegionRatisLogUnsafeFlushEnable() {
        return this.schemaRegionRatisLogUnsafeFlushEnable;
    }

    public void setSchemaRegionRatisLogUnsafeFlushEnable(boolean schemaRegionRatisLogUnsafeFlushEnable) {
        this.schemaRegionRatisLogUnsafeFlushEnable = schemaRegionRatisLogUnsafeFlushEnable;
    }

    public long getSchemaRegionRatisLogSegmentSizeMax() {
        return this.schemaRegionRatisLogSegmentSizeMax;
    }

    public void setSchemaRegionRatisLogSegmentSizeMax(long schemaRegionRatisLogSegmentSizeMax) {
        this.schemaRegionRatisLogSegmentSizeMax = schemaRegionRatisLogSegmentSizeMax;
    }

    public long getConfigNodeSimpleConsensusLogSegmentSizeMax() {
        return this.configNodeSimpleConsensusLogSegmentSizeMax;
    }

    public void setConfigNodeSimpleConsensusLogSegmentSizeMax(long configNodeSimpleConsensusLogSegmentSizeMax) {
        this.configNodeSimpleConsensusLogSegmentSizeMax = configNodeSimpleConsensusLogSegmentSizeMax;
    }

    public long getSchemaRegionRatisGrpcFlowControlWindow() {
        return this.schemaRegionRatisGrpcFlowControlWindow;
    }

    public void setSchemaRegionRatisGrpcFlowControlWindow(long schemaRegionRatisGrpcFlowControlWindow) {
        this.schemaRegionRatisGrpcFlowControlWindow = schemaRegionRatisGrpcFlowControlWindow;
    }

    public long getSchemaRegionRatisRpcLeaderElectionTimeoutMinMs() {
        return this.schemaRegionRatisRpcLeaderElectionTimeoutMinMs;
    }

    public void setSchemaRegionRatisRpcLeaderElectionTimeoutMinMs(long schemaRegionRatisRpcLeaderElectionTimeoutMinMs) {
        this.schemaRegionRatisRpcLeaderElectionTimeoutMinMs = schemaRegionRatisRpcLeaderElectionTimeoutMinMs;
    }

    public long getSchemaRegionRatisRpcLeaderElectionTimeoutMaxMs() {
        return this.schemaRegionRatisRpcLeaderElectionTimeoutMaxMs;
    }

    public void setSchemaRegionRatisRpcLeaderElectionTimeoutMaxMs(long schemaRegionRatisRpcLeaderElectionTimeoutMaxMs) {
        this.schemaRegionRatisRpcLeaderElectionTimeoutMaxMs = schemaRegionRatisRpcLeaderElectionTimeoutMaxMs;
    }

    public int getCqSubmitThread() {
        return this.cqSubmitThread;
    }

    public void setCqSubmitThread(int cqSubmitThread) {
        this.cqSubmitThread = cqSubmitThread;
    }

    public long getCqMinEveryIntervalInMs() {
        return this.cqMinEveryIntervalInMs;
    }

    public void setCqMinEveryIntervalInMs(long cqMinEveryIntervalInMs) {
        this.cqMinEveryIntervalInMs = cqMinEveryIntervalInMs;
    }

    public long getDataRegionRatisRequestTimeoutMs() {
        return this.dataRegionRatisRequestTimeoutMs;
    }

    public void setDataRegionRatisRequestTimeoutMs(long dataRegionRatisRequestTimeoutMs) {
        this.dataRegionRatisRequestTimeoutMs = dataRegionRatisRequestTimeoutMs;
    }

    public long getConfigNodeRatisRequestTimeoutMs() {
        return this.configNodeRatisRequestTimeoutMs;
    }

    public void setConfigNodeRatisRequestTimeoutMs(long configNodeRatisRequestTimeoutMs) {
        this.configNodeRatisRequestTimeoutMs = configNodeRatisRequestTimeoutMs;
    }

    public long getSchemaRegionRatisRequestTimeoutMs() {
        return this.schemaRegionRatisRequestTimeoutMs;
    }

    public void setSchemaRegionRatisRequestTimeoutMs(long schemaRegionRatisRequestTimeoutMs) {
        this.schemaRegionRatisRequestTimeoutMs = schemaRegionRatisRequestTimeoutMs;
    }

    public int getConfigNodeRatisMaxRetryAttempts() {
        return this.configNodeRatisMaxRetryAttempts;
    }

    public void setConfigNodeRatisMaxRetryAttempts(int configNodeRatisMaxRetryAttempts) {
        this.configNodeRatisMaxRetryAttempts = configNodeRatisMaxRetryAttempts;
    }

    public long getConfigNodeRatisInitialSleepTimeMs() {
        return this.configNodeRatisInitialSleepTimeMs;
    }

    public void setConfigNodeRatisInitialSleepTimeMs(long configNodeRatisInitialSleepTimeMs) {
        this.configNodeRatisInitialSleepTimeMs = configNodeRatisInitialSleepTimeMs;
    }

    public long getConfigNodeRatisMaxSleepTimeMs() {
        return this.configNodeRatisMaxSleepTimeMs;
    }

    public void setConfigNodeRatisMaxSleepTimeMs(long configNodeRatisMaxSleepTimeMs) {
        this.configNodeRatisMaxSleepTimeMs = configNodeRatisMaxSleepTimeMs;
    }

    public int getDataRegionRatisMaxRetryAttempts() {
        return this.dataRegionRatisMaxRetryAttempts;
    }

    public void setDataRegionRatisMaxRetryAttempts(int dataRegionRatisMaxRetryAttempts) {
        this.dataRegionRatisMaxRetryAttempts = dataRegionRatisMaxRetryAttempts;
    }

    public long getDataRegionRatisInitialSleepTimeMs() {
        return this.dataRegionRatisInitialSleepTimeMs;
    }

    public void setDataRegionRatisInitialSleepTimeMs(long dataRegionRatisInitialSleepTimeMs) {
        this.dataRegionRatisInitialSleepTimeMs = dataRegionRatisInitialSleepTimeMs;
    }

    public long getDataRegionRatisMaxSleepTimeMs() {
        return this.dataRegionRatisMaxSleepTimeMs;
    }

    public void setDataRegionRatisMaxSleepTimeMs(long dataRegionRatisMaxSleepTimeMs) {
        this.dataRegionRatisMaxSleepTimeMs = dataRegionRatisMaxSleepTimeMs;
    }

    public int getSchemaRegionRatisMaxRetryAttempts() {
        return this.schemaRegionRatisMaxRetryAttempts;
    }

    public void setSchemaRegionRatisMaxRetryAttempts(int schemaRegionRatisMaxRetryAttempts) {
        this.schemaRegionRatisMaxRetryAttempts = schemaRegionRatisMaxRetryAttempts;
    }

    public long getSchemaRegionRatisInitialSleepTimeMs() {
        return this.schemaRegionRatisInitialSleepTimeMs;
    }

    public void setSchemaRegionRatisInitialSleepTimeMs(long schemaRegionRatisInitialSleepTimeMs) {
        this.schemaRegionRatisInitialSleepTimeMs = schemaRegionRatisInitialSleepTimeMs;
    }

    public long getSchemaRegionRatisMaxSleepTimeMs() {
        return this.schemaRegionRatisMaxSleepTimeMs;
    }

    public void setSchemaRegionRatisMaxSleepTimeMs(long schemaRegionRatisMaxSleepTimeMs) {
        this.schemaRegionRatisMaxSleepTimeMs = schemaRegionRatisMaxSleepTimeMs;
    }

    public long getConfigNodeRatisPreserveLogsWhenPurge() {
        return this.configNodeRatisPreserveLogsWhenPurge;
    }

    public void setConfigNodeRatisPreserveLogsWhenPurge(long configNodeRatisPreserveLogsWhenPurge) {
        this.configNodeRatisPreserveLogsWhenPurge = configNodeRatisPreserveLogsWhenPurge;
    }

    public long getSchemaRegionRatisPreserveLogsWhenPurge() {
        return this.schemaRegionRatisPreserveLogsWhenPurge;
    }

    public void setSchemaRegionRatisPreserveLogsWhenPurge(long schemaRegionRatisPreserveLogsWhenPurge) {
        this.schemaRegionRatisPreserveLogsWhenPurge = schemaRegionRatisPreserveLogsWhenPurge;
    }

    public long getDataRegionRatisPreserveLogsWhenPurge() {
        return this.dataRegionRatisPreserveLogsWhenPurge;
    }

    public void setDataRegionRatisPreserveLogsWhenPurge(long dataRegionRatisPreserveLogsWhenPurge) {
        this.dataRegionRatisPreserveLogsWhenPurge = dataRegionRatisPreserveLogsWhenPurge;
    }

    public long getRatisFirstElectionTimeoutMinMs() {
        return this.ratisFirstElectionTimeoutMinMs;
    }

    public void setRatisFirstElectionTimeoutMinMs(long ratisFirstElectionTimeoutMinMs) {
        this.ratisFirstElectionTimeoutMinMs = ratisFirstElectionTimeoutMinMs;
    }

    public long getRatisFirstElectionTimeoutMaxMs() {
        return this.ratisFirstElectionTimeoutMaxMs;
    }

    public void setRatisFirstElectionTimeoutMaxMs(long ratisFirstElectionTimeoutMaxMs) {
        this.ratisFirstElectionTimeoutMaxMs = ratisFirstElectionTimeoutMaxMs;
    }

    public long getConfigNodeRatisLogMax() {
        return this.configNodeRatisLogMax;
    }

    public void setConfigNodeRatisLogMax(long configNodeRatisLogMax) {
        this.configNodeRatisLogMax = configNodeRatisLogMax;
    }

    public long getSchemaRegionRatisLogMax() {
        return this.schemaRegionRatisLogMax;
    }

    public void setSchemaRegionRatisLogMax(long schemaRegionRatisLogMax) {
        this.schemaRegionRatisLogMax = schemaRegionRatisLogMax;
    }

    public long getDataRegionRatisLogMax() {
        return this.dataRegionRatisLogMax;
    }

    public void setDataRegionRatisLogMax(long dataRegionRatisLogMax) {
        this.dataRegionRatisLogMax = dataRegionRatisLogMax;
    }

    public boolean isEnablePrintingNewlyCreatedPartition() {
        return this.isEnablePrintingNewlyCreatedPartition;
    }

    public void setEnablePrintingNewlyCreatedPartition(boolean enablePrintingNewlyCreatedPartition) {
        this.isEnablePrintingNewlyCreatedPartition = enablePrintingNewlyCreatedPartition;
    }

    public long getForceWalPeriodForConfigNodeSimpleInMs() {
        return this.forceWalPeriodForConfigNodeSimpleInMs;
    }

    public void setForceWalPeriodForConfigNodeSimpleInMs(long forceWalPeriodForConfigNodeSimpleInMs) {
        this.forceWalPeriodForConfigNodeSimpleInMs = forceWalPeriodForConfigNodeSimpleInMs;
    }

    public String getConfigMessage() {
        StringBuilder configMessage = new StringBuilder();
        for (Field configField : ConfigNodeConfig.class.getDeclaredFields()) {
            try {
                String configContent;
                String configType = configField.getGenericType().getTypeName();
                if (configType.contains("java.lang.String[]")) {
                    String[] configList = (String[])configField.get(this);
                    configContent = Arrays.asList(configList).toString();
                } else {
                    configContent = configField.get(this).toString();
                }
                configMessage.append("\n\t").append(configField.getName()).append("=").append(configContent).append(";");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return configMessage.toString();
    }

    public long getConfigNodeRatisPeriodicSnapshotInterval() {
        return this.configNodeRatisPeriodicSnapshotInterval;
    }

    public void setConfigNodeRatisPeriodicSnapshotInterval(long configNodeRatisPeriodicSnapshotInterval) {
        this.configNodeRatisPeriodicSnapshotInterval = configNodeRatisPeriodicSnapshotInterval;
    }

    public long getSchemaRegionRatisPeriodicSnapshotInterval() {
        return this.schemaRegionRatisPeriodicSnapshotInterval;
    }

    public void setSchemaRegionRatisPeriodicSnapshotInterval(long schemaRegionRatisPeriodicSnapshotInterval) {
        this.schemaRegionRatisPeriodicSnapshotInterval = schemaRegionRatisPeriodicSnapshotInterval;
    }

    public long getDataRegionRatisPeriodicSnapshotInterval() {
        return this.dataRegionRatisPeriodicSnapshotInterval;
    }

    public void setDataRegionRatisPeriodicSnapshotInterval(long dataRegionRatisPeriodicSnapshotInterval) {
        this.dataRegionRatisPeriodicSnapshotInterval = dataRegionRatisPeriodicSnapshotInterval;
    }
}

