/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.load.balancer.region;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TDataNodeConfiguration;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.confignode.manager.load.balancer.region.IRegionGroupAllocator;
import org.apache.iotdb.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GreedyRegionGroupAllocator
implements IRegionGroupAllocator {
    private static final Logger LOGGER = LoggerFactory.getLogger(GreedyRegionGroupAllocator.class);

    @Override
    public TRegionReplicaSet generateOptimalRegionReplicasDistribution(Map<Integer, TDataNodeConfiguration> availableDataNodeMap, Map<Integer, Double> freeDiskSpaceMap, List<TRegionReplicaSet> allocatedRegionGroups, int replicationFactor, TConsensusGroupId consensusGroupId) {
        List<TDataNodeLocation> weightList = this.buildWeightList(availableDataNodeMap, freeDiskSpaceMap, allocatedRegionGroups);
        return new TRegionReplicaSet(consensusGroupId, weightList.stream().limit(replicationFactor).collect(Collectors.toList()));
    }

    private List<TDataNodeLocation> buildWeightList(Map<Integer, TDataNodeConfiguration> availableDataNodeMap, Map<Integer, Double> freeDiskSpaceMap, List<TRegionReplicaSet> allocatedRegionGroups) {
        HashMap regionCounter = new HashMap(availableDataNodeMap.size());
        allocatedRegionGroups.forEach(regionReplicaSet -> regionReplicaSet.getDataNodeLocations().forEach(dataNodeLocation -> regionCounter.merge(dataNodeLocation.getDataNodeId(), 1, Integer::sum)));
        HashMap priorityMap = new HashMap(availableDataNodeMap.size());
        availableDataNodeMap.forEach((datanodeId, dataNodeConfiguration) -> priorityMap.put(dataNodeConfiguration.getLocation(), new Pair((Object)regionCounter.getOrDefault(datanodeId, 0), (Object)freeDiskSpaceMap.getOrDefault(datanodeId, 0.0))));
        List<TDataNodeLocation> result = priorityMap.entrySet().stream().sorted(Map.Entry.comparingByValue((o1, o2) -> !Objects.equals(o1.getLeft(), o2.getLeft()) ? (Integer)o1.getLeft() - (Integer)o2.getLeft() : (int)((Double)o2.getRight() - (Double)o1.getRight()))).map(entry -> ((TDataNodeLocation)entry.getKey()).deepCopy()).collect(Collectors.toList());
        for (TDataNodeLocation dataNodeLocation : result) {
            LOGGER.info("[RegionGroupWeightList] DataNodeId: {}, RegionCount: {}, FreeDiskSpace: {}", new Object[]{dataNodeLocation.getDataNodeId(), ((Pair)priorityMap.get(dataNodeLocation)).getLeft(), ((Pair)priorityMap.get(dataNodeLocation)).getRight()});
        }
        return result;
    }
}

