/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.load.cache.node;

import org.apache.iotdb.commons.cluster.NodeStatus;
import org.apache.iotdb.confignode.rpc.thrift.TConfigNodeHeartbeatResp;
import org.apache.iotdb.mpp.rpc.thrift.TDataNodeHeartbeatResp;
import org.apache.iotdb.mpp.rpc.thrift.TLoadSample;

public class NodeHeartbeatSample {
    private final long sendTimestamp;
    private final long receiveTimestamp;
    private final NodeStatus status;
    private final String statusReason;
    private TLoadSample loadSample = null;

    public NodeHeartbeatSample(long sendTimestamp, long receiveTimestamp) {
        this.sendTimestamp = sendTimestamp;
        this.receiveTimestamp = receiveTimestamp;
        this.status = NodeStatus.Running;
        this.statusReason = null;
    }

    public NodeHeartbeatSample(TDataNodeHeartbeatResp heartbeatResp, long receiveTimestamp) {
        this.sendTimestamp = heartbeatResp.getHeartbeatTimestamp();
        this.receiveTimestamp = receiveTimestamp;
        this.status = NodeStatus.parse((String)heartbeatResp.getStatus());
        String string = this.statusReason = heartbeatResp.isSetStatusReason() ? heartbeatResp.getStatusReason() : null;
        if (heartbeatResp.isSetLoadSample()) {
            this.loadSample = heartbeatResp.getLoadSample();
        }
    }

    public NodeHeartbeatSample(TConfigNodeHeartbeatResp heartbeatResp, long receiveTimestamp) {
        this.sendTimestamp = heartbeatResp.getTimestamp();
        this.receiveTimestamp = receiveTimestamp;
        this.status = NodeStatus.Running;
        this.statusReason = null;
    }

    public long getSendTimestamp() {
        return this.sendTimestamp;
    }

    public long getReceiveTimestamp() {
        return this.receiveTimestamp;
    }

    public NodeStatus getStatus() {
        return this.status;
    }

    public String getStatusReason() {
        return this.statusReason;
    }

    public boolean isSetLoadSample() {
        return this.loadSample != null;
    }

    public TLoadSample getLoadSample() {
        return this.loadSample;
    }

    public static NodeHeartbeatSample generateDefaultSample(NodeStatus status) {
        long currentTime = System.nanoTime();
        return new NodeHeartbeatSample(new TDataNodeHeartbeatResp(currentTime, status.getStatus()).setStatusReason(null), currentTime);
    }
}

