/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.pipe.task;

import java.util.HashMap;
import java.util.Map;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.commons.pipe.task.PipeTask;
import org.apache.iotdb.commons.pipe.task.meta.PipeMeta;
import org.apache.iotdb.commons.pipe.task.meta.PipeRuntimeMeta;
import org.apache.iotdb.commons.pipe.task.meta.PipeStaticMeta;
import org.apache.iotdb.commons.pipe.task.meta.PipeTaskMeta;
import org.apache.iotdb.confignode.conf.ConfigNodeDescriptor;
import org.apache.iotdb.confignode.manager.pipe.task.PipeConfigNodeTask;
import org.apache.iotdb.confignode.manager.pipe.task.PipeConfigNodeTaskStage;

public class PipeConfigNodeTaskBuilder {
    private final PipeMeta pipeMeta;

    public PipeConfigNodeTaskBuilder(PipeMeta pipeMeta) {
        this.pipeMeta = pipeMeta;
    }

    public Map<TConsensusGroupId, PipeTask> build() {
        PipeStaticMeta pipeStaticMeta = this.pipeMeta.getStaticMeta();
        PipeRuntimeMeta pipeRuntimeMeta = this.pipeMeta.getRuntimeMeta();
        HashMap<TConsensusGroupId, PipeTask> consensusGroupIdToPipeTaskMap = new HashMap<TConsensusGroupId, PipeTask>();
        for (Map.Entry consensusGroupIdToPipeTaskMeta : pipeRuntimeMeta.getConsensusGroupId2TaskMetaMap().entrySet()) {
            TConsensusGroupId consensusGroupId = (TConsensusGroupId)consensusGroupIdToPipeTaskMeta.getKey();
            switch (consensusGroupId.getType()) {
                case ConfigRegion: {
                    if (((PipeTaskMeta)consensusGroupIdToPipeTaskMeta.getValue()).getLeaderDataNodeId() != ConfigNodeDescriptor.getInstance().getConf().getConfigNodeId()) break;
                    consensusGroupIdToPipeTaskMap.put(consensusGroupId, new PipeConfigNodeTask(new PipeConfigNodeTaskStage(pipeStaticMeta.getPipeName(), pipeStaticMeta.getCreationTime(), pipeStaticMeta.getExtractorParameters().getAttribute(), pipeStaticMeta.getProcessorParameters().getAttribute(), pipeStaticMeta.getConnectorParameters().getAttribute())));
                    break;
                }
            }
        }
        return consensusGroupIdToPipeTaskMap;
    }
}

