/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.persistence;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.auth.AuthException;
import org.apache.iotdb.commons.auth.authorizer.BasicAuthorizer;
import org.apache.iotdb.commons.auth.authorizer.IAuthorizer;
import org.apache.iotdb.commons.auth.authorizer.OpenIdAuthorizer;
import org.apache.iotdb.commons.auth.entity.PathPrivilege;
import org.apache.iotdb.commons.auth.entity.PriPrivilegeType;
import org.apache.iotdb.commons.auth.entity.PrivilegeType;
import org.apache.iotdb.commons.auth.entity.Role;
import org.apache.iotdb.commons.auth.entity.User;
import org.apache.iotdb.commons.conf.CommonConfig;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.commons.snapshot.SnapshotProcessor;
import org.apache.iotdb.commons.utils.AuthUtils;
import org.apache.iotdb.commons.utils.FileUtils;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanType;
import org.apache.iotdb.confignode.consensus.request.auth.AuthorPlan;
import org.apache.iotdb.confignode.consensus.response.auth.PermissionInfoResp;
import org.apache.iotdb.confignode.rpc.thrift.TAuthizedPatternTreeResp;
import org.apache.iotdb.confignode.rpc.thrift.TPathPrivilege;
import org.apache.iotdb.confignode.rpc.thrift.TPermissionInfoResp;
import org.apache.iotdb.confignode.rpc.thrift.TRoleResp;
import org.apache.iotdb.confignode.rpc.thrift.TUserResp;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthorInfo
implements SnapshotProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthorInfo.class);
    private static final CommonConfig COMMON_CONFIG = CommonDescriptor.getInstance().getConfig();
    private static final String NO_USER_MSG = "No such user : ";
    private IAuthorizer authorizer;
    private boolean hasPrePriv = true;

    public AuthorInfo() {
        try {
            this.authorizer = BasicAuthorizer.getInstance();
        }
        catch (AuthException e) {
            LOGGER.error("get user or role permissionInfo failed because ", (Throwable)e);
        }
    }

    public TPermissionInfoResp login(String username, String password) {
        boolean status;
        String loginMessage = null;
        TSStatus tsStatus = new TSStatus();
        TPermissionInfoResp result = new TPermissionInfoResp();
        try {
            status = this.authorizer.login(username, password);
            if (status) {
                if (this.authorizer instanceof OpenIdAuthorizer) {
                    username = ((OpenIdAuthorizer)this.authorizer).getIoTDBUserName(username);
                    result = this.getUserPermissionInfo(username);
                    result.getUserInfo().setIsOpenIdUser(true);
                } else {
                    result = this.getUserPermissionInfo(username);
                }
                result.setStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS, (String)"Login successfully"));
            } else {
                result = AuthUtils.generateEmptyPermissionInfoResp();
            }
        }
        catch (AuthException e) {
            LOGGER.error("meet error while logging in.", (Throwable)e);
            status = false;
            loginMessage = e.getMessage();
        }
        if (!status) {
            tsStatus.setMessage(loginMessage != null ? loginMessage : "Authentication failed.");
            tsStatus.setCode(TSStatusCode.WRONG_LOGIN_PASSWORD.getStatusCode());
            result.setStatus(tsStatus);
        }
        return result;
    }

    public TPermissionInfoResp checkUserPrivileges(String username, List<PartialPath> paths, int permission) {
        boolean status = true;
        TPermissionInfoResp result = new TPermissionInfoResp();
        ArrayList<Integer> failedList = new ArrayList<Integer>();
        try {
            if (paths.isEmpty()) {
                status = this.authorizer.checkUserPrivileges(username, null, permission);
            } else {
                int pos = 0;
                for (PartialPath path : paths) {
                    if (!this.checkOnePath(username, path, permission)) {
                        failedList.add(pos);
                    }
                    ++pos;
                }
                if (failedList.size() == paths.size()) {
                    status = false;
                }
            }
        }
        catch (AuthException e) {
            status = false;
        }
        if (status) {
            try {
                result = this.getUserPermissionInfo(username);
                result.setFailPos(failedList);
                result.setStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS));
            }
            catch (AuthException e) {
                result.setStatus(RpcUtils.getStatus((TSStatusCode)e.getCode(), (String)e.getMessage()));
            }
        } else {
            result = AuthUtils.generateEmptyPermissionInfoResp();
            result.setFailPos(failedList);
            result.setStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.NO_PERMISSION));
        }
        return result;
    }

    private boolean checkOnePath(String username, PartialPath path, int permission) throws AuthException {
        try {
            if (this.authorizer.checkUserPrivileges(username, path, permission)) {
                return true;
            }
        }
        catch (AuthException e) {
            LOGGER.error("Error occurs when checking the seriesPath {} for user {}", new Object[]{path, username, e});
            throw new AuthException(e.getCode(), (Throwable)e);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TSStatus authorNonQuery(AuthorPlan authorPlan) {
        ConfigPhysicalPlanType authorType = authorPlan.getAuthorType();
        String userName = authorPlan.getUserName();
        String roleName = authorPlan.getRoleName();
        String password = authorPlan.getPassword();
        String newPassword = authorPlan.getNewPassword();
        Set<Integer> permissions = authorPlan.getPermissions();
        boolean grantOpt = authorPlan.getGrantOpt();
        List<PartialPath> nodeNameList = authorPlan.getNodeNameList();
        if (authorType.ordinal() >= ConfigPhysicalPlanType.CreateUserDep.ordinal() && authorType.ordinal() <= ConfigPhysicalPlanType.UpdateUserDep.ordinal()) {
            this.authorizer.setUserForPreVersion(true);
            this.authorizer.setRoleForPreVersion(true);
        } else if (this.hasPrePriv) {
            this.authorizer.checkUserPathPrivilege();
            this.hasPrePriv = false;
        }
        try {
            switch (authorType) {
                case UpdateUserDep: 
                case UpdateUser: {
                    this.authorizer.updateUserPassword(userName, newPassword);
                    return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
                }
                case CreateUserDep: {
                    AuthUtils.validatePasswordPre((String)password);
                    AuthUtils.validateUsernamePre((String)userName);
                    this.authorizer.createUserWithoutCheck(userName, password);
                    return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
                }
                case CreateUser: {
                    this.authorizer.createUser(userName, password);
                    return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
                }
                case CreateRoleDep: {
                    AuthUtils.validateRolenamePre((String)roleName);
                    this.authorizer.createRole(roleName);
                    return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
                }
                case CreateRole: {
                    AuthUtils.validateRolename((String)roleName);
                    this.authorizer.createRole(roleName);
                    return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
                }
                case DropUserDep: 
                case DropUser: {
                    this.authorizer.deleteUser(userName);
                    return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
                }
                case DropRoleDep: 
                case DropRole: {
                    this.authorizer.deleteRole(roleName);
                    return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
                }
                case GrantRoleDep: {
                    this.grantPrivilegeForPreVersion(false, roleName, permissions, nodeNameList);
                    return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
                }
                case GrantRole: {
                    for (int permission : permissions) {
                        if (!PrivilegeType.isPathRelevant((int)permission)) {
                            this.authorizer.grantPrivilegeToRole(roleName, null, permission, grantOpt);
                            continue;
                        }
                        for (PartialPath path : nodeNameList) {
                            this.authorizer.grantPrivilegeToRole(roleName, path, permission, grantOpt);
                        }
                    }
                    return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
                }
                case GrantUserDep: {
                    this.grantPrivilegeForPreVersion(true, userName, permissions, nodeNameList);
                    return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
                }
                case GrantUser: {
                    for (int permission : permissions) {
                        if (!PrivilegeType.isPathRelevant((int)permission)) {
                            this.authorizer.grantPrivilegeToUser(userName, null, permission, grantOpt);
                            continue;
                        }
                        for (PartialPath path : nodeNameList) {
                            this.authorizer.grantPrivilegeToUser(userName, path, permission, grantOpt);
                        }
                    }
                    return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
                }
                case GrantRoleToUserDep: 
                case GrantRoleToUser: {
                    this.authorizer.grantRoleToUser(roleName, userName);
                    return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
                }
                case RevokeUserDep: {
                    this.revokePrivilegeForPreVersion(true, userName, permissions, nodeNameList);
                    return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
                }
                case RevokeUser: {
                    for (int permission : permissions) {
                        if (!PrivilegeType.isPathRelevant((int)permission)) {
                            this.authorizer.revokePrivilegeFromUser(userName, null, permission);
                            continue;
                        }
                        for (PartialPath path : nodeNameList) {
                            this.authorizer.revokePrivilegeFromUser(userName, path, permission);
                        }
                    }
                    return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
                }
                case RevokeRoleDep: {
                    this.revokePrivilegeForPreVersion(false, roleName, permissions, nodeNameList);
                    return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
                }
                case RevokeRole: {
                    for (int permission : permissions) {
                        if (!PrivilegeType.isPathRelevant((int)permission)) {
                            this.authorizer.revokePrivilegeFromRole(roleName, null, permission);
                            continue;
                        }
                        for (PartialPath path : nodeNameList) {
                            this.authorizer.revokePrivilegeFromRole(roleName, path, permission);
                        }
                    }
                    return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
                }
                case RevokeRoleFromUserDep: 
                case RevokeRoleFromUser: {
                    this.authorizer.revokeRoleFromUser(roleName, userName);
                    return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
                }
                default: {
                    throw new AuthException(TSStatusCode.UNSUPPORTED_AUTH_OPERATION, "unknown type: " + (Object)((Object)authorPlan.getAuthorType()));
                }
            }
        }
        catch (AuthException e) {
            TSStatus tSStatus = RpcUtils.getStatus((TSStatusCode)e.getCode(), (String)e.getMessage());
            return tSStatus;
        }
        finally {
            this.authorizer.setUserForPreVersion(false);
            this.authorizer.setRoleForPreVersion(false);
        }
    }

    public PermissionInfoResp executeListUsers(AuthorPlan plan) throws AuthException {
        PermissionInfoResp result = new PermissionInfoResp();
        List userList = this.authorizer.listAllUsers();
        if (!plan.getRoleName().isEmpty()) {
            Role role = this.authorizer.getRole(plan.getRoleName());
            if (role == null) {
                result.setStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.ROLE_NOT_EXIST, (String)("No such role : " + plan.getRoleName())));
                return result;
            }
            Iterator itr = userList.iterator();
            while (itr.hasNext()) {
                User userObj = this.authorizer.getUser((String)itr.next());
                if (userObj != null && userObj.hasRole(plan.getRoleName())) continue;
                itr.remove();
            }
        }
        result.setTag("user");
        result.setMemberInfo(userList);
        result.setStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS));
        return result;
    }

    public PermissionInfoResp executeListRoles(AuthorPlan plan) throws AuthException {
        PermissionInfoResp result = new PermissionInfoResp();
        ArrayList<String> permissionInfo = new ArrayList<String>();
        ArrayList<String> roleList = new ArrayList<String>();
        if (plan.getUserName().isEmpty()) {
            roleList.addAll(this.authorizer.listAllRoles());
        } else {
            User user = this.authorizer.getUser(plan.getUserName());
            if (user == null) {
                result.setStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.USER_NOT_EXIST, (String)(NO_USER_MSG + plan.getUserName())));
                result.setMemberInfo(permissionInfo);
                return result;
            }
            roleList.addAll(user.getRoleList());
        }
        result.setTag("role");
        result.setMemberInfo(roleList);
        result.setStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS));
        return result;
    }

    public PermissionInfoResp executeListRolePrivileges(AuthorPlan plan) throws AuthException {
        PermissionInfoResp result = new PermissionInfoResp();
        ArrayList<String> permissionInfo = new ArrayList<String>();
        Role role = this.authorizer.getRole(plan.getRoleName());
        if (role == null) {
            result.setStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.ROLE_NOT_EXIST, (String)("No such role : " + plan.getRoleName())));
            result.setMemberInfo(permissionInfo);
            return result;
        }
        TPermissionInfoResp resp = new TPermissionInfoResp();
        TRoleResp roleResp = new TRoleResp();
        roleResp.setRoleName(role.getName());
        ArrayList<TPathPrivilege> pathList = new ArrayList<TPathPrivilege>();
        for (PathPrivilege path : role.getPathPrivilegeList()) {
            TPathPrivilege pathPri = new TPathPrivilege();
            pathPri.setPriGrantOpt(path.getGrantOpt());
            pathPri.setPriSet(path.getPrivileges());
            pathPri.setPath(path.getPath().toString());
            pathList.add(pathPri);
        }
        roleResp.setPrivilegeList(pathList);
        roleResp.setSysPriSet(role.getSysPrivilege());
        roleResp.setSysPriSetGrantOpt(role.getSysPriGrantOpt());
        HashMap<String, TRoleResp> roleInfo = new HashMap<String, TRoleResp>();
        roleInfo.put(role.getName(), roleResp);
        resp.setRoleInfo(roleInfo);
        resp.setStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS));
        result.setTag("privilege");
        result.setPermissionInfoResp(resp);
        result.setStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS));
        result.setMemberInfo(permissionInfo);
        return result;
    }

    public PermissionInfoResp executeListUserPrivileges(AuthorPlan plan) throws AuthException {
        PermissionInfoResp result = new PermissionInfoResp();
        User user = this.authorizer.getUser(plan.getUserName());
        if (user == null) {
            result.setStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.USER_NOT_EXIST, (String)(NO_USER_MSG + plan.getUserName())));
            return result;
        }
        TPermissionInfoResp resp = this.getUserPermissionInfo(plan.getUserName());
        resp.setStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS));
        result.setTag("privilege");
        result.setPermissionInfoResp(resp);
        result.setStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS));
        return result;
    }

    public TAuthizedPatternTreeResp generateAuthizedPTree(String username, int permission) throws AuthException {
        TAuthizedPatternTreeResp resp = new TAuthizedPatternTreeResp();
        User user = this.authorizer.getUser(username);
        PathPatternTree pPtree = new PathPatternTree();
        if (user == null) {
            resp.setStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.USER_NOT_EXIST, (String)(NO_USER_MSG + username)));
            resp.setUsername(username);
            resp.setPrivilegeId(permission);
            return resp;
        }
        for (PathPrivilege path : user.getPathPrivilegeList()) {
            if (!path.checkPrivilege(permission)) continue;
            pPtree.appendPathPattern(path.getPath());
        }
        for (String rolename : user.getRoleList()) {
            Role role = this.authorizer.getRole(rolename);
            if (role == null) continue;
            for (PathPrivilege path : role.getPathPrivilegeList()) {
                if (!path.checkPrivilege(permission)) continue;
                pPtree.appendPathPattern(path.getPath());
            }
        }
        pPtree.constructTree();
        resp.setUsername(username);
        resp.setPrivilegeId(permission);
        resp.setStatus(new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode()));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            pPtree.serialize(dataOutputStream);
        }
        catch (IOException e) {
            resp.setStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR, (String)"Get error when serialize pattern tree."));
            return resp;
        }
        resp.setPathPatternTree(ByteBuffer.wrap(byteArrayOutputStream.toByteArray()));
        resp.setPermissionInfo(this.getUserPermissionInfo(username));
        return resp;
    }

    public TPermissionInfoResp checkUserPrivilegeGrantOpt(String username, List<PartialPath> paths, int permission) throws AuthException {
        boolean status;
        TPermissionInfoResp resp;
        block14: {
            User user = this.authorizer.getUser(username);
            resp = new TPermissionInfoResp();
            status = false;
            if (user == null) {
                resp.setStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.USER_NOT_EXIST, (String)(NO_USER_MSG + username)));
                return resp;
            }
            try {
                if (PrivilegeType.isPathRelevant((int)permission)) {
                    for (PartialPath path : paths) {
                        if (user.checkPathPrivilegeGrantOpt(path, permission)) {
                            status = true;
                            continue;
                        }
                        if (!status) {
                            for (String roleName : user.getRoleList()) {
                                Role role = this.authorizer.getRole(roleName);
                                if (!role.checkPathPrivilegeGrantOpt(path, permission)) continue;
                                status = true;
                                break;
                            }
                        }
                        if (status) continue;
                        break block14;
                    }
                    break block14;
                }
                if (user.checkSysPriGrantOpt(permission)) {
                    status = true;
                }
                if (status) break block14;
                for (String roleName : user.getRoleList()) {
                    Role role = this.authorizer.getRole(roleName);
                    if (!role.checkSysPriGrantOpt(permission)) continue;
                    status = true;
                    break;
                }
            }
            catch (AuthException e) {
                status = false;
            }
        }
        if (status) {
            try {
                resp = this.getUserPermissionInfo(username);
                resp.setStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS));
            }
            catch (AuthException e) {
                resp.setStatus(RpcUtils.getStatus((TSStatusCode)e.getCode(), (String)e.getMessage()));
            }
        } else {
            resp = AuthUtils.generateEmptyPermissionInfoResp();
            resp.setStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.NO_PERMISSION));
        }
        return resp;
    }

    public TPermissionInfoResp checkRoleOfUser(String username, String rolename) throws AuthException {
        User user = this.authorizer.getUser(username);
        if (user == null) {
            throw new AuthException(TSStatusCode.USER_NOT_EXIST, String.format("No such user : %s", username));
        }
        TPermissionInfoResp result = this.getUserPermissionInfo(username);
        if (user.getRoleList().contains(rolename)) {
            result.setStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS));
        } else {
            result.setStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.USER_NOT_HAS_ROLE));
        }
        return result;
    }

    public boolean processTakeSnapshot(File snapshotDir) throws TException, IOException {
        return this.authorizer.processTakeSnapshot(snapshotDir);
    }

    public void processLoadSnapshot(File snapshotDir) throws TException, IOException {
        this.authorizer.processLoadSnapshot(snapshotDir);
    }

    public void clear() throws AuthException {
        File roleFolder;
        File userFolder = new File(COMMON_CONFIG.getUserFolder());
        if (userFolder.exists()) {
            FileUtils.deleteDirectory((File)userFolder);
        }
        if ((roleFolder = new File(COMMON_CONFIG.getRoleFolder())).exists()) {
            FileUtils.deleteDirectory((File)roleFolder);
        }
        this.authorizer.reset();
    }

    public TPermissionInfoResp getUserPermissionInfo(String username) throws AuthException {
        TPermissionInfoResp result = new TPermissionInfoResp();
        TUserResp tUserResp = new TUserResp();
        HashMap<String, TRoleResp> tRoleRespMap = new HashMap<String, TRoleResp>();
        ArrayList<TPathPrivilege> userPrivilegeList = new ArrayList<TPathPrivilege>();
        User user = this.authorizer.getUser(username);
        if (user.getPathPrivilegeList() != null) {
            for (PathPrivilege pathPrivilege : user.getPathPrivilegeList()) {
                TPathPrivilege path = new TPathPrivilege();
                path.setPath(pathPrivilege.getPath().getFullPath());
                path.setPriSet(pathPrivilege.getPrivileges());
                path.setPriGrantOpt(pathPrivilege.getGrantOpt());
                userPrivilegeList.add(path);
            }
        }
        tUserResp.setUsername(user.getName());
        tUserResp.setPassword(user.getPassword());
        tUserResp.setPrivilegeList(userPrivilegeList);
        tUserResp.setRoleList(user.getRoleList());
        tUserResp.setSysPriSet(user.getSysPrivilege());
        tUserResp.setSysPriSetGrantOpt(user.getSysPriGrantOpt());
        if (user.getRoleList() != null) {
            for (String roleName : user.getRoleList()) {
                Role role = this.authorizer.getRole(roleName);
                ArrayList<TPathPrivilege> rolePrivilegeList = new ArrayList<TPathPrivilege>();
                for (PathPrivilege pathPrivilege : role.getPathPrivilegeList()) {
                    TPathPrivilege path = new TPathPrivilege();
                    path.setPath(pathPrivilege.getPath().getFullPath());
                    path.setPriSet(pathPrivilege.getPrivileges());
                    path.setPriGrantOpt(pathPrivilege.getGrantOpt());
                    rolePrivilegeList.add(path);
                }
                tRoleRespMap.put(roleName, new TRoleResp(roleName, rolePrivilegeList, role.getSysPrivilege(), role.getSysPriGrantOpt()));
            }
        }
        result.setUserInfo(tUserResp);
        result.setRoleInfo(tRoleRespMap);
        result.setStatus(new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode()));
        return result;
    }

    public void checkUserPathPrivilege() {
        this.authorizer.checkUserPathPrivilege();
    }

    private void grantPrivilegeForPreVersion(boolean isUser, String name, Set<Integer> permissions, List<PartialPath> nodeNameList) throws AuthException {
        for (int permission : permissions) {
            PriPrivilegeType type = PriPrivilegeType.values()[permission];
            if (!type.isAccept()) continue;
            if (isUser) {
                for (PartialPath path : nodeNameList) {
                    this.authorizer.grantPrivilegeToUser(name, path, permission, false);
                }
                continue;
            }
            for (PartialPath path : nodeNameList) {
                this.authorizer.grantPrivilegeToRole(name, path, permission, false);
            }
        }
    }

    private void revokePrivilegeForPreVersion(boolean isUser, String name, Set<Integer> permissions, List<PartialPath> nodeNameList) throws AuthException {
        for (int permission : permissions) {
            PriPrivilegeType type = PriPrivilegeType.values()[permission];
            if (!type.isAccept() || type.isAccept()) continue;
            if (isUser) {
                for (PartialPath path : nodeNameList) {
                    this.authorizer.revokePrivilegeFromUser(name, path, permission);
                }
                continue;
            }
            for (PartialPath path : nodeNameList) {
                this.authorizer.revokePrivilegeFromRole(name, path, permission);
            }
        }
    }
}

