/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.impl.pipe.task;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.consensus.index.ProgressIndex;
import org.apache.iotdb.commons.consensus.index.impl.MinimumProgressIndex;
import org.apache.iotdb.commons.pipe.task.meta.PipeRuntimeMeta;
import org.apache.iotdb.commons.pipe.task.meta.PipeStaticMeta;
import org.apache.iotdb.commons.pipe.task.meta.PipeStatus;
import org.apache.iotdb.commons.pipe.task.meta.PipeTaskMeta;
import org.apache.iotdb.confignode.consensus.request.write.pipe.task.CreatePipePlanV2;
import org.apache.iotdb.confignode.consensus.request.write.pipe.task.DropPipePlanV2;
import org.apache.iotdb.confignode.manager.pipe.coordinator.PipeManager;
import org.apache.iotdb.confignode.persistence.pipe.PipeTaskInfo;
import org.apache.iotdb.confignode.procedure.env.ConfigNodeProcedureEnv;
import org.apache.iotdb.confignode.procedure.impl.pipe.AbstractOperatePipeProcedureV2;
import org.apache.iotdb.confignode.procedure.impl.pipe.PipeTaskOperation;
import org.apache.iotdb.confignode.procedure.store.ProcedureType;
import org.apache.iotdb.confignode.rpc.thrift.TCreatePipeReq;
import org.apache.iotdb.consensus.exception.ConsensusException;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreatePipeProcedureV2
extends AbstractOperatePipeProcedureV2 {
    private static final Logger LOGGER = LoggerFactory.getLogger(CreatePipeProcedureV2.class);
    private TCreatePipeReq createPipeRequest;
    private PipeStaticMeta pipeStaticMeta;
    private PipeRuntimeMeta pipeRuntimeMeta;

    public CreatePipeProcedureV2() {
    }

    public CreatePipeProcedureV2(TCreatePipeReq createPipeRequest) throws PipeException {
        this.createPipeRequest = createPipeRequest;
    }

    @Override
    protected PipeTaskOperation getOperation() {
        return PipeTaskOperation.CREATE_PIPE;
    }

    @Override
    protected boolean executeFromValidateTask(ConfigNodeProcedureEnv env) throws PipeException {
        LOGGER.info("CreatePipeProcedureV2: executeFromValidateTask({})", (Object)this.createPipeRequest.getPipeName());
        PipeManager pipeManager = env.getConfigManager().getPipeManager();
        pipeManager.getPipePluginCoordinator().getPipePluginInfo().checkBeforeCreatePipe(this.createPipeRequest);
        ((PipeTaskInfo)this.pipeTaskInfo.get()).checkBeforeCreatePipe(this.createPipeRequest);
        return false;
    }

    @Override
    protected void executeFromCalculateInfoForTask(ConfigNodeProcedureEnv env) {
        LOGGER.info("CreatePipeProcedureV2: executeFromCalculateInfoForTask({})", (Object)this.createPipeRequest.getPipeName());
        this.pipeStaticMeta = new PipeStaticMeta(this.createPipeRequest.getPipeName(), System.currentTimeMillis(), this.createPipeRequest.getExtractorAttributes(), this.createPipeRequest.getProcessorAttributes(), this.createPipeRequest.getConnectorAttributes());
        HashMap consensusGroupIdToTaskMetaMap = new HashMap();
        env.getConfigManager().getLoadManager().getRegionLeaderMap().forEach((regionGroupId, regionLeaderNodeId) -> {
            String databaseName;
            if (regionGroupId.getType().equals((Object)TConsensusGroupType.DataRegion) && (databaseName = env.getConfigManager().getPartitionManager().getRegionStorageGroup((TConsensusGroupId)regionGroupId)) != null && !databaseName.equals("root.__system")) {
                consensusGroupIdToTaskMetaMap.put(regionGroupId, new PipeTaskMeta((ProgressIndex)MinimumProgressIndex.INSTANCE, regionLeaderNodeId.intValue()));
            }
        });
        this.pipeRuntimeMeta = new PipeRuntimeMeta(consensusGroupIdToTaskMetaMap);
        this.pipeRuntimeMeta.getStatus().set(PipeStatus.RUNNING);
    }

    @Override
    protected void executeFromWriteConfigNodeConsensus(ConfigNodeProcedureEnv env) throws PipeException {
        TSStatus response;
        LOGGER.info("CreatePipeProcedureV2: executeFromWriteConfigNodeConsensus({})", (Object)this.createPipeRequest.getPipeName());
        try {
            response = env.getConfigManager().getConsensusManager().write(new CreatePipePlanV2(this.pipeStaticMeta, this.pipeRuntimeMeta));
        }
        catch (ConsensusException e) {
            LOGGER.warn("Failed in the write API executing the consensus layer due to: ", (Throwable)e);
            response = new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode());
            response.setMessage(e.getMessage());
        }
        if (response.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            throw new PipeException(response.getMessage());
        }
    }

    @Override
    protected void executeFromOperateOnDataNodes(ConfigNodeProcedureEnv env) throws IOException {
        String pipeName = this.createPipeRequest.getPipeName();
        LOGGER.info("CreatePipeProcedureV2: executeFromOperateOnDataNodes({})", (Object)pipeName);
        String exceptionMessage = this.parsePushPipeMetaExceptionForPipe(pipeName, this.pushSinglePipeMetaToDataNodes(pipeName, env));
        if (!exceptionMessage.isEmpty()) {
            LOGGER.warn("Failed to create pipe {}, details: {}, metadata will be synchronized later.", (Object)this.createPipeRequest.getPipeName(), (Object)exceptionMessage);
        }
    }

    @Override
    protected void rollbackFromValidateTask(ConfigNodeProcedureEnv env) {
        LOGGER.info("CreatePipeProcedureV2: rollbackFromValidateTask({})", (Object)this.createPipeRequest.getPipeName());
    }

    @Override
    protected void rollbackFromCalculateInfoForTask(ConfigNodeProcedureEnv env) {
        LOGGER.info("CreatePipeProcedureV2: rollbackFromCalculateInfoForTask({})", (Object)this.createPipeRequest.getPipeName());
    }

    @Override
    protected void rollbackFromWriteConfigNodeConsensus(ConfigNodeProcedureEnv env) {
        TSStatus response;
        LOGGER.info("CreatePipeProcedureV2: rollbackFromWriteConfigNodeConsensus({})", (Object)this.createPipeRequest.getPipeName());
        try {
            response = env.getConfigManager().getConsensusManager().write(new DropPipePlanV2(this.createPipeRequest.getPipeName()));
        }
        catch (ConsensusException e) {
            LOGGER.warn("Failed in the write API executing the consensus layer due to: ", (Throwable)e);
            response = new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode());
            response.setMessage(e.getMessage());
        }
        if (response.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            throw new PipeException(response.getMessage());
        }
    }

    @Override
    protected void rollbackFromOperateOnDataNodes(ConfigNodeProcedureEnv env) throws IOException {
        LOGGER.info("CreatePipeProcedureV2: rollbackFromOperateOnDataNodes({})", (Object)this.createPipeRequest.getPipeName());
        String exceptionMessage = this.parsePushPipeMetaExceptionForPipe(this.createPipeRequest.getPipeName(), this.pushPipeMetaToDataNodes(env));
        if (!exceptionMessage.isEmpty()) {
            LOGGER.warn("Failed to rollback create pipe {}, details: {}, metadata will be synchronized later.", (Object)this.createPipeRequest.getPipeName(), (Object)exceptionMessage);
        }
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        stream.writeShort(ProcedureType.CREATE_PIPE_PROCEDURE_V2.getTypeCode());
        super.serialize(stream);
        ReadWriteIOUtils.write((String)this.createPipeRequest.getPipeName(), (OutputStream)stream);
        ReadWriteIOUtils.write((int)this.createPipeRequest.getExtractorAttributesSize(), (OutputStream)stream);
        for (Map.Entry entry : this.createPipeRequest.getExtractorAttributes().entrySet()) {
            ReadWriteIOUtils.write((String)((String)entry.getKey()), (OutputStream)stream);
            ReadWriteIOUtils.write((String)((String)entry.getValue()), (OutputStream)stream);
        }
        ReadWriteIOUtils.write((int)this.createPipeRequest.getProcessorAttributesSize(), (OutputStream)stream);
        for (Map.Entry entry : this.createPipeRequest.getProcessorAttributes().entrySet()) {
            ReadWriteIOUtils.write((String)((String)entry.getKey()), (OutputStream)stream);
            ReadWriteIOUtils.write((String)((String)entry.getValue()), (OutputStream)stream);
        }
        ReadWriteIOUtils.write((int)this.createPipeRequest.getConnectorAttributesSize(), (OutputStream)stream);
        for (Map.Entry entry : this.createPipeRequest.getConnectorAttributes().entrySet()) {
            ReadWriteIOUtils.write((String)((String)entry.getKey()), (OutputStream)stream);
            ReadWriteIOUtils.write((String)((String)entry.getValue()), (OutputStream)stream);
        }
        if (this.pipeStaticMeta != null) {
            ReadWriteIOUtils.write((Boolean)true, (OutputStream)stream);
            this.pipeStaticMeta.serialize(stream);
        } else {
            ReadWriteIOUtils.write((Boolean)false, (OutputStream)stream);
        }
    }

    @Override
    public void deserialize(ByteBuffer byteBuffer) {
        int i;
        super.deserialize(byteBuffer);
        this.createPipeRequest = new TCreatePipeReq().setPipeName(ReadWriteIOUtils.readString((ByteBuffer)byteBuffer)).setExtractorAttributes(new HashMap()).setProcessorAttributes(new HashMap()).setConnectorAttributes(new HashMap());
        int size = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        for (i = 0; i < size; ++i) {
            this.createPipeRequest.getExtractorAttributes().put(ReadWriteIOUtils.readString((ByteBuffer)byteBuffer), ReadWriteIOUtils.readString((ByteBuffer)byteBuffer));
        }
        size = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        for (i = 0; i < size; ++i) {
            this.createPipeRequest.getProcessorAttributes().put(ReadWriteIOUtils.readString((ByteBuffer)byteBuffer), ReadWriteIOUtils.readString((ByteBuffer)byteBuffer));
        }
        size = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        for (i = 0; i < size; ++i) {
            this.createPipeRequest.getConnectorAttributes().put(ReadWriteIOUtils.readString((ByteBuffer)byteBuffer), ReadWriteIOUtils.readString((ByteBuffer)byteBuffer));
        }
        if (ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer)) {
            this.pipeStaticMeta = PipeStaticMeta.deserialize((ByteBuffer)byteBuffer);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreatePipeProcedureV2 that = (CreatePipeProcedureV2)o;
        return this.createPipeRequest.getPipeName().equals(that.createPipeRequest.getPipeName());
    }

    public int hashCode() {
        return Objects.hash(this.createPipeRequest.getPipeName());
    }
}

