/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.impl.schema;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.confignode.client.DataNodeRequestType;
import org.apache.iotdb.confignode.client.async.AsyncDataNodeClientPool;
import org.apache.iotdb.confignode.client.async.handlers.AsyncClientHandler;
import org.apache.iotdb.confignode.procedure.env.ConfigNodeProcedureEnv;
import org.apache.iotdb.confignode.procedure.impl.schema.DataNodeRegionGroupUtil;

public abstract class DataNodeRegionTaskExecutor<Q, R> {
    protected final ConfigNodeProcedureEnv env;
    protected final Map<TConsensusGroupId, TRegionReplicaSet> targetSchemaRegionGroup;
    protected final boolean executeOnAllReplicaset;
    protected final DataNodeRequestType dataNodeRequestType;
    protected final BiFunction<TDataNodeLocation, List<TConsensusGroupId>, Q> dataNodeRequestGenerator;
    private boolean isInterrupted = false;

    protected DataNodeRegionTaskExecutor(ConfigNodeProcedureEnv env, Map<TConsensusGroupId, TRegionReplicaSet> targetSchemaRegionGroup, boolean executeOnAllReplicaset, DataNodeRequestType dataNodeRequestType, BiFunction<TDataNodeLocation, List<TConsensusGroupId>, Q> dataNodeRequestGenerator) {
        this.env = env;
        this.targetSchemaRegionGroup = targetSchemaRegionGroup;
        this.executeOnAllReplicaset = executeOnAllReplicaset;
        this.dataNodeRequestType = dataNodeRequestType;
        this.dataNodeRequestGenerator = dataNodeRequestGenerator;
    }

    void execute() {
        Map<TDataNodeLocation, List<TConsensusGroupId>> dataNodeConsensusGroupIdMap;
        HashMap<TConsensusGroupId, Set<TDataNodeLocation>> failedHistory = new HashMap<TConsensusGroupId, Set<TDataNodeLocation>>();
        Map<TDataNodeLocation, List<TConsensusGroupId>> map = dataNodeConsensusGroupIdMap = this.executeOnAllReplicaset ? DataNodeRegionGroupUtil.getAllReplicaDataNodeRegionGroupMap(this.targetSchemaRegionGroup) : DataNodeRegionGroupUtil.getLeaderDataNodeRegionGroupMap(this.env.getConfigManager().getLoadManager().getRegionLeaderMap(), this.targetSchemaRegionGroup);
        while (!dataNodeConsensusGroupIdMap.isEmpty()) {
            AsyncClientHandler<Q, R> clientHandler = this.prepareRequestHandler(dataNodeConsensusGroupIdMap);
            AsyncDataNodeClientPool.getInstance().sendAsyncRequestToDataNodeWithRetry(clientHandler);
            Map<TDataNodeLocation, List<TConsensusGroupId>> currentFailedDataNodeMap = this.checkDataNodeExecutionResult(clientHandler.getResponseMap(), dataNodeConsensusGroupIdMap);
            if (this.isInterrupted) {
                return;
            }
            if (currentFailedDataNodeMap.isEmpty()) break;
            dataNodeConsensusGroupIdMap = this.getAvailableDataNodeLocationForRetry(currentFailedDataNodeMap, failedHistory);
            if (!this.isInterrupted) continue;
            return;
        }
    }

    private AsyncClientHandler<Q, R> prepareRequestHandler(Map<TDataNodeLocation, List<TConsensusGroupId>> dataNodeConsensusGroupIdMap) {
        AsyncClientHandler clientHandler = new AsyncClientHandler(this.dataNodeRequestType);
        for (Map.Entry<TDataNodeLocation, List<TConsensusGroupId>> entry : dataNodeConsensusGroupIdMap.entrySet()) {
            clientHandler.putDataNodeLocation(entry.getKey().getDataNodeId(), entry.getKey());
            clientHandler.putRequest(entry.getKey().getDataNodeId(), this.dataNodeRequestGenerator.apply(entry.getKey(), entry.getValue()));
        }
        return clientHandler;
    }

    private Map<TDataNodeLocation, List<TConsensusGroupId>> checkDataNodeExecutionResult(Map<Integer, R> executionResult, Map<TDataNodeLocation, List<TConsensusGroupId>> dataNodeConsensusGroupIdMap) {
        HashMap<TDataNodeLocation, List<TConsensusGroupId>> currentFailedDataNodeMap = new HashMap<TDataNodeLocation, List<TConsensusGroupId>>();
        for (Map.Entry<TDataNodeLocation, List<TConsensusGroupId>> entry : dataNodeConsensusGroupIdMap.entrySet()) {
            R response = executionResult.get(entry.getKey().getDataNodeId());
            List<TConsensusGroupId> failedRegionList = this.processResponseOfOneDataNode(entry.getKey(), entry.getValue(), response);
            if (failedRegionList.isEmpty()) continue;
            currentFailedDataNodeMap.put(entry.getKey(), failedRegionList);
        }
        return currentFailedDataNodeMap;
    }

    private Map<TDataNodeLocation, List<TConsensusGroupId>> getAvailableDataNodeLocationForRetry(Map<TDataNodeLocation, List<TConsensusGroupId>> failedDataNodeConsensusGroupIdMap, Map<TConsensusGroupId, Set<TDataNodeLocation>> failedHistory) {
        failedDataNodeConsensusGroupIdMap.forEach((k, v) -> {
            for (TConsensusGroupId consensusGroupId : v) {
                failedHistory.computeIfAbsent(consensusGroupId, o -> new HashSet()).add(k);
            }
        });
        HashMap<TDataNodeLocation, List<TConsensusGroupId>> availableDataNodeLocation = new HashMap<TDataNodeLocation, List<TConsensusGroupId>>();
        Map<TConsensusGroupId, Integer> leaderMap = this.env.getConfigManager().getLoadManager().getRegionLeaderMap();
        for (List<TConsensusGroupId> consensusGroupIdList : failedDataNodeConsensusGroupIdMap.values()) {
            for (TConsensusGroupId consensusGroupId : consensusGroupIdList) {
                Set<TDataNodeLocation> failedDataNodeSet;
                TRegionReplicaSet regionReplicaSet = this.targetSchemaRegionGroup.get(consensusGroupId);
                TDataNodeLocation selectedDataNode = null;
                Integer leaderId = leaderMap.get(consensusGroupId);
                if (leaderId == null || leaderId == -1) {
                    for (TDataNodeLocation candidateDataNode : regionReplicaSet.getDataNodeLocations()) {
                        failedDataNodeSet = failedHistory.get(consensusGroupId);
                        if (failedDataNodeSet != null && failedDataNodeSet.contains(candidateDataNode)) continue;
                        selectedDataNode = candidateDataNode;
                        break;
                    }
                } else {
                    for (TDataNodeLocation candidateDataNode : regionReplicaSet.getDataNodeLocations()) {
                        failedDataNodeSet = failedHistory.get(consensusGroupId);
                        if (failedDataNodeSet != null && failedDataNodeSet.contains(candidateDataNode)) continue;
                        if (leaderId.intValue() == candidateDataNode.getDataNodeId()) {
                            selectedDataNode = candidateDataNode;
                            break;
                        }
                        if (selectedDataNode != null) continue;
                        selectedDataNode = candidateDataNode;
                    }
                }
                if (selectedDataNode == null) {
                    this.onAllReplicasetFailure(consensusGroupId, failedHistory.get(consensusGroupId));
                    continue;
                }
                availableDataNodeLocation.computeIfAbsent(selectedDataNode, k -> new ArrayList()).add(consensusGroupId);
            }
        }
        return availableDataNodeLocation;
    }

    protected final void interruptTask() {
        this.isInterrupted = true;
    }

    protected abstract List<TConsensusGroupId> processResponseOfOneDataNode(TDataNodeLocation var1, List<TConsensusGroupId> var2, R var3);

    protected abstract void onAllReplicasetFailure(TConsensusGroupId var1, Set<TDataNodeLocation> var2);
}

