/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.store;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.iotdb.confignode.procedure.Procedure;
import org.apache.iotdb.confignode.procedure.impl.cq.CreateCQProcedure;
import org.apache.iotdb.confignode.procedure.impl.node.AddConfigNodeProcedure;
import org.apache.iotdb.confignode.procedure.impl.node.RemoveConfigNodeProcedure;
import org.apache.iotdb.confignode.procedure.impl.node.RemoveDataNodeProcedure;
import org.apache.iotdb.confignode.procedure.impl.pipe.plugin.CreatePipePluginProcedure;
import org.apache.iotdb.confignode.procedure.impl.pipe.plugin.DropPipePluginProcedure;
import org.apache.iotdb.confignode.procedure.impl.pipe.runtime.PipeHandleLeaderChangeProcedure;
import org.apache.iotdb.confignode.procedure.impl.pipe.runtime.PipeHandleMetaChangeProcedure;
import org.apache.iotdb.confignode.procedure.impl.pipe.runtime.PipeMetaSyncProcedure;
import org.apache.iotdb.confignode.procedure.impl.pipe.task.CreatePipeProcedureV2;
import org.apache.iotdb.confignode.procedure.impl.pipe.task.DropPipeProcedureV2;
import org.apache.iotdb.confignode.procedure.impl.pipe.task.StartPipeProcedureV2;
import org.apache.iotdb.confignode.procedure.impl.pipe.task.StopPipeProcedureV2;
import org.apache.iotdb.confignode.procedure.impl.schema.AlterLogicalViewProcedure;
import org.apache.iotdb.confignode.procedure.impl.schema.DeactivateTemplateProcedure;
import org.apache.iotdb.confignode.procedure.impl.schema.DeleteDatabaseProcedure;
import org.apache.iotdb.confignode.procedure.impl.schema.DeleteLogicalViewProcedure;
import org.apache.iotdb.confignode.procedure.impl.schema.DeleteTimeSeriesProcedure;
import org.apache.iotdb.confignode.procedure.impl.schema.SetTemplateProcedure;
import org.apache.iotdb.confignode.procedure.impl.schema.UnsetTemplateProcedure;
import org.apache.iotdb.confignode.procedure.impl.statemachine.CreateRegionGroupsProcedure;
import org.apache.iotdb.confignode.procedure.impl.statemachine.RegionMigrateProcedure;
import org.apache.iotdb.confignode.procedure.impl.statemachine.StateMachineProcedure;
import org.apache.iotdb.confignode.procedure.impl.sync.AuthOperationProcedure;
import org.apache.iotdb.confignode.procedure.impl.sync.CreatePipeProcedure;
import org.apache.iotdb.confignode.procedure.impl.sync.DropPipeProcedure;
import org.apache.iotdb.confignode.procedure.impl.sync.StartPipeProcedure;
import org.apache.iotdb.confignode.procedure.impl.sync.StopPipeProcedure;
import org.apache.iotdb.confignode.procedure.impl.trigger.CreateTriggerProcedure;
import org.apache.iotdb.confignode.procedure.impl.trigger.DropTriggerProcedure;
import org.apache.iotdb.confignode.procedure.store.IProcedureFactory;
import org.apache.iotdb.confignode.procedure.store.ProcedureType;
import org.apache.iotdb.confignode.service.ConfigNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcedureFactory
implements IProcedureFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcedureFactory.class);

    @Override
    public Procedure create(ByteBuffer buffer) throws IOException {
        StateMachineProcedure procedure;
        short typeCode = buffer.getShort();
        ProcedureType procedureType = ProcedureType.convertToProcedureType(typeCode);
        if (procedureType == null) {
            LOGGER.error("unrecognized log type " + typeCode);
            throw new IOException("unrecognized log type " + typeCode);
        }
        switch (procedureType) {
            case DELETE_STORAGE_GROUP_PROCEDURE: {
                procedure = new DeleteDatabaseProcedure();
                break;
            }
            case ADD_CONFIG_NODE_PROCEDURE: {
                procedure = new AddConfigNodeProcedure();
                break;
            }
            case REMOVE_CONFIG_NODE_PROCEDURE: {
                procedure = new RemoveConfigNodeProcedure();
                break;
            }
            case REMOVE_DATA_NODE_PROCEDURE: {
                procedure = new RemoveDataNodeProcedure();
                break;
            }
            case REGION_MIGRATE_PROCEDURE: {
                procedure = new RegionMigrateProcedure();
                break;
            }
            case CREATE_REGION_GROUPS: {
                procedure = new CreateRegionGroupsProcedure();
                break;
            }
            case DELETE_TIMESERIES_PROCEDURE: {
                procedure = new DeleteTimeSeriesProcedure();
                break;
            }
            case DELETE_LOGICAL_VIEW_PROCEDURE: {
                procedure = new DeleteLogicalViewProcedure();
                break;
            }
            case ALTER_LOGICAL_VIEW_PROCEDURE: {
                procedure = new AlterLogicalViewProcedure();
                break;
            }
            case CREATE_TRIGGER_PROCEDURE: {
                procedure = new CreateTriggerProcedure();
                break;
            }
            case DROP_TRIGGER_PROCEDURE: {
                procedure = new DropTriggerProcedure();
                break;
            }
            case CREATE_PIPE_PROCEDURE: {
                procedure = new CreatePipeProcedure();
                break;
            }
            case START_PIPE_PROCEDURE: {
                procedure = new StartPipeProcedure();
                break;
            }
            case STOP_PIPE_PROCEDURE: {
                procedure = new StopPipeProcedure();
                break;
            }
            case DROP_PIPE_PROCEDURE: {
                procedure = new DropPipeProcedure();
                break;
            }
            case CREATE_PIPE_PROCEDURE_V2: {
                procedure = new CreatePipeProcedureV2();
                break;
            }
            case START_PIPE_PROCEDURE_V2: {
                procedure = new StartPipeProcedureV2();
                break;
            }
            case STOP_PIPE_PROCEDURE_V2: {
                procedure = new StopPipeProcedureV2();
                break;
            }
            case DROP_PIPE_PROCEDURE_V2: {
                procedure = new DropPipeProcedureV2();
                break;
            }
            case PIPE_HANDLE_LEADER_CHANGE_PROCEDURE: {
                procedure = new PipeHandleLeaderChangeProcedure();
                break;
            }
            case PIPE_META_SYNC_PROCEDURE: {
                procedure = new PipeMetaSyncProcedure();
                break;
            }
            case PIPE_HANDLE_META_CHANGE_PROCEDURE: {
                procedure = new PipeHandleMetaChangeProcedure();
                break;
            }
            case CREATE_CQ_PROCEDURE: {
                procedure = new CreateCQProcedure(ConfigNode.getInstance().getConfigManager().getCQManager().getExecutor());
                break;
            }
            case SET_TEMPLATE_PROCEDURE: {
                procedure = new SetTemplateProcedure();
                break;
            }
            case DEACTIVATE_TEMPLATE_PROCEDURE: {
                procedure = new DeactivateTemplateProcedure();
                break;
            }
            case UNSET_TEMPLATE_PROCEDURE: {
                procedure = new UnsetTemplateProcedure();
                break;
            }
            case CREATE_PIPE_PLUGIN_PROCEDURE: {
                procedure = new CreatePipePluginProcedure();
                break;
            }
            case DROP_PIPE_PLUGIN_PROCEDURE: {
                procedure = new DropPipePluginProcedure();
                break;
            }
            case AUTH_OPERATE_PROCEDURE: {
                procedure = new AuthOperationProcedure();
                break;
            }
            default: {
                LOGGER.error("unknown Procedure type: " + typeCode);
                throw new IOException("unknown Procedure type: " + typeCode);
            }
        }
        ((Procedure)procedure).deserialize(buffer);
        return procedure;
    }

    public static ProcedureType getProcedureType(Procedure procedure) {
        if (procedure instanceof DeleteDatabaseProcedure) {
            return ProcedureType.DELETE_STORAGE_GROUP_PROCEDURE;
        }
        if (procedure instanceof AddConfigNodeProcedure) {
            return ProcedureType.ADD_CONFIG_NODE_PROCEDURE;
        }
        if (procedure instanceof RemoveConfigNodeProcedure) {
            return ProcedureType.REMOVE_CONFIG_NODE_PROCEDURE;
        }
        if (procedure instanceof RemoveDataNodeProcedure) {
            return ProcedureType.REMOVE_DATA_NODE_PROCEDURE;
        }
        if (procedure instanceof RegionMigrateProcedure) {
            return ProcedureType.REGION_MIGRATE_PROCEDURE;
        }
        if (procedure instanceof CreateRegionGroupsProcedure) {
            return ProcedureType.CREATE_REGION_GROUPS;
        }
        if (procedure instanceof DeleteTimeSeriesProcedure) {
            return ProcedureType.DELETE_TIMESERIES_PROCEDURE;
        }
        if (procedure instanceof CreateTriggerProcedure) {
            return ProcedureType.CREATE_TRIGGER_PROCEDURE;
        }
        if (procedure instanceof DropTriggerProcedure) {
            return ProcedureType.DROP_TRIGGER_PROCEDURE;
        }
        if (procedure instanceof CreatePipeProcedure) {
            return ProcedureType.CREATE_PIPE_PROCEDURE;
        }
        if (procedure instanceof StartPipeProcedure) {
            return ProcedureType.START_PIPE_PROCEDURE;
        }
        if (procedure instanceof StopPipeProcedure) {
            return ProcedureType.STOP_PIPE_PROCEDURE;
        }
        if (procedure instanceof DropPipeProcedure) {
            return ProcedureType.DROP_PIPE_PROCEDURE;
        }
        if (procedure instanceof CreateCQProcedure) {
            return ProcedureType.CREATE_CQ_PROCEDURE;
        }
        if (procedure instanceof SetTemplateProcedure) {
            return ProcedureType.SET_TEMPLATE_PROCEDURE;
        }
        if (procedure instanceof DeactivateTemplateProcedure) {
            return ProcedureType.DEACTIVATE_TEMPLATE_PROCEDURE;
        }
        if (procedure instanceof UnsetTemplateProcedure) {
            return ProcedureType.UNSET_TEMPLATE_PROCEDURE;
        }
        if (procedure instanceof CreatePipePluginProcedure) {
            return ProcedureType.CREATE_PIPE_PLUGIN_PROCEDURE;
        }
        if (procedure instanceof DropPipePluginProcedure) {
            return ProcedureType.DROP_PIPE_PLUGIN_PROCEDURE;
        }
        if (procedure instanceof CreatePipeProcedureV2) {
            return ProcedureType.CREATE_PIPE_PROCEDURE_V2;
        }
        if (procedure instanceof StartPipeProcedureV2) {
            return ProcedureType.START_PIPE_PROCEDURE_V2;
        }
        if (procedure instanceof StopPipeProcedureV2) {
            return ProcedureType.STOP_PIPE_PROCEDURE_V2;
        }
        if (procedure instanceof DropPipeProcedureV2) {
            return ProcedureType.DROP_PIPE_PROCEDURE_V2;
        }
        if (procedure instanceof PipeHandleLeaderChangeProcedure) {
            return ProcedureType.PIPE_HANDLE_LEADER_CHANGE_PROCEDURE;
        }
        if (procedure instanceof PipeMetaSyncProcedure) {
            return ProcedureType.PIPE_META_SYNC_PROCEDURE;
        }
        if (procedure instanceof PipeHandleMetaChangeProcedure) {
            return ProcedureType.PIPE_HANDLE_META_CHANGE_PROCEDURE;
        }
        if (procedure instanceof DeleteLogicalViewProcedure) {
            return ProcedureType.DELETE_LOGICAL_VIEW_PROCEDURE;
        }
        if (procedure instanceof AlterLogicalViewProcedure) {
            return ProcedureType.ALTER_LOGICAL_VIEW_PROCEDURE;
        }
        if (procedure instanceof AuthOperationProcedure) {
            return ProcedureType.AUTH_OPERATE_PROCEDURE;
        }
        return null;
    }

    public static ProcedureFactory getInstance() {
        return ProcedureFactoryHolder.INSTANCE;
    }

    private static class ProcedureFactoryHolder {
        private static final ProcedureFactory INSTANCE = new ProcedureFactory();

        private ProcedureFactoryHolder() {
        }
    }
}

