/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.consensus.iot.snapshot;

import java.nio.ByteBuffer;
import org.apache.iotdb.consensus.iot.thrift.TSendSnapshotFragmentReq;

public class SnapshotFragment {
    private final String snapshotId;
    private final String filePath;
    private final long totalSize;
    private final long startOffset;
    private final long fragmentSize;
    private final ByteBuffer fileChunk;

    public SnapshotFragment(String snapshotId, String filePath, long totalSize, long startOffset, long fragmentSize, ByteBuffer fileChunk) {
        this.snapshotId = snapshotId;
        this.filePath = filePath;
        this.totalSize = totalSize;
        this.startOffset = startOffset;
        this.fragmentSize = fragmentSize;
        this.fileChunk = fileChunk;
    }

    public TSendSnapshotFragmentReq toTSendSnapshotFragmentReq() {
        TSendSnapshotFragmentReq req = new TSendSnapshotFragmentReq();
        req.setSnapshotId(this.snapshotId);
        req.setFilePath(this.filePath);
        req.setChunkLength(this.fragmentSize);
        req.setFileChunk(this.fileChunk);
        return req;
    }

    public String getSnapshotId() {
        return this.snapshotId;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public long getTotalSize() {
        return this.totalSize;
    }

    public long getStartOffset() {
        return this.startOffset;
    }

    public long getFragmentSize() {
        return this.fragmentSize;
    }

    public ByteBuffer getFileChunk() {
        return this.fileChunk;
    }
}

