/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.broker.subscriptions;

import io.moquette.broker.subscriptions.CNode;
import io.moquette.broker.subscriptions.DumpTreeVisitor;
import io.moquette.broker.subscriptions.INode;
import io.moquette.broker.subscriptions.Subscription;
import io.moquette.broker.subscriptions.SubscriptionCounterVisitor;
import io.moquette.broker.subscriptions.TNode;
import io.moquette.broker.subscriptions.Token;
import io.moquette.broker.subscriptions.Topic;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class CTrie {
    private static final Token ROOT = new Token("root");
    private static final INode NO_PARENT = null;
    INode root;

    CTrie() {
        CNode mainNode = new CNode(ROOT);
        this.root = new INode(mainNode);
    }

    Optional<CNode> lookup(Topic topic) {
        Optional<INode> child;
        INode inode = this.root;
        Token token = topic.headToken();
        while (!topic.isEmpty() && !(child = inode.mainNode().childOf(token)).isEmpty()) {
            topic = topic.exceptHeadToken();
            inode = child.get();
            token = topic.headToken();
        }
        if (inode == null || !topic.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(inode.mainNode());
    }

    private NavigationAction evaluate(Topic topic, CNode cnode) {
        if (Token.MULTI.equals(cnode.getToken())) {
            return NavigationAction.MATCH;
        }
        if (topic.isEmpty()) {
            return NavigationAction.STOP;
        }
        Token token = topic.headToken();
        if (!(Token.SINGLE.equals(cnode.getToken()) || cnode.getToken().equals(token) || ROOT.equals(cnode.getToken()))) {
            return NavigationAction.STOP;
        }
        return NavigationAction.GODEEP;
    }

    public List<Subscription> recursiveMatch(Topic topic) {
        return this.recursiveMatch(topic, this.root);
    }

    private List<Subscription> recursiveMatch(Topic topic, INode inode) {
        CNode cnode = inode.mainNode();
        if (cnode instanceof TNode) {
            return Collections.emptyList();
        }
        NavigationAction action = this.evaluate(topic, cnode);
        if (action == NavigationAction.MATCH) {
            return cnode.subscriptions;
        }
        if (action == NavigationAction.STOP) {
            return Collections.emptyList();
        }
        Topic remainingTopic = ROOT.equals(cnode.getToken()) ? topic : topic.exceptHeadToken();
        ArrayList<Subscription> subscriptions = new ArrayList<Subscription>();
        Optional<INode> subInode = cnode.childOf(Token.MULTI);
        if (subInode.isPresent()) {
            subscriptions.addAll(this.recursiveMatch(remainingTopic, subInode.get()));
        }
        if ((subInode = cnode.childOf(Token.SINGLE)).isPresent()) {
            subscriptions.addAll(this.recursiveMatch(remainingTopic, subInode.get()));
        }
        if (remainingTopic.isEmpty()) {
            subscriptions.addAll(cnode.subscriptions);
        } else {
            subInode = cnode.childOf(remainingTopic.headToken());
            if (subInode.isPresent()) {
                subscriptions.addAll(this.recursiveMatch(remainingTopic, subInode.get()));
            }
        }
        return subscriptions;
    }

    public void addToTree(Subscription newSubscription) {
        Action res;
        while ((res = this.insert(newSubscription.topicFilter, this.root, newSubscription)) == Action.REPEAT) {
        }
    }

    private Action insert(Topic topic, INode inode, Subscription newSubscription) {
        Optional<INode> nextInode;
        Token token = topic.headToken();
        CNode cnode = inode.mainNode();
        if (!topic.isEmpty() && (nextInode = cnode.childOf(token)).isPresent()) {
            Topic remainingTopic = topic.exceptHeadToken();
            return this.insert(remainingTopic, nextInode.get(), newSubscription);
        }
        if (topic.isEmpty()) {
            return this.insertSubscription(inode, cnode, newSubscription);
        }
        return this.createNodeAndInsertSubscription(topic, inode, cnode, newSubscription);
    }

    private Action insertSubscription(INode inode, CNode cnode, Subscription newSubscription) {
        CNode updatedCnode = cnode instanceof TNode ? new CNode(cnode.getToken()) : cnode.copy();
        updatedCnode.addSubscription(newSubscription);
        return inode.compareAndSet(cnode, updatedCnode) ? Action.OK : Action.REPEAT;
    }

    private Action createNodeAndInsertSubscription(Topic topic, INode inode, CNode cnode, Subscription newSubscription) {
        INode newInode = this.createPathRec(topic, newSubscription);
        CNode updatedCnode = cnode instanceof TNode ? new CNode(cnode.getToken()) : cnode.copy();
        updatedCnode.add(newInode);
        return inode.compareAndSet(cnode, updatedCnode) ? Action.OK : Action.REPEAT;
    }

    private INode createPathRec(Topic topic, Subscription newSubscription) {
        Topic remainingTopic = topic.exceptHeadToken();
        if (!remainingTopic.isEmpty()) {
            INode inode = this.createPathRec(remainingTopic, newSubscription);
            CNode cnode = new CNode(topic.headToken());
            cnode.add(inode);
            return new INode(cnode);
        }
        return this.createLeafNodes(topic.headToken(), newSubscription);
    }

    private INode createLeafNodes(Token token, Subscription newSubscription) {
        CNode newLeafCnode = new CNode(token);
        newLeafCnode.addSubscription(newSubscription);
        return new INode(newLeafCnode);
    }

    public void removeFromTree(Topic topic, String clientID) {
        Action res;
        while ((res = this.remove(clientID, topic, this.root, NO_PARENT)) == Action.REPEAT) {
        }
    }

    private Action remove(String clientId, Topic topic, INode inode, INode iParent) {
        Optional<INode> nextInode;
        Token token = topic.headToken();
        CNode cnode = inode.mainNode();
        if (!topic.isEmpty() && (nextInode = cnode.childOf(token)).isPresent()) {
            Topic remainingTopic = topic.exceptHeadToken();
            return this.remove(clientId, remainingTopic, nextInode.get(), inode);
        }
        if (cnode instanceof TNode) {
            return Action.OK;
        }
        if (cnode.containsOnly(clientId) && topic.isEmpty() && cnode.allChildren().isEmpty()) {
            if (inode == this.root) {
                return inode.compareAndSet(cnode, inode.mainNode().copy()) ? Action.OK : Action.REPEAT;
            }
            TNode tnode = new TNode(cnode.getToken());
            return inode.compareAndSet(cnode, tnode) ? this.cleanTomb(inode, iParent) : Action.REPEAT;
        }
        if (cnode.contains(clientId) && topic.isEmpty()) {
            CNode updatedCnode = cnode.copy();
            updatedCnode.removeSubscriptionsFor(clientId);
            return inode.compareAndSet(cnode, updatedCnode) ? Action.OK : Action.REPEAT;
        }
        return Action.OK;
    }

    private Action cleanTomb(INode inode, INode iParent) {
        CNode updatedCnode = iParent.mainNode().copy();
        updatedCnode.remove(inode);
        return iParent.compareAndSet(iParent.mainNode(), updatedCnode) ? Action.OK : Action.REPEAT;
    }

    public int size() {
        SubscriptionCounterVisitor visitor = new SubscriptionCounterVisitor();
        this.dfsVisit(this.root, visitor, 0);
        return visitor.getResult();
    }

    public String dumpTree() {
        DumpTreeVisitor visitor = new DumpTreeVisitor();
        this.dfsVisit(this.root, visitor, 0);
        return visitor.getResult();
    }

    private void dfsVisit(INode node, IVisitor<?> visitor, int deep) {
        if (node == null) {
            return;
        }
        visitor.visit(node.mainNode(), deep);
        ++deep;
        for (INode child : node.mainNode().allChildren()) {
            this.dfsVisit(child, visitor, deep);
        }
    }

    static enum NavigationAction {
        MATCH,
        GODEEP,
        STOP;

    }

    private static enum Action {
        OK,
        REPEAT;

    }

    static interface IVisitor<T> {
        public void visit(CNode var1, int var2);

        public T getResult();
    }
}

