/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.persistence;

import io.moquette.broker.ISessionsRepository;
import io.netty.handler.codec.mqtt.MqttVersion;
import java.nio.ByteBuffer;
import java.time.Clock;
import java.time.Instant;
import java.util.Collection;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStore;
import org.h2.mvstore.WriteBuffer;
import org.h2.mvstore.type.BasicDataType;
import org.h2.mvstore.type.DataType;
import org.h2.mvstore.type.StringDataType;

class H2SessionsRepository
implements ISessionsRepository {
    private static final byte SESSION_DATA_SERDES_V1 = 1;
    private static final long UNDEFINED_INSTANT = -1L;
    private final MVMap<String, ISessionsRepository.SessionData> sessionMap;
    private final Clock clock;

    public H2SessionsRepository(MVStore mvStore, Clock clock) {
        this.clock = clock;
        MVMap.Builder sessionTypeBuilder = new MVMap.Builder().valueType((DataType)new SessionDataValueType());
        this.sessionMap = mvStore.openMap("sessions_store", (MVMap.MapBuilder)sessionTypeBuilder);
    }

    @Override
    public Collection<ISessionsRepository.SessionData> list() {
        return this.sessionMap.values();
    }

    @Override
    public void saveSession(ISessionsRepository.SessionData session) {
        this.sessionMap.put((Object)session.clientId(), (Object)session);
    }

    @Override
    public void delete(ISessionsRepository.SessionData session) {
        this.sessionMap.remove((Object)session.clientId());
    }

    private MqttVersion readMQTTVersion(byte rawVersion) {
        MqttVersion version;
        switch (rawVersion) {
            case 3: {
                version = MqttVersion.MQTT_3_1;
                break;
            }
            case 4: {
                version = MqttVersion.MQTT_3_1_1;
                break;
            }
            case 5: {
                version = MqttVersion.MQTT_5;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized MQTT version value " + rawVersion);
            }
        }
        return version;
    }

    private final class SessionDataValueType
    extends BasicDataType<ISessionsRepository.SessionData> {
        private final StringDataType stringDataType = new StringDataType();

        private SessionDataValueType() {
        }

        public int getMemory(ISessionsRepository.SessionData obj) {
            return this.stringDataType.getMemory(obj.clientId()) + 8 + 1 + 4;
        }

        public void write(WriteBuffer buff, ISessionsRepository.SessionData obj) {
            buff.put((byte)1);
            this.stringDataType.write(buff, obj.clientId());
            buff.putLong(obj.expiryInstant().orElse(-1L).longValue());
            buff.put(obj.protocolVersion().protocolLevel());
            buff.putInt(obj.expiryInterval());
        }

        public ISessionsRepository.SessionData read(ByteBuffer buff) {
            byte serDesVersion = buff.get();
            if (serDesVersion != 1) {
                throw new IllegalArgumentException("Unrecognized serialization version " + serDesVersion);
            }
            String clientId = this.stringDataType.read(buff);
            long expiresAt = buff.getLong();
            MqttVersion version = H2SessionsRepository.this.readMQTTVersion(buff.get());
            int expiryInterval = buff.getInt();
            if (expiresAt == -1L) {
                return new ISessionsRepository.SessionData(clientId, version, expiryInterval, H2SessionsRepository.this.clock);
            }
            return new ISessionsRepository.SessionData(clientId, Instant.ofEpochMilli(expiresAt), version, expiryInterval, H2SessionsRepository.this.clock);
        }

        public ISessionsRepository.SessionData[] createStorage(int i) {
            return new ISessionsRepository.SessionData[i];
        }
    }
}

