/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.udf.api.customizer.parameter;

import org.apache.iotdb.udf.api.customizer.parameter.UDFParameters;
import org.apache.iotdb.udf.api.exception.UDFAttributeNotProvidedException;
import org.apache.iotdb.udf.api.exception.UDFException;
import org.apache.iotdb.udf.api.exception.UDFInputSeriesDataTypeNotValidException;
import org.apache.iotdb.udf.api.exception.UDFInputSeriesIndexNotValidException;
import org.apache.iotdb.udf.api.exception.UDFInputSeriesNumberNotValidException;
import org.apache.iotdb.udf.api.exception.UDFParameterNotValidException;
import org.apache.iotdb.udf.api.type.Type;

public class UDFParameterValidator {
    private final UDFParameters parameters;

    public UDFParameterValidator(UDFParameters parameters) {
        this.parameters = parameters;
    }

    public UDFParameters getParameters() {
        return this.parameters;
    }

    public UDFParameterValidator validateRequiredAttribute(String attributeKey) throws UDFAttributeNotProvidedException {
        if (!this.parameters.hasAttribute(attributeKey)) {
            throw new UDFAttributeNotProvidedException(attributeKey);
        }
        return this;
    }

    public UDFParameterValidator validateInputSeriesDataType(int index, Type expectedDataType) throws UDFException {
        this.validateInputSeriesIndex(index);
        Type actualDataType = this.parameters.getDataType(index);
        if (!expectedDataType.equals((Object)actualDataType)) {
            throw new UDFInputSeriesDataTypeNotValidException(index, actualDataType, expectedDataType);
        }
        return this;
    }

    public UDFParameterValidator validateInputSeriesDataType(int index, Type ... expectedDataTypes) throws UDFException {
        this.validateInputSeriesIndex(index);
        Type actualDataType = this.parameters.getDataType(index);
        for (Type expectedDataType : expectedDataTypes) {
            if (!expectedDataType.equals((Object)actualDataType)) continue;
            return this;
        }
        throw new UDFInputSeriesDataTypeNotValidException(index, actualDataType, expectedDataTypes);
    }

    public UDFParameterValidator validateInputSeriesNumber(int expectedSeriesNumber) throws UDFInputSeriesNumberNotValidException {
        int actualSeriesNumber = this.parameters.getChildExpressionsSize();
        if (actualSeriesNumber != expectedSeriesNumber) {
            throw new UDFInputSeriesNumberNotValidException(actualSeriesNumber, expectedSeriesNumber);
        }
        return this;
    }

    public UDFParameterValidator validateInputSeriesNumber(int expectedSeriesNumberLowerBound, int expectedSeriesNumberUpperBound) throws UDFInputSeriesNumberNotValidException {
        int actualSeriesNumber = this.parameters.getChildExpressionsSize();
        if (actualSeriesNumber < expectedSeriesNumberLowerBound || expectedSeriesNumberUpperBound < actualSeriesNumber) {
            throw new UDFInputSeriesNumberNotValidException(actualSeriesNumber, expectedSeriesNumberLowerBound, expectedSeriesNumberUpperBound);
        }
        return this;
    }

    public UDFParameterValidator validate(SingleObjectValidationRule validationRule, String messageToThrow, Object argument) throws UDFParameterNotValidException {
        if (!validationRule.validate(argument)) {
            throw new UDFParameterNotValidException(messageToThrow);
        }
        return this;
    }

    public UDFParameterValidator validate(MultipleObjectsValidationRule validationRule, String messageToThrow, Object ... arguments) throws UDFParameterNotValidException {
        if (!validationRule.validate(arguments)) {
            throw new UDFParameterNotValidException(messageToThrow);
        }
        return this;
    }

    private void validateInputSeriesIndex(int index) throws UDFInputSeriesIndexNotValidException {
        int actualSeriesNumber = this.parameters.getChildExpressionsSize();
        if (index < 0 || actualSeriesNumber <= index) {
            throw new UDFInputSeriesIndexNotValidException(index, actualSeriesNumber);
        }
    }

    public static interface MultipleObjectsValidationRule {
        public boolean validate(Object ... var1);
    }

    public static interface SingleObjectValidationRule {
        public boolean validate(Object var1);
    }
}

