/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.connector.payload.evolvable.builder;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.request.PipeTransferTabletBatchReq;
import org.apache.iotdb.db.pipe.event.EnrichedEvent;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeInsertNodeTabletInsertionEvent;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeRawTabletInsertionEvent;
import org.apache.iotdb.db.pipe.resource.PipeResourceManager;
import org.apache.iotdb.db.pipe.resource.memory.PipeMemoryBlock;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertNode;
import org.apache.iotdb.db.storageengine.dataregion.wal.exception.WALPipeException;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.apache.iotdb.pipe.api.event.Event;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.apache.iotdb.tsfile.utils.PublicBAOS;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PipeTransferBatchReqBuilder
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeTransferBatchReqBuilder.class);
    protected final List<Event> events = new ArrayList<Event>();
    protected final List<Long> requestCommitIds = new ArrayList<Long>();
    protected final List<ByteBuffer> binaryBuffers = new ArrayList<ByteBuffer>();
    protected final List<ByteBuffer> insertNodeBuffers = new ArrayList<ByteBuffer>();
    protected final List<ByteBuffer> tabletBuffers = new ArrayList<ByteBuffer>();
    protected final int maxDelayInMs;
    protected long firstEventProcessingTime = Long.MIN_VALUE;
    protected final PipeMemoryBlock allocatedMemoryBlock;
    protected long totalBufferSize = 0L;

    protected PipeTransferBatchReqBuilder(PipeParameters parameters) {
        this.maxDelayInMs = parameters.getIntOrDefault(Arrays.asList("connector.batch.max-delay-seconds", "sink.batch.max-delay-seconds"), 1) * 1000;
        long requestMaxBatchSizeInBytes = parameters.getLongOrDefault(Arrays.asList("connector.batch.size-bytes", "sink.batch.size-bytes"), 0x1000000L);
        this.allocatedMemoryBlock = PipeResourceManager.memory().tryAllocate(requestMaxBatchSizeInBytes).setShrinkMethod(oldMemory -> Math.max(oldMemory / 2L, 0L)).setShrinkCallback((oldMemory, newMemory) -> LOGGER.info("The batch size limit has shrunk from {} to {}.", oldMemory, newMemory)).setExpandMethod(oldMemory -> Math.min(Math.max(oldMemory, 1L) * 2L, requestMaxBatchSizeInBytes)).setExpandCallback((oldMemory, newMemory) -> LOGGER.info("The batch size limit has expanded from {} to {}.", oldMemory, newMemory));
        if (this.getMaxBatchSizeInBytes() != requestMaxBatchSizeInBytes) {
            LOGGER.info("PipeTransferBatchReqBuilder: the max batch size is adjusted from {} to {} due to the memory restriction", (Object)requestMaxBatchSizeInBytes, (Object)this.getMaxBatchSizeInBytes());
        }
    }

    public boolean onEvent(TabletInsertionEvent event) throws IOException, WALPipeException {
        if (!(event instanceof EnrichedEvent)) {
            return false;
        }
        long requestCommitId = ((EnrichedEvent)event).getCommitId();
        if (this.events.isEmpty() || !this.events.get(this.events.size() - 1).equals(event)) {
            this.events.add((Event)event);
            this.requestCommitIds.add(requestCommitId);
            int bufferSize = this.buildTabletInsertionBuffer(event);
            ((EnrichedEvent)event).increaseReferenceCount(PipeTransferBatchReqBuilder.class.getName());
            if (this.firstEventProcessingTime == Long.MIN_VALUE) {
                this.firstEventProcessingTime = System.currentTimeMillis();
            }
            this.totalBufferSize += (long)bufferSize;
        }
        return this.totalBufferSize >= this.getMaxBatchSizeInBytes() || System.currentTimeMillis() - this.firstEventProcessingTime >= (long)this.maxDelayInMs;
    }

    public void onSuccess() {
        this.binaryBuffers.clear();
        this.insertNodeBuffers.clear();
        this.tabletBuffers.clear();
        this.events.clear();
        this.requestCommitIds.clear();
        this.firstEventProcessingTime = Long.MIN_VALUE;
        this.totalBufferSize = 0L;
    }

    public PipeTransferTabletBatchReq toTPipeTransferReq() throws IOException {
        return PipeTransferTabletBatchReq.toTPipeTransferReq(this.binaryBuffers, this.insertNodeBuffers, this.tabletBuffers);
    }

    protected long getMaxBatchSizeInBytes() {
        return this.allocatedMemoryBlock.getMemoryUsageInBytes();
    }

    public boolean isEmpty() {
        return this.binaryBuffers.isEmpty() && this.insertNodeBuffers.isEmpty() && this.tabletBuffers.isEmpty();
    }

    protected int buildTabletInsertionBuffer(TabletInsertionEvent event) throws IOException, WALPipeException {
        ByteBuffer buffer;
        if (event instanceof PipeInsertNodeTabletInsertionEvent) {
            PipeInsertNodeTabletInsertionEvent pipeInsertNodeTabletInsertionEvent = (PipeInsertNodeTabletInsertionEvent)event;
            InsertNode insertNode = pipeInsertNodeTabletInsertionEvent.getInsertNodeViaCacheIfPossible();
            if (Objects.isNull(insertNode)) {
                buffer = pipeInsertNodeTabletInsertionEvent.getByteBuffer();
                this.binaryBuffers.add(buffer);
            } else {
                buffer = insertNode.serializeToByteBuffer();
                this.insertNodeBuffers.add(buffer);
            }
        } else {
            PipeRawTabletInsertionEvent pipeRawTabletInsertionEvent = (PipeRawTabletInsertionEvent)event;
            try (PublicBAOS byteArrayOutputStream = new PublicBAOS();
                 DataOutputStream outputStream = new DataOutputStream((OutputStream)byteArrayOutputStream);){
                pipeRawTabletInsertionEvent.convertToTablet().serialize(outputStream);
                ReadWriteIOUtils.write((Boolean)pipeRawTabletInsertionEvent.isAligned(), (OutputStream)outputStream);
                buffer = ByteBuffer.wrap(byteArrayOutputStream.getBuf(), 0, byteArrayOutputStream.size());
            }
            this.tabletBuffers.add(buffer);
        }
        return buffer.limit();
    }

    @Override
    public void close() {
        this.allocatedMemoryBlock.close();
    }
}

