/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.extractor.realtime;

import org.apache.iotdb.commons.exception.pipe.PipeRuntimeException;
import org.apache.iotdb.commons.exception.pipe.PipeRuntimeNonCriticalException;
import org.apache.iotdb.commons.pipe.task.connection.UnboundedBlockingPendingQueue;
import org.apache.iotdb.db.pipe.agent.PipeAgent;
import org.apache.iotdb.db.pipe.event.EnrichedEvent;
import org.apache.iotdb.db.pipe.event.common.heartbeat.PipeHeartbeatEvent;
import org.apache.iotdb.db.pipe.event.common.tsfile.PipeTsFileInsertionEvent;
import org.apache.iotdb.db.pipe.event.realtime.PipeRealtimeEvent;
import org.apache.iotdb.db.pipe.extractor.realtime.PipeRealtimeDataRegionExtractor;
import org.apache.iotdb.db.pipe.extractor.realtime.epoch.TsFileEpoch;
import org.apache.iotdb.pipe.api.event.Event;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.apache.iotdb.pipe.api.event.dml.insertion.TsFileInsertionEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeRealtimeDataRegionLogExtractor
extends PipeRealtimeDataRegionExtractor {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeRealtimeDataRegionLogExtractor.class);

    @Override
    protected void doExtract(PipeRealtimeEvent event) {
        EnrichedEvent eventToExtract = event.getEvent();
        if (eventToExtract instanceof TabletInsertionEvent) {
            this.extractTabletInsertion(event);
        } else if (eventToExtract instanceof TsFileInsertionEvent) {
            this.extractTsFileInsertion(event);
        } else if (eventToExtract instanceof PipeHeartbeatEvent) {
            this.extractHeartbeat(event);
        } else {
            throw new UnsupportedOperationException(String.format("Unsupported event type %s for log realtime extractor %s", eventToExtract.getClass(), this));
        }
    }

    private void extractTabletInsertion(PipeRealtimeEvent event) {
        event.getTsFileEpoch().migrateState(this, state -> TsFileEpoch.State.USING_TABLET);
        if (!this.pendingQueue.waitedOffer((Event)event)) {
            String errorMessage = String.format("extract: pending queue of PipeRealtimeDataRegionLogExtractor %s has reached capacity, discard tablet event %s, current state %s", new Object[]{this, event, event.getTsFileEpoch().getState(this)});
            LOGGER.error(errorMessage);
            PipeAgent.runtime().report(this.pipeTaskMeta, (PipeRuntimeException)new PipeRuntimeNonCriticalException(errorMessage));
            event.decreaseReferenceCount(PipeRealtimeDataRegionLogExtractor.class.getName(), false);
        }
    }

    private void extractTsFileInsertion(PipeRealtimeEvent event) {
        PipeTsFileInsertionEvent tsFileInsertionEvent = (PipeTsFileInsertionEvent)event.getEvent();
        if (!tsFileInsertionEvent.getIsLoaded() && tsFileInsertionEvent.getFileStartTime() >= event.getTsFileEpoch().getInsertNodeMinTime()) {
            event.decreaseReferenceCount(PipeRealtimeDataRegionLogExtractor.class.getName(), false);
            return;
        }
        event.getTsFileEpoch().migrateState(this, state -> TsFileEpoch.State.USING_TSFILE);
        if (!this.pendingQueue.waitedOffer((Event)event)) {
            String errorMessage = String.format("extract: pending queue of PipeRealtimeDataRegionLogExtractor %s has reached capacity, discard loaded tsFile event %s, current state %s", new Object[]{this, event, event.getTsFileEpoch().getState(this)});
            LOGGER.error(errorMessage);
            PipeAgent.runtime().report(this.pipeTaskMeta, (PipeRuntimeException)new PipeRuntimeNonCriticalException(errorMessage));
            event.decreaseReferenceCount(PipeRealtimeDataRegionLogExtractor.class.getName(), false);
        }
    }

    private void extractHeartbeat(PipeRealtimeEvent event) {
        ((PipeHeartbeatEvent)event.getEvent()).recordExtractorQueueSize((UnboundedBlockingPendingQueue<Event>)this.pendingQueue);
        Event lastEvent = this.pendingQueue.peekLast();
        if (lastEvent instanceof PipeRealtimeEvent && ((PipeRealtimeEvent)lastEvent).getEvent() instanceof PipeHeartbeatEvent && (((PipeHeartbeatEvent)((PipeRealtimeEvent)lastEvent).getEvent()).isShouldPrintMessage() || !((PipeHeartbeatEvent)event.getEvent()).isShouldPrintMessage())) {
            event.decreaseReferenceCount(PipeRealtimeDataRegionLogExtractor.class.getName(), false);
            return;
        }
        if (!this.pendingQueue.waitedOffer((Event)event)) {
            LOGGER.error("extract: pending queue of PipeRealtimeDataRegionLogExtractor {} has reached capacity, discard heartbeat event {}", (Object)this, (Object)event);
            event.decreaseReferenceCount(PipeRealtimeDataRegionLogExtractor.class.getName(), false);
        }
    }

    @Override
    public boolean isNeedListenToTsFile() {
        return true;
    }

    @Override
    public boolean isNeedListenToInsertNode() {
        return true;
    }

    public Event supply() {
        PipeRealtimeEvent realtimeEvent = (PipeRealtimeEvent)this.pendingQueue.directPoll();
        while (realtimeEvent != null) {
            EnrichedEvent suppliedEvent = null;
            if (realtimeEvent.increaseReferenceCount(PipeRealtimeDataRegionLogExtractor.class.getName())) {
                suppliedEvent = realtimeEvent.getEvent();
            } else {
                String errorMessage = String.format("Tablet Event %s can not be supplied because the reference count can not be increased, the data represented by this event is lost", realtimeEvent.getEvent());
                LOGGER.error(errorMessage);
                PipeAgent.runtime().report(this.pipeTaskMeta, (PipeRuntimeException)new PipeRuntimeNonCriticalException(errorMessage));
            }
            realtimeEvent.decreaseReferenceCount(PipeRealtimeDataRegionLogExtractor.class.getName(), false);
            if (suppliedEvent != null) {
                return suppliedEvent;
            }
            realtimeEvent = (PipeRealtimeEvent)this.pendingQueue.directPoll();
        }
        return null;
    }
}

