/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.progress.committer;

import java.util.Comparator;
import java.util.Objects;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.db.pipe.event.EnrichedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeEventCommitter {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeEventCommitter.class);
    private final String pipeName;
    private final int dataRegionId;
    private final AtomicLong commitIdGenerator = new AtomicLong(0L);
    private final AtomicLong lastCommitId = new AtomicLong(0L);
    private final PriorityBlockingQueue<EnrichedEvent> commitQueue = new PriorityBlockingQueue<EnrichedEvent>(11, Comparator.comparing(event -> Objects.requireNonNull(event, "committable event cannot be null").getCommitId()));

    PipeEventCommitter(String pipeName, int dataRegionId) {
        this.pipeName = pipeName;
        this.dataRegionId = dataRegionId;
    }

    public synchronized long generateCommitId() {
        return this.commitIdGenerator.incrementAndGet();
    }

    public synchronized void commit(EnrichedEvent event) {
        this.commitQueue.offer(event);
        while (!this.commitQueue.isEmpty()) {
            EnrichedEvent e = this.commitQueue.peek();
            if (e.getCommitId() <= this.lastCommitId.get()) {
                LOGGER.warn("commit id must be monotonically increasing, lastCommitId: {}, event: {}", (Object)this.lastCommitId.get(), (Object)e);
                this.commitQueue.poll();
                continue;
            }
            if (e.getCommitId() != this.lastCommitId.get() + 1L) break;
            e.onCommitted();
            this.lastCommitId.incrementAndGet();
            this.commitQueue.poll();
        }
    }

    public String getPipeName() {
        return this.pipeName;
    }

    public int getDataRegionId() {
        return this.dataRegionId;
    }

    public long commitQueueSize() {
        return this.commitQueue.size();
    }
}

