/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.receiver;

import java.util.ArrayList;
import java.util.Map;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.schema.view.viewExpression.ViewExpression;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.write.ActivateTemplateNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.write.AlterTimeSeriesNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.write.BatchActivateTemplateNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.write.CreateMultiTimeSeriesNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.write.CreateTimeSeriesNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.write.InternalBatchActivateTemplateNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.write.InternalCreateMultiTimeSeriesNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.write.InternalCreateTimeSeriesNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.write.MeasurementGroup;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.write.view.CreateLogicalViewNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.DeleteDataNode;
import org.apache.iotdb.db.queryengine.plan.statement.Statement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.DeleteDataStatement;
import org.apache.iotdb.db.queryengine.plan.statement.internal.InternalCreateMultiTimeSeriesStatement;
import org.apache.iotdb.db.queryengine.plan.statement.internal.InternalCreateTimeSeriesStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.AlterTimeSeriesStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.CreateMultiTimeSeriesStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.CreateTimeSeriesStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.template.ActivateTemplateStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.template.BatchActivateTemplateStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.view.CreateLogicalViewStatement;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;

public class PipePlanToStatementVisitor
extends PlanVisitor<Statement, Void> {
    @Override
    public Statement visitPlan(PlanNode node, Void context) {
        throw new UnsupportedOperationException("PipePlanToStatementVisitor does not support visiting general plan.");
    }

    @Override
    public CreateTimeSeriesStatement visitCreateTimeSeries(CreateTimeSeriesNode node, Void context) {
        CreateTimeSeriesStatement statement = new CreateTimeSeriesStatement();
        statement.setPath(node.getPath());
        statement.setDataType(node.getDataType());
        statement.setEncoding(node.getEncoding());
        statement.setCompressor(node.getCompressor());
        statement.setProps(node.getProps());
        statement.setAttributes(node.getAttributes());
        statement.setAlias(node.getAlias());
        statement.setTags(node.getTags());
        return statement;
    }

    @Override
    public CreateMultiTimeSeriesStatement visitCreateMultiTimeSeries(CreateMultiTimeSeriesNode node, Void context) {
        CreateMultiTimeSeriesStatement statement = new CreateMultiTimeSeriesStatement();
        ArrayList<PartialPath> paths = new ArrayList<PartialPath>();
        ArrayList<TSDataType> dataTypes = new ArrayList<TSDataType>();
        ArrayList<TSEncoding> encodings = new ArrayList<TSEncoding>();
        ArrayList<CompressionType> compressors = new ArrayList<CompressionType>();
        ArrayList<Map<String, String>> propsList = new ArrayList<Map<String, String>>();
        ArrayList<String> aliasList = new ArrayList<String>();
        ArrayList<Map<String, String>> tagsList = new ArrayList<Map<String, String>>();
        ArrayList<Map<String, String>> attributesList = new ArrayList<Map<String, String>>();
        for (Map.Entry<PartialPath, MeasurementGroup> path2Group : node.getMeasurementGroupMap().entrySet()) {
            MeasurementGroup group = path2Group.getValue();
            dataTypes.addAll(group.getDataTypes());
            encodings.addAll(group.getEncodings());
            compressors.addAll(group.getCompressors());
            propsList.addAll(group.getPropsList());
            aliasList.addAll(group.getAliasList());
            tagsList.addAll(group.getTagsList());
            attributesList.addAll(group.getAttributesList());
            for (int i = 0; i < group.getAttributesList().size(); ++i) {
                paths.add(path2Group.getKey());
            }
        }
        statement.setPaths(paths);
        statement.setDataTypes(dataTypes);
        statement.setEncodings(encodings);
        statement.setCompressors(compressors);
        statement.setPropsList(propsList);
        statement.setAliasList(aliasList);
        statement.setTagsList(tagsList);
        statement.setAttributesList(attributesList);
        return statement;
    }

    @Override
    public AlterTimeSeriesStatement visitAlterTimeSeries(AlterTimeSeriesNode node, Void context) {
        AlterTimeSeriesStatement statement = new AlterTimeSeriesStatement();
        statement.setAlterMap(node.getAlterMap());
        statement.setAlterType(node.getAlterType());
        statement.setAttributesMap(node.getAttributesMap());
        statement.setAlias(node.getAlias());
        statement.setTagsMap(node.getTagsMap());
        statement.setPath(node.getPath());
        return statement;
    }

    @Override
    public InternalCreateTimeSeriesStatement visitInternalCreateTimeSeries(InternalCreateTimeSeriesNode node, Void context) {
        return new InternalCreateTimeSeriesStatement(node.getDevicePath(), node.getMeasurementGroup().getMeasurements(), node.getMeasurementGroup().getDataTypes(), node.getMeasurementGroup().getEncodings(), node.getMeasurementGroup().getCompressors(), node.isAligned());
    }

    @Override
    public ActivateTemplateStatement visitActivateTemplate(ActivateTemplateNode node, Void context) {
        ActivateTemplateStatement statement = new ActivateTemplateStatement();
        statement.setPath(node.getActivatePath());
        return statement;
    }

    @Override
    public BatchActivateTemplateStatement visitInternalBatchActivateTemplate(InternalBatchActivateTemplateNode node, Void context) {
        return new BatchActivateTemplateStatement(new ArrayList<PartialPath>(node.getTemplateActivationMap().keySet()));
    }

    @Override
    public InternalCreateMultiTimeSeriesStatement visitInternalCreateMultiTimeSeries(InternalCreateMultiTimeSeriesNode node, Void context) {
        return new InternalCreateMultiTimeSeriesStatement(node.getDeviceMap());
    }

    @Override
    public BatchActivateTemplateStatement visitBatchActivateTemplate(BatchActivateTemplateNode node, Void context) {
        return new BatchActivateTemplateStatement(new ArrayList<PartialPath>(node.getTemplateActivationMap().keySet()));
    }

    @Override
    public CreateLogicalViewStatement visitCreateLogicalView(CreateLogicalViewNode node, Void context) {
        CreateLogicalViewStatement statement = new CreateLogicalViewStatement();
        statement.setTargetFullPaths(node.getViewPathList());
        statement.setViewExpressions(new ArrayList<ViewExpression>(node.getViewPathToSourceExpressionMap().values()));
        return statement;
    }

    @Override
    public DeleteDataStatement visitDeleteData(DeleteDataNode node, Void context) {
        DeleteDataStatement statement = new DeleteDataStatement();
        statement.setDeleteEndTime(node.getDeleteEndTime());
        statement.setDeleteStartTime(node.getDeleteStartTime());
        statement.setPathList(node.getPathList());
        return statement;
    }
}

