/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.aggregation;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.comparators.ComparatorChain;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.queryengine.execution.aggregation.Accumulator;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnBuilder;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.BitMap;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class BinaryModeAccumulator
implements Accumulator {
    private final Map<Binary, Pair<Long, Long>> countMap = new HashMap<Binary, Pair<Long, Long>>();
    private final int MAP_SIZE_THRESHOLD = IoTDBDescriptor.getInstance().getConfig().getModeMapSizeThreshold();

    @Override
    public void addInput(Column[] column, BitMap bitMap, int lastIndex) {
        for (int i = 0; i <= lastIndex; ++i) {
            if (bitMap != null && !bitMap.isMarked(i) || column[1].isNull(i)) continue;
            long time = column[0].getLong(i);
            this.countMap.compute(column[1].getBinary(i), (k, v) -> v == null ? new Pair((Object)1L, (Object)time) : new Pair((Object)((Long)v.left + 1L), (Object)Math.min((Long)v.right, time)));
            if (this.countMap.size() <= this.MAP_SIZE_THRESHOLD) continue;
            throw new RuntimeException(String.format("distinct values has exceeded the threshold %s when calculate Mode", this.MAP_SIZE_THRESHOLD));
        }
    }

    @Override
    public void addIntermediate(Column[] partialResult) {
        Preconditions.checkArgument((partialResult.length == 1 ? 1 : 0) != 0, (Object)"partialResult of Mode should be 1");
        Preconditions.checkArgument((!partialResult[0].isNull(0) ? 1 : 0) != 0, (Object)"partialResult of Mode should not be null");
        this.deserializeAndMergeCountMap(partialResult[0].getBinary(0));
    }

    @Override
    public void addStatistics(Statistics statistics) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public void setFinal(Column finalResult) {
        if (finalResult.isNull(0)) {
            return;
        }
        this.countMap.put(finalResult.getBinary(0), (Pair<Long, Long>)new Pair((Object)0L, (Object)Long.MIN_VALUE));
    }

    @Override
    public void outputIntermediate(ColumnBuilder[] tsBlockBuilder) {
        tsBlockBuilder[0].writeBinary(this.serializeCountMap());
    }

    @Override
    public void outputFinal(ColumnBuilder tsBlockBuilder) {
        if (this.countMap.isEmpty()) {
            tsBlockBuilder.appendNull();
        } else {
            tsBlockBuilder.writeBinary((Binary)Collections.max(this.countMap.entrySet(), Map.Entry.comparingByValue(new ComparatorChain((List)ImmutableList.of((v1, v2) -> ((Long)v1.left).compareTo((Long)v2.left), (v1, v2) -> ((Long)v2.right).compareTo((Long)v1.right))))).getKey());
        }
    }

    @Override
    public void reset() {
        this.countMap.clear();
    }

    @Override
    public boolean hasFinalResult() {
        return false;
    }

    @Override
    public TSDataType[] getIntermediateType() {
        return new TSDataType[]{TSDataType.TEXT};
    }

    @Override
    public TSDataType getFinalType() {
        return TSDataType.TEXT;
    }

    private Binary serializeCountMap() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            ReadWriteIOUtils.write((int)this.countMap.size(), (OutputStream)stream);
            for (Map.Entry<Binary, Pair<Long, Long>> entry : this.countMap.entrySet()) {
                ReadWriteIOUtils.write((Binary)entry.getKey(), (OutputStream)stream);
                ReadWriteIOUtils.write((long)((Long)entry.getValue().left), (OutputStream)stream);
                ReadWriteIOUtils.write((long)((Long)entry.getValue().right), (OutputStream)stream);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new Binary(stream.toByteArray());
    }

    private void deserializeAndMergeCountMap(Binary partialResult) {
        ByteArrayInputStream stream = new ByteArrayInputStream(partialResult.getValues());
        try {
            int size = ReadWriteIOUtils.readInt((InputStream)stream);
            for (int i = 0; i < size; ++i) {
                this.countMap.compute(ReadWriteIOUtils.readBinary((InputStream)stream), (k, v) -> {
                    try {
                        return v == null ? new Pair((Object)ReadWriteIOUtils.readLong((InputStream)stream), (Object)ReadWriteIOUtils.readLong((InputStream)stream)) : new Pair((Object)((Long)v.left + ReadWriteIOUtils.readLong((InputStream)stream)), (Object)Math.min((Long)v.right, ReadWriteIOUtils.readLong((InputStream)stream)));
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                });
                if (this.countMap.size() <= this.MAP_SIZE_THRESHOLD) continue;
                throw new RuntimeException(String.format("distinct values has exceeded the threshold %s when calculate Mode", this.MAP_SIZE_THRESHOLD));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

