/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process.last;

import com.google.common.base.Preconditions;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.db.queryengine.execution.operator.Operator;
import org.apache.iotdb.db.queryengine.execution.operator.OperatorContext;
import org.apache.iotdb.db.queryengine.execution.operator.process.last.AbstractUpdateLastCacheOperator;
import org.apache.iotdb.db.queryengine.execution.operator.process.last.LastQueryUtil;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.DataNodeSchemaCache;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.utils.TsPrimitiveType;

public class UpdateLastCacheOperator
extends AbstractUpdateLastCacheOperator {
    private final MeasurementPath fullPath;
    protected final String dataType;

    public UpdateLastCacheOperator(OperatorContext operatorContext, Operator child, MeasurementPath fullPath, TSDataType dataType, DataNodeSchemaCache dataNodeSchemaCache, boolean needUpdateCache, boolean isNeedUpdateNullEntry) {
        super(operatorContext, child, dataNodeSchemaCache, needUpdateCache, isNeedUpdateNullEntry);
        this.fullPath = fullPath;
        this.dataType = dataType.name();
    }

    @Override
    public TsBlock next() throws Exception {
        TsBlock res = this.child.nextWithTimer();
        if (res == null) {
            return null;
        }
        if (res.isEmpty()) {
            return LAST_QUERY_EMPTY_TSBLOCK;
        }
        Preconditions.checkArgument((res.getPositionCount() == 1 ? 1 : 0) != 0, (Object)"last query result should only have one record");
        if (res.getColumn(0).isNull(0)) {
            if (this.needUpdateNullEntry) {
                this.mayUpdateLastCache(Long.MIN_VALUE, null, this.fullPath);
            }
            return LAST_QUERY_EMPTY_TSBLOCK;
        }
        long lastTime = res.getColumn(0).getLong(0);
        TsPrimitiveType lastValue = res.getColumn(1).getTsPrimitiveType(0);
        this.mayUpdateLastCache(lastTime, lastValue, this.fullPath);
        this.tsBlockBuilder.reset();
        this.appendLastValueToTsBlockBuilder(lastTime, lastValue);
        return this.tsBlockBuilder.build();
    }

    protected void appendLastValueToTsBlockBuilder(long lastTime, TsPrimitiveType lastValue) {
        LastQueryUtil.appendLastValue(this.tsBlockBuilder, lastTime, this.fullPath.getFullPath(), lastValue.getStringValue(), this.dataType);
    }
}

