/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.source;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.commons.path.AlignedPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.queryengine.execution.operator.OperatorContext;
import org.apache.iotdb.db.queryengine.execution.operator.source.AbstractDataSourceOperator;
import org.apache.iotdb.db.queryengine.execution.operator.source.AlignedSeriesScanUtil;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.SeriesScanOptions;
import org.apache.iotdb.db.queryengine.plan.statement.component.Ordering;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnBuilder;
import org.apache.iotdb.tsfile.read.common.block.column.TimeColumn;
import org.apache.iotdb.tsfile.read.common.block.column.TimeColumnBuilder;

public class AlignedSeriesScanOperator
extends AbstractDataSourceOperator {
    private final int valueColumnCount;
    private boolean finished = false;

    public AlignedSeriesScanOperator(OperatorContext context, PlanNodeId sourceId, AlignedPath seriesPath, Ordering scanOrder, SeriesScanOptions seriesScanOptions, boolean queryAllSensors, List<TSDataType> dataTypes) {
        this.sourceId = sourceId;
        this.operatorContext = context;
        this.seriesScanUtil = new AlignedSeriesScanUtil((PartialPath)seriesPath, scanOrder, seriesScanOptions, context.getInstanceContext(), queryAllSensors, dataTypes);
        this.valueColumnCount = seriesPath.getColumnNum();
        this.maxReturnSize = Math.min(this.maxReturnSize, (1L + (long)this.valueColumnCount) * (long)TSFileDescriptor.getInstance().getConfig().getPageSizeInByte());
    }

    @Override
    public TsBlock next() throws Exception {
        if (this.retainedTsBlock != null) {
            return this.getResultFromRetainedTsBlock();
        }
        this.resultTsBlock = this.resultTsBlockBuilder.build();
        this.resultTsBlockBuilder.reset();
        return this.checkTsBlockSizeAndGetResult();
    }

    @Override
    public boolean hasNext() throws Exception {
        if (this.retainedTsBlock != null) {
            return true;
        }
        try {
            long maxRuntime = this.operatorContext.getMaxRunTime().roundTo(TimeUnit.NANOSECONDS);
            long start = System.nanoTime();
            while ((this.readPageData() || this.readChunkData() || this.readFileData()) && System.nanoTime() - start < maxRuntime && !this.resultTsBlockBuilder.isFull() && this.retainedTsBlock == null) {
            }
            this.finished = this.resultTsBlockBuilder.isEmpty() && this.retainedTsBlock == null;
            return !this.finished;
        }
        catch (IOException e) {
            throw new RuntimeException("Error happened while scanning the file", e);
        }
    }

    @Override
    public boolean isFinished() throws Exception {
        return this.finished;
    }

    @Override
    public long calculateMaxPeekMemory() {
        return Math.max(this.maxReturnSize, (1L + (long)this.valueColumnCount) * (long)TSFileDescriptor.getInstance().getConfig().getPageSizeInByte() * 3L);
    }

    @Override
    public long calculateMaxReturnSize() {
        return this.maxReturnSize;
    }

    @Override
    public long calculateRetainedSizeAfterCallingNext() {
        return this.calculateMaxPeekMemory() - this.calculateMaxReturnSize();
    }

    private boolean readFileData() throws IOException {
        while (this.seriesScanUtil.hasNextFile()) {
            if (!this.readChunkData()) continue;
            return true;
        }
        return false;
    }

    private boolean readChunkData() throws IOException {
        while (this.seriesScanUtil.hasNextChunk()) {
            if (!this.readPageData()) continue;
            return true;
        }
        return false;
    }

    private boolean readPageData() throws IOException {
        while (this.seriesScanUtil.hasNextPage()) {
            TsBlock tsBlock = this.seriesScanUtil.nextPage();
            if (this.isEmpty(tsBlock)) continue;
            this.appendToBuilder(tsBlock);
            return true;
        }
        return false;
    }

    private void appendToBuilder(TsBlock tsBlock) {
        int size = tsBlock.getPositionCount();
        if (this.resultTsBlockBuilder.isEmpty() && tsBlock.getPositionCount() >= TsBlockBuilder.MAX_LINE_NUMBER) {
            this.retainedTsBlock = tsBlock;
            return;
        }
        TimeColumnBuilder timeColumnBuilder = this.resultTsBlockBuilder.getTimeColumnBuilder();
        TimeColumn timeColumn = tsBlock.getTimeColumn();
        for (int i = 0; i < size; ++i) {
            timeColumnBuilder.writeLong(timeColumn.getLong(i));
            this.resultTsBlockBuilder.declarePosition();
        }
        int columnSize = tsBlock.getValueColumnCount();
        for (int columnIndex = 0; columnIndex < columnSize; ++columnIndex) {
            this.appendOneColumn(columnIndex, tsBlock, size);
        }
    }

    private void appendOneColumn(int columnIndex, TsBlock tsBlock, int size) {
        ColumnBuilder columnBuilder = this.resultTsBlockBuilder.getColumnBuilder(columnIndex);
        Column column = tsBlock.getColumn(columnIndex);
        if (column.mayHaveNull()) {
            for (int i = 0; i < size; ++i) {
                if (column.isNull(i)) {
                    columnBuilder.appendNull();
                    continue;
                }
                columnBuilder.write(column, i);
            }
        } else {
            for (int i = 0; i < size; ++i) {
                columnBuilder.write(column, i);
            }
        }
    }

    private boolean isEmpty(TsBlock tsBlock) {
        return tsBlock == null || tsBlock.isEmpty();
    }

    @Override
    protected List<TSDataType> getResultDataTypes() {
        return this.seriesScanUtil.getTsDataTypeList();
    }
}

