/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.window;

import java.util.List;
import org.apache.iotdb.db.queryengine.execution.aggregation.Aggregator;
import org.apache.iotdb.db.queryengine.execution.operator.window.AbstractVariationWindow;
import org.apache.iotdb.db.queryengine.execution.operator.window.IWindow;
import org.apache.iotdb.db.queryengine.execution.operator.window.IWindowManager;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;

public abstract class VariationWindowManager
implements IWindowManager {
    protected boolean initialized = false;
    protected boolean ascending;
    protected boolean needSkip;
    protected AbstractVariationWindow variationWindow;

    protected VariationWindowManager(boolean ascending) {
        this.ascending = ascending;
        this.needSkip = false;
    }

    @Override
    public boolean isIgnoringNull() {
        return this.variationWindow.ignoreNull();
    }

    @Override
    public boolean isCurWindowInit() {
        return this.initialized;
    }

    @Override
    public void initCurWindow() {
        this.initialized = true;
        this.variationWindow.setInitializedHeadValue(false);
    }

    @Override
    public boolean hasNext(boolean hasMoreData) {
        return hasMoreData;
    }

    @Override
    public void next() {
        this.needSkip = true;
        this.initialized = false;
        this.variationWindow.updatePreviousValue();
    }

    @Override
    public IWindow getCurWindow() {
        return this.variationWindow;
    }

    @Override
    public TsBlockBuilder createResultTsBlockBuilder(List<Aggregator> aggregators) {
        List<TSDataType> dataTypes = this.getResultDataTypes(aggregators);
        if (this.variationWindow.isOutputEndTime()) {
            dataTypes.add(0, TSDataType.INT64);
        }
        return new TsBlockBuilder(dataTypes);
    }

    @Override
    public void appendAggregationResult(TsBlockBuilder resultTsBlockBuilder, List<Aggregator> aggregators) {
        long endTime = this.variationWindow.isOutputEndTime() ? this.variationWindow.getEndTime() : -1L;
        this.outputAggregators(aggregators, resultTsBlockBuilder, this.variationWindow.getStartTime(), endTime);
    }

    @Override
    public boolean needSkipInAdvance() {
        return this.variationWindow.isOutputEndTime();
    }
}

