/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.analyze;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.queryengine.plan.expression.Expression;
import org.apache.iotdb.db.queryengine.plan.expression.ExpressionType;
import org.apache.iotdb.db.queryengine.plan.expression.UnknownExpressionTypeException;
import org.apache.iotdb.db.queryengine.plan.expression.binary.AdditionExpression;
import org.apache.iotdb.db.queryengine.plan.expression.binary.BinaryExpression;
import org.apache.iotdb.db.queryengine.plan.expression.binary.DivisionExpression;
import org.apache.iotdb.db.queryengine.plan.expression.binary.EqualToExpression;
import org.apache.iotdb.db.queryengine.plan.expression.binary.GreaterEqualExpression;
import org.apache.iotdb.db.queryengine.plan.expression.binary.GreaterThanExpression;
import org.apache.iotdb.db.queryengine.plan.expression.binary.LessEqualExpression;
import org.apache.iotdb.db.queryengine.plan.expression.binary.LessThanExpression;
import org.apache.iotdb.db.queryengine.plan.expression.binary.LogicAndExpression;
import org.apache.iotdb.db.queryengine.plan.expression.binary.LogicOrExpression;
import org.apache.iotdb.db.queryengine.plan.expression.binary.ModuloExpression;
import org.apache.iotdb.db.queryengine.plan.expression.binary.MultiplicationExpression;
import org.apache.iotdb.db.queryengine.plan.expression.binary.NonEqualExpression;
import org.apache.iotdb.db.queryengine.plan.expression.binary.SubtractionExpression;
import org.apache.iotdb.db.queryengine.plan.expression.binary.WhenThenExpression;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.TimeSeriesOperand;
import org.apache.iotdb.db.queryengine.plan.expression.multi.FunctionExpression;
import org.apache.iotdb.db.queryengine.plan.expression.other.CaseWhenThenExpression;
import org.apache.iotdb.db.queryengine.plan.expression.ternary.BetweenExpression;
import org.apache.iotdb.db.queryengine.plan.expression.ternary.TernaryExpression;
import org.apache.iotdb.db.queryengine.plan.expression.unary.InExpression;
import org.apache.iotdb.db.queryengine.plan.expression.unary.IsNullExpression;
import org.apache.iotdb.db.queryengine.plan.expression.unary.LikeExpression;
import org.apache.iotdb.db.queryengine.plan.expression.unary.LogicNotExpression;
import org.apache.iotdb.db.queryengine.plan.expression.unary.NegationExpression;
import org.apache.iotdb.db.queryengine.plan.expression.unary.RegularExpression;
import org.apache.iotdb.db.queryengine.plan.expression.unary.UnaryExpression;

public class ExpressionUtils {
    private ExpressionUtils() {
    }

    public static List<Expression> reconstructTimeSeriesOperands(TimeSeriesOperand rawExpression, List<? extends PartialPath> actualPaths) {
        ArrayList<Expression> resultExpressions = new ArrayList<Expression>();
        for (PartialPath partialPath : actualPaths) {
            resultExpressions.add(ExpressionUtils.reconstructTimeSeriesOperand(rawExpression, partialPath));
        }
        return resultExpressions;
    }

    public static Expression reconstructTimeSeriesOperand(TimeSeriesOperand rawExpression, PartialPath actualPath) {
        TimeSeriesOperand resultExpression = new TimeSeriesOperand(actualPath);
        return ExpressionUtils.cloneCommonFields(rawExpression, resultExpression);
    }

    public static List<Expression> reconstructFunctionExpressions(FunctionExpression expression, List<List<Expression>> childExpressionsList) {
        ArrayList<Expression> resultExpressions = new ArrayList<Expression>();
        for (List<Expression> functionExpressions : childExpressionsList) {
            resultExpressions.add(ExpressionUtils.reconstructFunctionExpression(expression, functionExpressions));
        }
        return resultExpressions;
    }

    public static Expression reconstructFunctionExpression(FunctionExpression rawExpression, List<Expression> childExpressions) {
        FunctionExpression resultExpression = new FunctionExpression(rawExpression.getFunctionName(), rawExpression.getFunctionAttributes(), childExpressions, rawExpression.getCountTimeExpressions());
        return ExpressionUtils.cloneCommonFields(rawExpression, resultExpression);
    }

    public static List<Expression> reconstructUnaryExpressions(UnaryExpression expression, List<Expression> childExpressions) {
        ArrayList<Expression> resultExpressions = new ArrayList<Expression>();
        for (Expression childExpression : childExpressions) {
            resultExpressions.add(ExpressionUtils.reconstructUnaryExpression(expression, childExpression));
        }
        return resultExpressions;
    }

    public static Expression reconstructCaseWhenThenExpression(CaseWhenThenExpression rawExpression, List<Expression> childExpressions) {
        CaseWhenThenExpression resultExpression = new CaseWhenThenExpression(childExpressions.subList(0, childExpressions.size() - 1).stream().map(WhenThenExpression.class::cast).collect(Collectors.toList()), childExpressions.get(childExpressions.size() - 1));
        return ExpressionUtils.cloneCommonFields(rawExpression, resultExpression);
    }

    public static Expression reconstructUnaryExpression(UnaryExpression rawExpression, Expression childExpression) {
        UnaryExpression resultExpression;
        switch (rawExpression.getExpressionType()) {
            case IS_NULL: {
                resultExpression = new IsNullExpression(childExpression, ((IsNullExpression)rawExpression).isNot());
                break;
            }
            case IN: {
                resultExpression = new InExpression(childExpression, ((InExpression)rawExpression).isNotIn(), ((InExpression)rawExpression).getValues());
                break;
            }
            case LIKE: {
                resultExpression = new LikeExpression(childExpression, ((LikeExpression)rawExpression).getPatternString(), ((LikeExpression)rawExpression).getPattern(), ((LikeExpression)rawExpression).isNot());
                break;
            }
            case LOGIC_NOT: {
                resultExpression = new LogicNotExpression(childExpression);
                break;
            }
            case NEGATION: {
                resultExpression = new NegationExpression(childExpression);
                break;
            }
            case REGEXP: {
                resultExpression = new RegularExpression(childExpression, ((RegularExpression)rawExpression).getPatternString(), ((RegularExpression)rawExpression).getPattern(), ((RegularExpression)rawExpression).isNot());
                break;
            }
            default: {
                throw new UnknownExpressionTypeException(rawExpression.getExpressionType());
            }
        }
        return ExpressionUtils.cloneCommonFields(rawExpression, resultExpression);
    }

    public static List<Expression> reconstructBinaryExpressions(BinaryExpression expression, List<Expression> leftExpressions, List<Expression> rightExpressions) {
        ArrayList<Expression> resultExpressions = new ArrayList<Expression>();
        for (Expression le : leftExpressions) {
            for (Expression re : rightExpressions) {
                resultExpressions.add(ExpressionUtils.reconstructBinaryExpression(expression, le, re));
            }
        }
        return resultExpressions;
    }

    public static Expression reconstructBinaryExpression(Expression rawExpression, Expression leftExpression, Expression rightExpression) {
        BinaryExpression resultExpression;
        switch (rawExpression.getExpressionType()) {
            case ADDITION: {
                resultExpression = new AdditionExpression(leftExpression, rightExpression);
                break;
            }
            case SUBTRACTION: {
                resultExpression = new SubtractionExpression(leftExpression, rightExpression);
                break;
            }
            case MULTIPLICATION: {
                resultExpression = new MultiplicationExpression(leftExpression, rightExpression);
                break;
            }
            case DIVISION: {
                resultExpression = new DivisionExpression(leftExpression, rightExpression);
                break;
            }
            case MODULO: {
                resultExpression = new ModuloExpression(leftExpression, rightExpression);
                break;
            }
            case LESS_THAN: {
                resultExpression = new LessThanExpression(leftExpression, rightExpression);
                break;
            }
            case LESS_EQUAL: {
                resultExpression = new LessEqualExpression(leftExpression, rightExpression);
                break;
            }
            case GREATER_THAN: {
                resultExpression = new GreaterThanExpression(leftExpression, rightExpression);
                break;
            }
            case GREATER_EQUAL: {
                resultExpression = new GreaterEqualExpression(leftExpression, rightExpression);
                break;
            }
            case EQUAL_TO: {
                resultExpression = new EqualToExpression(leftExpression, rightExpression);
                break;
            }
            case NON_EQUAL: {
                resultExpression = new NonEqualExpression(leftExpression, rightExpression);
                break;
            }
            case LOGIC_AND: {
                resultExpression = new LogicAndExpression(leftExpression, rightExpression);
                break;
            }
            case LOGIC_OR: {
                resultExpression = new LogicOrExpression(leftExpression, rightExpression);
                break;
            }
            case WHEN_THEN: {
                resultExpression = new WhenThenExpression(leftExpression, rightExpression);
                break;
            }
            default: {
                throw new IllegalArgumentException("unsupported rawExpression type: " + (Object)((Object)rawExpression.getExpressionType()));
            }
        }
        return ExpressionUtils.cloneCommonFields(rawExpression, resultExpression);
    }

    public static List<Expression> reconstructTernaryExpressions(TernaryExpression expression, List<Expression> firstExpressions, List<Expression> secondExpressions, List<Expression> thirdExpressions) {
        ArrayList<Expression> resultExpressions = new ArrayList<Expression>();
        for (Expression fe : firstExpressions) {
            for (Expression se : secondExpressions) {
                for (Expression te : thirdExpressions) {
                    resultExpressions.add(ExpressionUtils.reconstructTernaryExpression(expression, fe, se, te));
                }
            }
        }
        return resultExpressions;
    }

    public static Expression reconstructTernaryExpression(TernaryExpression rawExpression, Expression firstExpression, Expression secondExpression, Expression thirdExpression) {
        if (rawExpression.getExpressionType() != ExpressionType.BETWEEN) {
            throw new UnknownExpressionTypeException(rawExpression.getExpressionType());
        }
        BetweenExpression resultExpression = new BetweenExpression(firstExpression, secondExpression, thirdExpression, ((BetweenExpression)rawExpression).isNotBetween());
        return ExpressionUtils.cloneCommonFields(rawExpression, resultExpression);
    }

    private static Expression cloneCommonFields(Expression rawExpression, Expression resultExpression) {
        resultExpression.setViewPath(rawExpression.getViewPath());
        return resultExpression;
    }

    public static <T> void cartesianProduct(List<List<T>> dimensionValue, List<List<T>> resultList, int layer, List<T> currentList) {
        block7: {
            block6: {
                if (layer >= dimensionValue.size() - 1) break block6;
                if (dimensionValue.get(layer).isEmpty()) {
                    ExpressionUtils.cartesianProduct(dimensionValue, resultList, layer + 1, currentList);
                } else {
                    for (int i = 0; i < dimensionValue.get(layer).size(); ++i) {
                        ArrayList<T> list = new ArrayList<T>(currentList);
                        list.add(dimensionValue.get(layer).get(i));
                        ExpressionUtils.cartesianProduct(dimensionValue, resultList, layer + 1, list);
                    }
                }
                break block7;
            }
            if (layer != dimensionValue.size() - 1) break block7;
            if (dimensionValue.get(layer).isEmpty()) {
                resultList.add(currentList);
            } else {
                for (int i = 0; i < dimensionValue.get(layer).size(); ++i) {
                    ArrayList<T> list = new ArrayList<T>(currentList);
                    list.add(dimensionValue.get(layer).get(i));
                    resultList.add(list);
                }
            }
        }
    }
}

