/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.expression.unary;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.regex.Pattern;
import org.apache.commons.lang3.Validate;
import org.apache.iotdb.db.queryengine.plan.expression.Expression;
import org.apache.iotdb.db.queryengine.plan.expression.ExpressionType;
import org.apache.iotdb.db.queryengine.plan.expression.unary.UnaryExpression;
import org.apache.iotdb.db.queryengine.plan.expression.visitor.ExpressionVisitor;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.apache.iotdb.tsfile.utils.RegexUtils;

public class RegularExpression
extends UnaryExpression {
    private final String patternString;
    private final Pattern pattern;
    private final boolean isNot;

    public RegularExpression(Expression expression, String patternString, boolean isNot) {
        super(expression);
        this.patternString = patternString;
        this.isNot = isNot;
        this.pattern = RegexUtils.compileRegex((String)patternString);
    }

    public RegularExpression(Expression expression, String patternString, Pattern pattern, boolean isNot) {
        super(expression);
        this.patternString = patternString;
        this.pattern = pattern;
        this.isNot = isNot;
    }

    public RegularExpression(ByteBuffer byteBuffer) {
        super(Expression.deserialize(byteBuffer));
        this.patternString = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
        this.isNot = ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer);
        this.pattern = RegexUtils.compileRegex((String)((String)Validate.notNull((Object)this.patternString, (String)"patternString cannot be null", (Object[])new Object[0])));
    }

    public String getPatternString() {
        return this.patternString;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public boolean isNot() {
        return this.isNot;
    }

    @Override
    protected String getExpressionStringInternal() {
        return this.expression.getExpressionString() + (this.isNot ? " NOT" : "") + " REGEXP '" + this.patternString + "'";
    }

    @Override
    public ExpressionType getExpressionType() {
        return ExpressionType.REGEXP;
    }

    @Override
    protected void serialize(ByteBuffer byteBuffer) {
        super.serialize(byteBuffer);
        ReadWriteIOUtils.write((String)this.patternString, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((Boolean)this.isNot, (ByteBuffer)byteBuffer);
    }

    @Override
    protected void serialize(DataOutputStream stream) throws IOException {
        super.serialize(stream);
        ReadWriteIOUtils.write((String)this.patternString, (OutputStream)stream);
        ReadWriteIOUtils.write((Boolean)this.isNot, (OutputStream)stream);
    }

    @Override
    public String getOutputSymbolInternal() {
        return this.expression.getOutputSymbol() + (this.isNot ? " NOT" : "") + " REGEXP '" + this.patternString + "'";
    }

    @Override
    public <R, C> R accept(ExpressionVisitor<R, C> visitor, C context) {
        return visitor.visitRegularExpression(this, context);
    }
}

