/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.distribution;

import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.commons.partition.ExecutorType;
import org.apache.iotdb.commons.partition.StorageExecutor;
import org.apache.iotdb.db.queryengine.common.MPPQueryContext;
import org.apache.iotdb.db.queryengine.plan.analyze.Analysis;
import org.apache.iotdb.db.queryengine.plan.expression.Expression;
import org.apache.iotdb.db.queryengine.plan.planner.IFragmentParallelPlaner;
import org.apache.iotdb.db.queryengine.plan.planner.plan.FragmentInstance;
import org.apache.iotdb.db.queryengine.plan.planner.plan.PlanFragment;
import org.apache.iotdb.db.queryengine.plan.planner.plan.SubPlan;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.WritePlanNode;

public class WriteFragmentParallelPlanner
implements IFragmentParallelPlaner {
    private SubPlan subPlan;
    private Analysis analysis;
    private MPPQueryContext queryContext;

    public WriteFragmentParallelPlanner(SubPlan subPlan, Analysis analysis, MPPQueryContext queryContext) {
        this.subPlan = subPlan;
        this.analysis = analysis;
        this.queryContext = queryContext;
    }

    @Override
    public List<FragmentInstance> parallelPlan() {
        PlanFragment fragment = this.subPlan.getPlanFragment();
        Expression globalTimePredicate = this.analysis.getGlobalTimePredicate();
        PlanNode node = fragment.getPlanNodeTree();
        if (!(node instanceof WritePlanNode)) {
            throw new IllegalArgumentException("PlanNode should be IWritePlanNode in WRITE operation");
        }
        List<WritePlanNode> splits = ((WritePlanNode)node).splitByPartition(this.analysis);
        ArrayList<FragmentInstance> ret = new ArrayList<FragmentInstance>();
        for (WritePlanNode split : splits) {
            FragmentInstance instance = new FragmentInstance(new PlanFragment(fragment.getId(), split), fragment.getId().genFragmentInstanceId(), globalTimePredicate, this.queryContext.getQueryType(), this.queryContext.getTimeOut(), this.queryContext.getSession());
            if (split.getRegionReplicaSet() != null) {
                instance.setExecutorAndHost((ExecutorType)new StorageExecutor(split.getRegionReplicaSet()));
            }
            ret.add(instance);
        }
        return ret;
    }
}

