/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.plan.node.load;

import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.common.rpc.thrift.TTimePartitionSlot;
import org.apache.iotdb.commons.utils.TimePartitionUtils;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.queryengine.plan.analyze.Analysis;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.WritePlanNode;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.tsfile.exception.NotImplementedException;
import org.apache.iotdb.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadSingleTsFileNode
extends WritePlanNode {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoadSingleTsFileNode.class);
    private final File tsFile;
    private final TsFileResource resource;
    private final boolean deleteAfterLoad;
    private final long writePointCount;
    private boolean needDecodeTsFile;
    private TRegionReplicaSet localRegionReplicaSet;

    public LoadSingleTsFileNode(PlanNodeId id, TsFileResource resource, boolean deleteAfterLoad, long writePointCount) {
        super(id);
        this.tsFile = resource.getTsFile();
        this.resource = resource;
        this.deleteAfterLoad = deleteAfterLoad;
        this.writePointCount = writePointCount;
    }

    public boolean isTsFileEmpty() {
        return this.resource.getDevices().isEmpty();
    }

    public boolean needDecodeTsFile(Function<List<Pair<String, TTimePartitionSlot>>, List<TRegionReplicaSet>> partitionFetcher) throws IOException {
        ArrayList slotList = new ArrayList();
        this.resource.getDevices().forEach(o -> {
            slotList.add(new Pair(o, (Object)TimePartitionUtils.getTimePartitionSlot((long)this.resource.getStartTime((String)o))));
            slotList.add(new Pair(o, (Object)TimePartitionUtils.getTimePartitionSlot((long)this.resource.getEndTime((String)o))));
        });
        if (slotList.isEmpty()) {
            throw new IllegalStateException(String.format("Devices in TsFile %s is empty, this should not happen here.", this.tsFile));
        }
        this.needDecodeTsFile = slotList.stream().anyMatch(slotPair -> !((TTimePartitionSlot)slotPair.getRight()).equals((TTimePartitionSlot)((Pair)slotList.get((int)0)).right)) ? true : !this.isDispatchedToLocal(new HashSet<TRegionReplicaSet>((Collection)partitionFetcher.apply(slotList)));
        return this.needDecodeTsFile;
    }

    private boolean isDispatchedToLocal(Set<TRegionReplicaSet> replicaSets) {
        if (replicaSets.size() > 1) {
            return false;
        }
        for (TRegionReplicaSet replicaSet : replicaSets) {
            List dataNodeLocationList = replicaSet.getDataNodeLocations();
            if (dataNodeLocationList.size() > 1) {
                return false;
            }
            this.localRegionReplicaSet = replicaSet;
            if (dataNodeLocationList.size() != 1) continue;
            return this.isDispatchedToLocal(((TDataNodeLocation)dataNodeLocationList.get(0)).getInternalEndPoint());
        }
        return true;
    }

    private boolean isDispatchedToLocal(TEndPoint endPoint) {
        return IoTDBDescriptor.getInstance().getConfig().getInternalAddress().equals(endPoint.getIp()) && IoTDBDescriptor.getInstance().getConfig().getInternalPort() == endPoint.port;
    }

    public boolean isDeleteAfterLoad() {
        return this.deleteAfterLoad;
    }

    public long getWritePointCount() {
        return this.writePointCount;
    }

    public TRegionReplicaSet getLocalRegionReplicaSet() {
        return this.localRegionReplicaSet;
    }

    public TsFileResource getTsFileResource() {
        return this.resource;
    }

    @Override
    public TRegionReplicaSet getRegionReplicaSet() {
        return null;
    }

    @Override
    public List<PlanNode> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public void addChild(PlanNode child) {
    }

    @Override
    public PlanNode clone() {
        throw new NotImplementedException("clone of load single TsFile is not implemented");
    }

    @Override
    public int allowedChildCount() {
        return 0;
    }

    @Override
    public List<String> getOutputColumnNames() {
        return Collections.emptyList();
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
    }

    @Override
    public List<WritePlanNode> splitByPartition(Analysis analysis) {
        throw new NotImplementedException("split load single TsFile is not implemented");
    }

    public String toString() {
        return "LoadSingleTsFileNode{tsFile=" + this.tsFile + ", needDecodeTsFile=" + this.needDecodeTsFile + '}';
    }

    public void clean() {
        try {
            if (this.deleteAfterLoad) {
                Files.deleteIfExists(this.tsFile.toPath());
                Files.deleteIfExists(new File(this.tsFile.getAbsolutePath() + ".resource").toPath());
                Files.deleteIfExists(new File(this.tsFile.getAbsolutePath() + ".mods").toPath());
            }
        }
        catch (IOException e) {
            LOGGER.warn("Delete After Loading {} error.", (Object)this.tsFile, (Object)e);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LoadSingleTsFileNode loadSingleTsFileNode = (LoadSingleTsFileNode)o;
        return Objects.equals(this.tsFile, loadSingleTsFileNode.tsFile) && Objects.equals(this.resource, loadSingleTsFileNode.resource) && Objects.equals(this.needDecodeTsFile, loadSingleTsFileNode.needDecodeTsFile) && Objects.equals(this.deleteAfterLoad, loadSingleTsFileNode.deleteAfterLoad) && Objects.equals(this.localRegionReplicaSet, loadSingleTsFileNode.localRegionReplicaSet);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.tsFile, this.resource, this.needDecodeTsFile, this.deleteAfterLoad, this.localRegionReplicaSet);
    }
}

