/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.plan.node.process;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.time.ZoneId;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.plan.analyze.TypeProvider;
import org.apache.iotdb.db.queryengine.plan.expression.Expression;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.TransformNode;
import org.apache.iotdb.db.queryengine.plan.statement.component.Ordering;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class FilterNode
extends TransformNode {
    private final Expression predicate;

    public FilterNode(PlanNodeId id, PlanNode childPlanNode, Expression[] outputExpressions, Expression predicate, boolean keepNull, ZoneId zoneId, Ordering scanOrder) {
        super(id, childPlanNode, outputExpressions, keepNull, zoneId, scanOrder);
        this.predicate = predicate;
    }

    public FilterNode(PlanNodeId id, Expression[] outputExpressions, Expression predicate, boolean keepNull, ZoneId zoneId, Ordering scanOrder) {
        super(id, outputExpressions, keepNull, zoneId, scanOrder);
        this.predicate = predicate;
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitFilter(this, context);
    }

    @Override
    public PlanNode clone() {
        return new FilterNode(this.getPlanNodeId(), this.outputExpressions, this.predicate, this.keepNull, this.zoneId, this.scanOrder);
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.FILTER.serialize(byteBuffer);
        ReadWriteIOUtils.write((int)this.outputExpressions.length, (ByteBuffer)byteBuffer);
        for (Expression expression : this.outputExpressions) {
            Expression.serialize(expression, byteBuffer);
        }
        Expression.serialize(this.predicate, byteBuffer);
        ReadWriteIOUtils.write((Boolean)this.keepNull, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((String)this.zoneId.getId(), (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((int)this.scanOrder.ordinal(), (ByteBuffer)byteBuffer);
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.FILTER.serialize(stream);
        ReadWriteIOUtils.write((int)this.outputExpressions.length, (OutputStream)stream);
        for (Expression expression : this.outputExpressions) {
            Expression.serialize(expression, stream);
        }
        Expression.serialize(this.predicate, stream);
        ReadWriteIOUtils.write((Boolean)this.keepNull, (OutputStream)stream);
        ReadWriteIOUtils.write((String)this.zoneId.getId(), (OutputStream)stream);
        ReadWriteIOUtils.write((int)this.scanOrder.ordinal(), (OutputStream)stream);
    }

    public static FilterNode deserialize(ByteBuffer byteBuffer) {
        int outputExpressionsLength = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        Expression[] outputExpressions = new Expression[outputExpressionsLength];
        for (int i = 0; i < outputExpressionsLength; ++i) {
            outputExpressions[i] = Expression.deserialize(byteBuffer);
        }
        Expression predicate = Expression.deserialize(byteBuffer);
        boolean keepNull = ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer);
        ZoneId zoneId = ZoneId.of(Objects.requireNonNull(ReadWriteIOUtils.readString((ByteBuffer)byteBuffer)));
        Ordering scanOrder = Ordering.values()[ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer)];
        PlanNodeId planNodeId = PlanNodeId.deserialize(byteBuffer);
        return new FilterNode(planNodeId, outputExpressions, predicate, keepNull, zoneId, scanOrder);
    }

    @Override
    public void serializeUseTemplate(DataOutputStream stream, TypeProvider typeProvider) throws IOException {
        PlanNodeType.FILTER.serialize(stream);
        this.id.serialize(stream);
        ReadWriteIOUtils.write((int)this.getChildren().size(), (OutputStream)stream);
        for (PlanNode planNode : this.getChildren()) {
            planNode.serializeUseTemplate(stream, typeProvider);
        }
    }

    public static FilterNode deserializeUseTemplate(ByteBuffer byteBuffer, TypeProvider typeProvider) {
        PlanNodeId planNodeId = PlanNodeId.deserialize(byteBuffer);
        return new FilterNode(planNodeId, null, typeProvider.getTemplatedInfo().getPredicate(), typeProvider.getTemplatedInfo().isKeepNull(), typeProvider.getTemplatedInfo().getZoneId(), typeProvider.getTemplatedInfo().getScanOrder());
    }

    public Expression getPredicate() {
        return this.predicate;
    }

    public void setOutputExpressions(Expression[] outputExpressions) {
        this.outputExpressions = outputExpressions;
    }

    @Override
    public String toString() {
        return "FilterNode-" + this.getPlanNodeId();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FilterNode)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FilterNode that = (FilterNode)o;
        return this.predicate.equals(that.predicate);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.predicate);
    }
}

