/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.plan.node.source;

import com.google.common.collect.ImmutableList;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathDeserializeUtil;
import org.apache.iotdb.db.queryengine.plan.expression.Expression;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeUtil;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.source.SeriesSourceNode;
import org.apache.iotdb.db.queryengine.plan.statement.component.Ordering;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class SeriesScanNode
extends SeriesSourceNode {
    private final MeasurementPath seriesPath;
    private Ordering scanOrder = Ordering.ASC;
    @Nullable
    private Expression pushDownPredicate;
    private long pushDownLimit;
    private long pushDownOffset;
    private TRegionReplicaSet regionReplicaSet;

    public SeriesScanNode(PlanNodeId id, MeasurementPath seriesPath) {
        super(id);
        this.seriesPath = seriesPath;
    }

    public SeriesScanNode(PlanNodeId id, MeasurementPath seriesPath, Ordering scanOrder) {
        this(id, seriesPath);
        this.scanOrder = scanOrder;
    }

    public SeriesScanNode(PlanNodeId id, MeasurementPath seriesPath, Ordering scanOrder, long pushDownLimit, long pushDownOffset, TRegionReplicaSet dataRegionReplicaSet) {
        this(id, seriesPath, scanOrder);
        this.pushDownLimit = pushDownLimit;
        this.pushDownOffset = pushDownOffset;
        this.regionReplicaSet = dataRegionReplicaSet;
    }

    public SeriesScanNode(PlanNodeId id, MeasurementPath seriesPath, Ordering scanOrder, @Nullable Expression pushDownPredicate, long pushDownLimit, long pushDownOffset, TRegionReplicaSet dataRegionReplicaSet) {
        this(id, seriesPath, scanOrder);
        this.pushDownPredicate = pushDownPredicate;
        this.pushDownLimit = pushDownLimit;
        this.pushDownOffset = pushDownOffset;
        this.regionReplicaSet = dataRegionReplicaSet;
    }

    @Override
    public void close() throws Exception {
    }

    @Override
    public void open() throws Exception {
    }

    @Override
    public TRegionReplicaSet getRegionReplicaSet() {
        return this.regionReplicaSet;
    }

    @Override
    public void setRegionReplicaSet(TRegionReplicaSet dataRegion) {
        this.regionReplicaSet = dataRegion;
    }

    public long getPushDownLimit() {
        return this.pushDownLimit;
    }

    public long getPushDownOffset() {
        return this.pushDownOffset;
    }

    public void setPushDownLimit(long pushDownLimit) {
        this.pushDownLimit = pushDownLimit;
    }

    public void setPushDownOffset(long pushDownOffset) {
        this.pushDownOffset = pushDownOffset;
    }

    public Ordering getScanOrder() {
        return this.scanOrder;
    }

    public void setScanOrder(Ordering scanOrder) {
        this.scanOrder = scanOrder;
    }

    public MeasurementPath getSeriesPath() {
        return this.seriesPath;
    }

    @Override
    @Nullable
    public Expression getPushDownPredicate() {
        return this.pushDownPredicate;
    }

    public void setPushDownPredicate(@Nullable Expression pushDownPredicate) {
        this.pushDownPredicate = pushDownPredicate;
    }

    @Override
    public List<PlanNode> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public int allowedChildCount() {
        return 0;
    }

    @Override
    public void addChild(PlanNode child) {
        throw new UnsupportedOperationException("no child is allowed for SeriesScanNode");
    }

    @Override
    public PlanNode clone() {
        return new SeriesScanNode(this.getPlanNodeId(), this.getSeriesPath(), this.getScanOrder(), this.getPushDownPredicate(), this.getPushDownLimit(), this.getPushDownOffset(), this.regionReplicaSet);
    }

    @Override
    public List<String> getOutputColumnNames() {
        return ImmutableList.of((Object)this.seriesPath.getFullPath());
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitSeriesScan(this, context);
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.SERIES_SCAN.serialize(byteBuffer);
        this.seriesPath.serialize(byteBuffer);
        ReadWriteIOUtils.write((int)this.scanOrder.ordinal(), (ByteBuffer)byteBuffer);
        if (this.pushDownPredicate == null) {
            ReadWriteIOUtils.write((byte)0, (ByteBuffer)byteBuffer);
        } else {
            ReadWriteIOUtils.write((byte)1, (ByteBuffer)byteBuffer);
            Expression.serialize(this.pushDownPredicate, byteBuffer);
        }
        ReadWriteIOUtils.write((long)this.pushDownLimit, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((long)this.pushDownOffset, (ByteBuffer)byteBuffer);
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.SERIES_SCAN.serialize(stream);
        this.seriesPath.serialize((OutputStream)stream);
        ReadWriteIOUtils.write((int)this.scanOrder.ordinal(), (OutputStream)stream);
        if (this.pushDownPredicate == null) {
            ReadWriteIOUtils.write((byte)0, (OutputStream)stream);
        } else {
            ReadWriteIOUtils.write((byte)1, (OutputStream)stream);
            Expression.serialize(this.pushDownPredicate, stream);
        }
        ReadWriteIOUtils.write((long)this.pushDownLimit, (OutputStream)stream);
        ReadWriteIOUtils.write((long)this.pushDownOffset, (OutputStream)stream);
    }

    public static SeriesScanNode deserialize(ByteBuffer byteBuffer) {
        MeasurementPath partialPath = (MeasurementPath)PathDeserializeUtil.deserialize((ByteBuffer)byteBuffer);
        Ordering scanOrder = Ordering.values()[ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer)];
        byte isNull = ReadWriteIOUtils.readByte((ByteBuffer)byteBuffer);
        Expression pushDownPredicate = null;
        if (isNull == 1) {
            pushDownPredicate = Expression.deserialize(byteBuffer);
        }
        long limit = ReadWriteIOUtils.readLong((ByteBuffer)byteBuffer);
        long offset = ReadWriteIOUtils.readLong((ByteBuffer)byteBuffer);
        PlanNodeId planNodeId = PlanNodeId.deserialize(byteBuffer);
        return new SeriesScanNode(planNodeId, partialPath, scanOrder, pushDownPredicate, limit, offset, null);
    }

    public String toString() {
        return String.format("SeriesScanNode-%s:[SeriesPath: %s, DataRegion: %s]", this.getPlanNodeId(), this.getSeriesPath(), PlanNodeUtil.printRegionReplicaSet(this.getRegionReplicaSet()));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SeriesScanNode that = (SeriesScanNode)o;
        return this.pushDownLimit == that.pushDownLimit && this.pushDownOffset == that.pushDownOffset && this.seriesPath.equals((Object)that.seriesPath) && this.scanOrder == that.scanOrder && Objects.equals(this.pushDownPredicate, that.pushDownPredicate) && Objects.equals(this.regionReplicaSet, that.regionReplicaSet);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.seriesPath, this.scanOrder, this.pushDownPredicate, this.pushDownLimit, this.pushDownOffset, this.regionReplicaSet});
    }

    @Override
    public PartialPath getPartitionPath() {
        return this.getSeriesPath();
    }
}

