/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.column.unary.scalar;

import org.apache.iotdb.db.queryengine.transformation.dag.column.ColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.unary.UnaryColumnTransformer;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnBuilder;
import org.apache.iotdb.tsfile.read.common.type.Type;

public class DiffFunctionColumnTransformer
extends UnaryColumnTransformer {
    private final boolean ignoreNull;
    private double lastValue;
    private boolean lastValueIsNull = true;

    public DiffFunctionColumnTransformer(Type returnType, ColumnTransformer childColumnTransformer, boolean ignoreNull) {
        super(returnType, childColumnTransformer);
        this.ignoreNull = ignoreNull;
    }

    @Override
    protected void doTransform(Column column, ColumnBuilder columnBuilder) {
        int n = column.getPositionCount();
        for (int i = 0; i < n; ++i) {
            if (column.isNull(i)) {
                columnBuilder.appendNull();
                this.lastValueIsNull |= !this.ignoreNull;
                continue;
            }
            double currValue = this.childColumnTransformer.getType().getDouble(column, i);
            if (this.lastValueIsNull) {
                columnBuilder.appendNull();
            } else {
                this.returnType.writeDouble(columnBuilder, currValue - this.lastValue);
            }
            this.lastValue = currValue;
            this.lastValueIsNull = false;
        }
    }
}

