/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.transformer.multi;

import java.io.IOException;
import java.util.Objects;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.queryengine.transformation.api.LayerRowReader;
import org.apache.iotdb.db.queryengine.transformation.api.YieldableState;
import org.apache.iotdb.db.queryengine.transformation.dag.transformer.multi.UDFQueryTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.udf.UDTFExecutor;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.udf.api.access.Row;

public class MappableUDFQueryRowTransformer
extends UDFQueryTransformer {
    protected final LayerRowReader layerRowReader;
    private final boolean isLayerRowReaderConstant;

    public MappableUDFQueryRowTransformer(LayerRowReader layerRowReader, UDTFExecutor executor) {
        super(executor);
        this.layerRowReader = layerRowReader;
        this.isLayerRowReaderConstant = false;
    }

    @Override
    protected boolean cacheValue() throws QueryProcessException, IOException {
        if (!this.layerRowReader.next()) {
            return false;
        }
        if (!this.isLayerRowReaderConstant) {
            this.cachedTime = this.layerRowReader.currentTime();
        }
        if (this.layerRowReader.isCurrentNull()) {
            this.currentNull = true;
        } else {
            Row row = this.layerRowReader.currentRow();
            this.execute(row);
        }
        this.layerRowReader.readyForNext();
        return true;
    }

    @Override
    protected YieldableState yieldValue() throws Exception {
        YieldableState yieldableState = this.layerRowReader.yield();
        if (!YieldableState.YIELDABLE.equals((Object)yieldableState)) {
            return yieldableState;
        }
        if (!this.isLayerRowReaderConstant) {
            this.cachedTime = this.layerRowReader.currentTime();
        }
        if (this.layerRowReader.isCurrentNull()) {
            this.currentNull = true;
        } else {
            Row row = this.layerRowReader.currentRow();
            this.execute(row);
        }
        this.layerRowReader.readyForNext();
        return YieldableState.YIELDABLE;
    }

    private void execute(Row row) {
        this.executor.execute(row);
        Object currentValue = this.executor.getCurrentValue();
        if (Objects.isNull(currentValue)) {
            this.currentNull = true;
            return;
        }
        switch (this.tsDataType) {
            case INT32: {
                this.cachedInt = (Integer)currentValue;
                break;
            }
            case INT64: {
                this.cachedLong = (Long)currentValue;
                break;
            }
            case FLOAT: {
                this.cachedFloat = ((Float)currentValue).floatValue();
                break;
            }
            case DOUBLE: {
                this.cachedDouble = (Double)currentValue;
                break;
            }
            case BOOLEAN: {
                this.cachedBoolean = (Boolean)currentValue;
                break;
            }
            case TEXT: {
                this.cachedBinary = (Binary)currentValue;
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(this.tsDataType.toString());
            }
        }
    }

    @Override
    public boolean isConstantPointReader() {
        return this.isLayerRowReaderConstant;
    }
}

