/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.schemaengine.schemaregion.logfile.visitor;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.schema.view.viewExpression.ViewExpression;
import org.apache.iotdb.db.schemaengine.schemaregion.ISchemaRegionPlan;
import org.apache.iotdb.db.schemaengine.schemaregion.SchemaRegionPlanVisitor;
import org.apache.iotdb.db.schemaengine.schemaregion.logfile.ISerializer;
import org.apache.iotdb.db.schemaengine.schemaregion.write.req.IActivateTemplateInClusterPlan;
import org.apache.iotdb.db.schemaengine.schemaregion.write.req.IAutoCreateDeviceMNodePlan;
import org.apache.iotdb.db.schemaengine.schemaregion.write.req.IChangeAliasPlan;
import org.apache.iotdb.db.schemaengine.schemaregion.write.req.IChangeTagOffsetPlan;
import org.apache.iotdb.db.schemaengine.schemaregion.write.req.ICreateAlignedTimeSeriesPlan;
import org.apache.iotdb.db.schemaengine.schemaregion.write.req.ICreateTimeSeriesPlan;
import org.apache.iotdb.db.schemaengine.schemaregion.write.req.IDeactivateTemplatePlan;
import org.apache.iotdb.db.schemaengine.schemaregion.write.req.IDeleteTimeSeriesPlan;
import org.apache.iotdb.db.schemaengine.schemaregion.write.req.IPreDeactivateTemplatePlan;
import org.apache.iotdb.db.schemaengine.schemaregion.write.req.IPreDeleteTimeSeriesPlan;
import org.apache.iotdb.db.schemaengine.schemaregion.write.req.IRollbackPreDeactivateTemplatePlan;
import org.apache.iotdb.db.schemaengine.schemaregion.write.req.IRollbackPreDeleteTimeSeriesPlan;
import org.apache.iotdb.db.schemaengine.schemaregion.write.req.view.IAlterLogicalViewPlan;
import org.apache.iotdb.db.schemaengine.schemaregion.write.req.view.ICreateLogicalViewPlan;
import org.apache.iotdb.db.schemaengine.schemaregion.write.req.view.IDeleteLogicalViewPlan;
import org.apache.iotdb.db.schemaengine.schemaregion.write.req.view.IPreDeleteLogicalViewPlan;
import org.apache.iotdb.db.schemaengine.schemaregion.write.req.view.IRollbackPreDeleteLogicalViewPlan;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

@NotThreadSafe
public class SchemaRegionPlanSerializer
implements ISerializer<ISchemaRegionPlan> {
    public final ConfigurableDataOutputStream dataOutputStream = new ConfigurableDataOutputStream(null);

    @Override
    public void serialize(ISchemaRegionPlan plan, OutputStream outputStream) throws IOException {
        this.dataOutputStream.changeOutputStream(outputStream);
        plan.getPlanType().serialize(this.dataOutputStream);
        SchemaRegionPlanSerializationResult result = plan.accept(new SchemaRegionPlanSerializeVisitor(), this.dataOutputStream);
        if (result.isFailed()) {
            throw result.getException();
        }
    }

    private static class SchemaRegionPlanSerializeVisitor
    extends SchemaRegionPlanVisitor<SchemaRegionPlanSerializationResult, DataOutputStream> {
        private SchemaRegionPlanSerializeVisitor() {
        }

        @Override
        public SchemaRegionPlanSerializationResult visitSchemaRegionPlan(ISchemaRegionPlan plan, DataOutputStream dataOutputStream) {
            throw new UnsupportedOperationException(String.format("%s plan doesn't support serialization.", plan.getPlanType().name()));
        }

        @Override
        public SchemaRegionPlanSerializationResult visitActivateTemplateInCluster(IActivateTemplateInClusterPlan activateTemplateInClusterPlan, DataOutputStream dataOutputStream) {
            try {
                ReadWriteIOUtils.write((String)activateTemplateInClusterPlan.getActivatePath().getFullPath(), (OutputStream)dataOutputStream);
                dataOutputStream.writeInt(activateTemplateInClusterPlan.getTemplateSetLevel());
                dataOutputStream.writeInt(activateTemplateInClusterPlan.getTemplateId());
                dataOutputStream.writeBoolean(activateTemplateInClusterPlan.isAligned());
                dataOutputStream.writeLong(0L);
                return SchemaRegionPlanSerializationResult.SUCCESS;
            }
            catch (IOException e) {
                return new SchemaRegionPlanSerializationResult(e);
            }
        }

        @Override
        public SchemaRegionPlanSerializationResult visitAutoCreateDeviceMNode(IAutoCreateDeviceMNodePlan autoCreateDeviceMNodePlan, DataOutputStream dataOutputStream) {
            try {
                ReadWriteIOUtils.write((String)autoCreateDeviceMNodePlan.getPath().getFullPath(), (OutputStream)dataOutputStream);
                dataOutputStream.writeLong(0L);
                return SchemaRegionPlanSerializationResult.SUCCESS;
            }
            catch (IOException e) {
                return new SchemaRegionPlanSerializationResult(e);
            }
        }

        @Override
        public SchemaRegionPlanSerializationResult visitChangeAlias(IChangeAliasPlan changeAliasPlan, DataOutputStream dataOutputStream) {
            try {
                ReadWriteIOUtils.write((String)changeAliasPlan.getPath().getFullPath(), (OutputStream)dataOutputStream);
                ReadWriteIOUtils.write((String)changeAliasPlan.getAlias(), (OutputStream)dataOutputStream);
                return SchemaRegionPlanSerializationResult.SUCCESS;
            }
            catch (IOException e) {
                return new SchemaRegionPlanSerializationResult(e);
            }
        }

        @Override
        public SchemaRegionPlanSerializationResult visitChangeTagOffset(IChangeTagOffsetPlan changeTagOffsetPlan, DataOutputStream dataOutputStream) {
            try {
                ReadWriteIOUtils.write((String)changeTagOffsetPlan.getPath().getFullPath(), (OutputStream)dataOutputStream);
                dataOutputStream.writeLong(changeTagOffsetPlan.getOffset());
                return SchemaRegionPlanSerializationResult.SUCCESS;
            }
            catch (IOException e) {
                return new SchemaRegionPlanSerializationResult(e);
            }
        }

        @Override
        public SchemaRegionPlanSerializationResult visitCreateAlignedTimeSeries(ICreateAlignedTimeSeriesPlan createAlignedTimeSeriesPlan, DataOutputStream dataOutputStream) {
            try {
                dataOutputStream.writeInt(-1);
                byte[] bytes = createAlignedTimeSeriesPlan.getDevicePath().getFullPath().getBytes();
                dataOutputStream.writeInt(bytes.length);
                dataOutputStream.write(bytes);
                List<String> measurements = createAlignedTimeSeriesPlan.getMeasurements();
                dataOutputStream.writeInt(measurements.size());
                for (String measurement : measurements) {
                    ReadWriteIOUtils.write((String)measurement, (OutputStream)dataOutputStream);
                }
                for (TSDataType dataType : createAlignedTimeSeriesPlan.getDataTypes()) {
                    dataOutputStream.writeByte(dataType.serialize());
                }
                for (TSEncoding tsEncoding : createAlignedTimeSeriesPlan.getEncodings()) {
                    dataOutputStream.writeByte(tsEncoding.serialize());
                }
                for (CompressionType compressionType : createAlignedTimeSeriesPlan.getCompressors()) {
                    dataOutputStream.writeByte(compressionType.serialize());
                }
                Iterator<Object> iterator = createAlignedTimeSeriesPlan.getTagOffsets().iterator();
                while (iterator.hasNext()) {
                    long tagOffset = (Long)iterator.next();
                    dataOutputStream.writeLong(tagOffset);
                }
                List<String> aliasList = createAlignedTimeSeriesPlan.getAliasList();
                if (aliasList == null || aliasList.isEmpty()) {
                    dataOutputStream.writeByte(0);
                } else {
                    dataOutputStream.writeByte(1);
                    for (String string : aliasList) {
                        ReadWriteIOUtils.write((String)string, (OutputStream)dataOutputStream);
                    }
                }
                List<Map<String, String>> tagsList = createAlignedTimeSeriesPlan.getTagsList();
                if (tagsList == null || tagsList.isEmpty()) {
                    dataOutputStream.writeByte(0);
                } else {
                    dataOutputStream.writeByte(1);
                    for (Map<String, String> map : tagsList) {
                        ReadWriteIOUtils.write(map, (OutputStream)dataOutputStream);
                    }
                }
                List<Map<String, String>> list = createAlignedTimeSeriesPlan.getAttributesList();
                if (list == null || list.isEmpty()) {
                    dataOutputStream.writeByte(0);
                } else {
                    dataOutputStream.writeByte(1);
                    for (Map<String, String> attributes : list) {
                        ReadWriteIOUtils.write(attributes, (OutputStream)dataOutputStream);
                    }
                }
                dataOutputStream.writeLong(0L);
                return SchemaRegionPlanSerializationResult.SUCCESS;
            }
            catch (IOException e) {
                return new SchemaRegionPlanSerializationResult(e);
            }
        }

        @Override
        public SchemaRegionPlanSerializationResult visitCreateTimeSeries(ICreateTimeSeriesPlan createTimeSeriesPlan, DataOutputStream dataOutputStream) {
            try {
                byte[] bytes = createTimeSeriesPlan.getPath().getFullPath().getBytes();
                dataOutputStream.writeInt(bytes.length);
                dataOutputStream.write(bytes);
                dataOutputStream.writeByte(createTimeSeriesPlan.getDataType().serialize());
                dataOutputStream.writeByte(createTimeSeriesPlan.getEncoding().serialize());
                dataOutputStream.writeByte(createTimeSeriesPlan.getCompressor().serialize());
                dataOutputStream.writeLong(createTimeSeriesPlan.getTagOffset());
                if (createTimeSeriesPlan.getAlias() == null) {
                    dataOutputStream.writeByte(0);
                } else {
                    dataOutputStream.writeByte(1);
                    ReadWriteIOUtils.write((String)createTimeSeriesPlan.getAlias(), (OutputStream)dataOutputStream);
                }
                Map<String, String> props = createTimeSeriesPlan.getProps();
                if (props == null || props.isEmpty()) {
                    dataOutputStream.writeByte(0);
                } else {
                    dataOutputStream.writeByte(1);
                    ReadWriteIOUtils.write(props, (OutputStream)dataOutputStream);
                }
                Map<String, String> tags = createTimeSeriesPlan.getTags();
                if (tags == null || tags.isEmpty()) {
                    dataOutputStream.writeByte(0);
                } else {
                    dataOutputStream.writeByte(1);
                    ReadWriteIOUtils.write(tags, (OutputStream)dataOutputStream);
                }
                Map<String, String> attributes = createTimeSeriesPlan.getAttributes();
                if (attributes == null || attributes.isEmpty()) {
                    dataOutputStream.writeByte(0);
                } else {
                    dataOutputStream.writeByte(1);
                    ReadWriteIOUtils.write(attributes, (OutputStream)dataOutputStream);
                }
                dataOutputStream.writeLong(0L);
                return SchemaRegionPlanSerializationResult.SUCCESS;
            }
            catch (IOException e) {
                return new SchemaRegionPlanSerializationResult(e);
            }
        }

        @Override
        public SchemaRegionPlanSerializationResult visitDeleteTimeSeries(IDeleteTimeSeriesPlan deleteTimeSeriesPlan, DataOutputStream dataOutputStream) {
            try {
                List<PartialPath> deletePathList = deleteTimeSeriesPlan.getDeletePathList();
                dataOutputStream.writeInt(deletePathList.size());
                for (PartialPath path : deletePathList) {
                    ReadWriteIOUtils.write((String)path.getFullPath(), (OutputStream)dataOutputStream);
                }
                dataOutputStream.writeLong(0L);
                return SchemaRegionPlanSerializationResult.SUCCESS;
            }
            catch (IOException e) {
                return new SchemaRegionPlanSerializationResult(e);
            }
        }

        @Override
        public SchemaRegionPlanSerializationResult visitPreDeleteTimeSeries(IPreDeleteTimeSeriesPlan preDeleteTimeSeriesPlan, DataOutputStream dataOutputStream) {
            try {
                preDeleteTimeSeriesPlan.getPath().serialize((OutputStream)dataOutputStream);
                dataOutputStream.writeLong(0L);
                return SchemaRegionPlanSerializationResult.SUCCESS;
            }
            catch (IOException e) {
                return new SchemaRegionPlanSerializationResult(e);
            }
        }

        @Override
        public SchemaRegionPlanSerializationResult visitRollbackPreDeleteTimeSeries(IRollbackPreDeleteTimeSeriesPlan rollbackPreDeleteTimeSeriesPlan, DataOutputStream dataOutputStream) {
            try {
                rollbackPreDeleteTimeSeriesPlan.getPath().serialize((OutputStream)dataOutputStream);
                dataOutputStream.writeLong(0L);
                return SchemaRegionPlanSerializationResult.SUCCESS;
            }
            catch (IOException e) {
                return new SchemaRegionPlanSerializationResult(e);
            }
        }

        @Override
        public SchemaRegionPlanSerializationResult visitPreDeactivateTemplate(IPreDeactivateTemplatePlan preDeactivateTemplatePlan, DataOutputStream dataOutputStream) {
            try {
                this.serializeTemplateSetInfo(preDeactivateTemplatePlan.getTemplateSetInfo(), dataOutputStream);
                return SchemaRegionPlanSerializationResult.SUCCESS;
            }
            catch (IOException e) {
                return new SchemaRegionPlanSerializationResult(e);
            }
        }

        @Override
        public SchemaRegionPlanSerializationResult visitRollbackPreDeactivateTemplate(IRollbackPreDeactivateTemplatePlan rollbackPreDeactivateTemplatePlan, DataOutputStream dataOutputStream) {
            try {
                this.serializeTemplateSetInfo(rollbackPreDeactivateTemplatePlan.getTemplateSetInfo(), dataOutputStream);
                return SchemaRegionPlanSerializationResult.SUCCESS;
            }
            catch (IOException e) {
                return new SchemaRegionPlanSerializationResult(e);
            }
        }

        @Override
        public SchemaRegionPlanSerializationResult visitDeactivateTemplate(IDeactivateTemplatePlan deactivateTemplatePlan, DataOutputStream dataOutputStream) {
            try {
                this.serializeTemplateSetInfo(deactivateTemplatePlan.getTemplateSetInfo(), dataOutputStream);
                return SchemaRegionPlanSerializationResult.SUCCESS;
            }
            catch (IOException e) {
                return new SchemaRegionPlanSerializationResult(e);
            }
        }

        private void serializeTemplateSetInfo(Map<PartialPath, List<Integer>> templateSetInfo, DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeInt(templateSetInfo.size());
            for (Map.Entry<PartialPath, List<Integer>> entry : templateSetInfo.entrySet()) {
                entry.getKey().serialize((OutputStream)dataOutputStream);
                dataOutputStream.writeInt(entry.getValue().size());
                for (int templateId : entry.getValue()) {
                    dataOutputStream.writeInt(templateId);
                }
            }
        }

        @Override
        public SchemaRegionPlanSerializationResult visitCreateLogicalView(ICreateLogicalViewPlan createLogicalViewPlan, DataOutputStream dataOutputStream) {
            try {
                int viewSize = createLogicalViewPlan.getViewSize();
                dataOutputStream.writeInt(viewSize);
                List<PartialPath> viewPAthList = createLogicalViewPlan.getViewPathList();
                Map<PartialPath, ViewExpression> viewPathToSourceMap = createLogicalViewPlan.getViewPathToSourceExpressionMap();
                for (int i = 0; i < viewSize; ++i) {
                    PartialPath thisPath = viewPAthList.get(i);
                    ViewExpression thisExp = viewPathToSourceMap.get(thisPath);
                    byte[] bytes = thisPath.getFullPath().getBytes();
                    dataOutputStream.writeInt(bytes.length);
                    dataOutputStream.write(bytes);
                    ViewExpression.serialize((ViewExpression)thisExp, (OutputStream)dataOutputStream);
                }
                return SchemaRegionPlanSerializationResult.SUCCESS;
            }
            catch (IOException e) {
                return new SchemaRegionPlanSerializationResult(e);
            }
        }

        @Override
        public SchemaRegionPlanSerializationResult visitPreDeleteLogicalView(IPreDeleteLogicalViewPlan preDeleteLogicalViewPlan, DataOutputStream dataOutputStream) {
            try {
                preDeleteLogicalViewPlan.getPath().serialize((OutputStream)dataOutputStream);
                return SchemaRegionPlanSerializationResult.SUCCESS;
            }
            catch (IOException e) {
                return new SchemaRegionPlanSerializationResult(e);
            }
        }

        @Override
        public SchemaRegionPlanSerializationResult visitRollbackPreDeleteLogicalView(IRollbackPreDeleteLogicalViewPlan rollbackPreDeleteLogicalViewPlan, DataOutputStream dataOutputStream) {
            try {
                rollbackPreDeleteLogicalViewPlan.getPath().serialize((OutputStream)dataOutputStream);
                return SchemaRegionPlanSerializationResult.SUCCESS;
            }
            catch (IOException e) {
                return new SchemaRegionPlanSerializationResult(e);
            }
        }

        @Override
        public SchemaRegionPlanSerializationResult visitDeleteLogicalView(IDeleteLogicalViewPlan deleteLogicalViewPlan, DataOutputStream dataOutputStream) {
            try {
                deleteLogicalViewPlan.getPath().serialize((OutputStream)dataOutputStream);
                return SchemaRegionPlanSerializationResult.SUCCESS;
            }
            catch (IOException e) {
                return new SchemaRegionPlanSerializationResult(e);
            }
        }

        @Override
        public SchemaRegionPlanSerializationResult visitAlterLogicalView(IAlterLogicalViewPlan alterLogicalViewPlan, DataOutputStream stream) {
            try {
                alterLogicalViewPlan.getViewPath().serialize((OutputStream)stream);
                ViewExpression.serialize((ViewExpression)alterLogicalViewPlan.getSourceExpression(), (OutputStream)stream);
                return SchemaRegionPlanSerializationResult.SUCCESS;
            }
            catch (IOException e) {
                return new SchemaRegionPlanSerializationResult(e);
            }
        }
    }

    private static class SchemaRegionPlanSerializationResult {
        private static final SchemaRegionPlanSerializationResult SUCCESS = new SchemaRegionPlanSerializationResult(null);
        private final IOException exception;

        private SchemaRegionPlanSerializationResult(IOException exception) {
            this.exception = exception;
        }

        private boolean isFailed() {
            return this.exception != null;
        }

        private IOException getException() {
            return this.exception;
        }
    }

    private static class ConfigurableDataOutputStream
    extends DataOutputStream {
        private ConfigurableDataOutputStream(OutputStream out) {
            super(out);
        }

        private void changeOutputStream(OutputStream out) {
            this.out = out;
            this.written = 0;
        }
    }
}

