/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.mnode.container;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import org.apache.iotdb.commons.schema.node.utils.IMNodeContainer;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.mnode.ICachedMNode;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.mnode.container.ICachedMNodeContainer;

public class CachedMNodeContainer
implements ICachedMNodeContainer {
    private long segmentAddress = -1L;
    private Map<String, ICachedMNode> childCache = null;
    private Map<String, ICachedMNode> newChildBuffer = null;
    private Map<String, ICachedMNode> updatedChildBuffer = null;
    private static final IMNodeContainer<ICachedMNode> EMPTY_CONTAINER = new EmptyContainer();

    public static IMNodeContainer<ICachedMNode> emptyMNodeContainer() {
        return EMPTY_CONTAINER;
    }

    public int size() {
        return this.getSize(this.childCache) + this.getSize(this.newChildBuffer) + this.getSize(this.updatedChildBuffer);
    }

    private int getSize(Map<String, ICachedMNode> map) {
        return map == null ? 0 : map.size();
    }

    public boolean isEmpty() {
        return this.isEmpty(this.childCache) && this.isEmpty(this.newChildBuffer) && this.isEmpty(this.updatedChildBuffer);
    }

    private boolean isEmpty(Map<String, ICachedMNode> map) {
        return map == null || map.isEmpty();
    }

    public boolean containsKey(Object key) {
        return this.containsKey(this.childCache, key) || this.containsKey(this.newChildBuffer, key) || this.containsKey(this.updatedChildBuffer, key);
    }

    private boolean containsKey(Map<String, ICachedMNode> map, Object key) {
        return map != null && map.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.containsValue(this.childCache, value) || this.containsValue(this.newChildBuffer, value) || this.containsValue(this.updatedChildBuffer, value);
    }

    private boolean containsValue(Map<String, ICachedMNode> map, Object value) {
        return map != null && map.containsValue(value);
    }

    public synchronized ICachedMNode get(Object key) {
        return this.internalGet(key);
    }

    private ICachedMNode internalGet(Object key) {
        ICachedMNode result = this.get(this.childCache, key);
        if (result != null) {
            return result;
        }
        result = this.get(this.newChildBuffer, key);
        if (result != null) {
            return result;
        }
        return this.get(this.updatedChildBuffer, key);
    }

    private ICachedMNode get(Map<String, ICachedMNode> map, Object key) {
        return map == null ? null : map.get(key);
    }

    @Nullable
    public synchronized ICachedMNode put(String key, ICachedMNode value) {
        if (this.newChildBuffer == null) {
            this.newChildBuffer = new ConcurrentHashMap<String, ICachedMNode>();
        }
        return this.newChildBuffer.put(key, value);
    }

    @Nullable
    public synchronized ICachedMNode putIfAbsent(String key, ICachedMNode value) {
        ICachedMNode node = this.internalGet(key);
        if (node == null) {
            if (this.newChildBuffer == null) {
                this.newChildBuffer = new ConcurrentHashMap<String, ICachedMNode>();
            }
            node = this.newChildBuffer.put(key, value);
        }
        return node;
    }

    public synchronized ICachedMNode remove(Object key) {
        ICachedMNode result = this.removeFromMap(this.childCache, key);
        if (result == null) {
            result = this.removeFromMap(this.newChildBuffer, key);
        }
        if (result == null) {
            result = this.removeFromMap(this.updatedChildBuffer, key);
        }
        return result;
    }

    private ICachedMNode removeFromMap(Map<String, ICachedMNode> map, Object key) {
        return map == null ? null : map.remove(key);
    }

    public synchronized void putAll(@Nonnull Map<? extends String, ? extends ICachedMNode> m) {
        if (this.newChildBuffer == null) {
            this.newChildBuffer = new ConcurrentHashMap<String, ICachedMNode>();
        }
        this.newChildBuffer.putAll(m);
    }

    public synchronized void clear() {
        this.childCache = null;
        this.newChildBuffer = null;
        this.updatedChildBuffer = null;
    }

    @Nonnull
    public Set<String> keySet() {
        TreeSet<String> result = new TreeSet<String>();
        result.addAll(this.keySet(this.childCache));
        result.addAll(this.keySet(this.newChildBuffer));
        result.addAll(this.keySet(this.updatedChildBuffer));
        return result;
    }

    private Set<String> keySet(Map<String, ICachedMNode> map) {
        return map == null ? Collections.emptySet() : map.keySet();
    }

    @Nonnull
    public Collection<ICachedMNode> values() {
        ArrayList<ICachedMNode> result = new ArrayList<ICachedMNode>();
        result.addAll(this.getValues(this.childCache));
        result.addAll(this.getValues(this.newChildBuffer));
        result.addAll(this.getValues(this.updatedChildBuffer));
        return result;
    }

    private Collection<ICachedMNode> getValues(Map<String, ICachedMNode> map) {
        return map == null ? Collections.emptyList() : map.values();
    }

    @Nonnull
    public Set<Map.Entry<String, ICachedMNode>> entrySet() {
        HashSet<Map.Entry<String, ICachedMNode>> result = new HashSet<Map.Entry<String, ICachedMNode>>();
        result.addAll(this.entrySet(this.childCache));
        result.addAll(this.entrySet(this.newChildBuffer));
        result.addAll(this.entrySet(this.updatedChildBuffer));
        return result;
    }

    private Set<Map.Entry<String, ICachedMNode>> entrySet(Map<String, ICachedMNode> map) {
        return map == null ? Collections.emptySet() : map.entrySet();
    }

    @Nullable
    public synchronized ICachedMNode replace(String key, ICachedMNode value) {
        ICachedMNode replacedOne = this.replace(this.childCache, key, value);
        if (replacedOne == null) {
            replacedOne = this.replace(this.newChildBuffer, key, value);
        }
        if (replacedOne == null) {
            replacedOne = this.replace(this.updatedChildBuffer, key, value);
        }
        return replacedOne;
    }

    private ICachedMNode replace(Map<String, ICachedMNode> map, String key, ICachedMNode value) {
        return map == null ? null : map.replace(key, value);
    }

    @Override
    public long getSegmentAddress() {
        return this.segmentAddress;
    }

    @Override
    public void setSegmentAddress(long segmentAddress) {
        this.segmentAddress = segmentAddress;
    }

    @Override
    public boolean isVolatile() {
        return this.segmentAddress == -1L;
    }

    @Override
    public boolean isFull() {
        return true;
    }

    @Override
    public boolean isExpelled() {
        return !this.isVolatile() && this.isEmpty(this.childCache) && this.isEmpty(this.newChildBuffer) && this.isEmpty(this.updatedChildBuffer);
    }

    @Override
    public boolean hasChildInNewChildBuffer(String name) {
        return this.containsKey(this.newChildBuffer, name);
    }

    @Override
    public boolean hasChildInBuffer(String name) {
        return this.containsKey(this.updatedChildBuffer, name) || this.containsKey(this.newChildBuffer, name);
    }

    @Override
    public boolean hasChildrenInBuffer() {
        return !this.isEmpty(this.updatedChildBuffer) || !this.isEmpty(this.newChildBuffer);
    }

    @Override
    public Iterator<ICachedMNode> getChildrenIterator() {
        return new CachedMNodeContainerIterator();
    }

    @Override
    public Iterator<ICachedMNode> getChildrenBufferIterator() {
        return new BufferIterator();
    }

    @Override
    public Iterator<ICachedMNode> getNewChildBufferIterator() {
        return this.getNewChildBuffer().values().iterator();
    }

    @Override
    public Map<String, ICachedMNode> getChildCache() {
        return this.childCache == null ? Collections.emptyMap() : this.childCache;
    }

    @Override
    public Map<String, ICachedMNode> getNewChildBuffer() {
        return this.newChildBuffer == null ? Collections.emptyMap() : this.newChildBuffer;
    }

    @Override
    public Map<String, ICachedMNode> getUpdatedChildBuffer() {
        return this.updatedChildBuffer == null ? Collections.emptyMap() : this.updatedChildBuffer;
    }

    @Override
    public synchronized void loadChildrenFromDisk(Map<String, ICachedMNode> children) {
        if (this.childCache == null) {
            this.childCache = new ConcurrentHashMap<String, ICachedMNode>();
        }
        this.childCache.putAll(children);
    }

    @Override
    public synchronized void addChildToCache(ICachedMNode node) {
        String name = node.getName();
        if (this.containsKey(name)) {
            return;
        }
        if (this.childCache == null) {
            this.childCache = new ConcurrentHashMap<String, ICachedMNode>();
        }
        this.childCache.put(name, node);
    }

    @Override
    public synchronized void appendMNode(ICachedMNode node) {
        if (this.newChildBuffer == null) {
            this.newChildBuffer = new ConcurrentHashMap<String, ICachedMNode>();
        }
        this.newChildBuffer.put(node.getName(), node);
    }

    @Override
    public synchronized void updateMNode(String name) {
        ICachedMNode node = this.removeFromMap(this.childCache, name);
        if (node != null) {
            if (this.updatedChildBuffer == null) {
                this.updatedChildBuffer = new ConcurrentHashMap<String, ICachedMNode>();
            }
            this.updatedChildBuffer.put(name, node);
        }
    }

    @Override
    public synchronized void moveMNodeToCache(String name) {
        ICachedMNode node = this.removeFromMap(this.newChildBuffer, name);
        if (node == null) {
            node = this.removeFromMap(this.updatedChildBuffer, name);
        }
        if (this.childCache == null) {
            this.childCache = new ConcurrentHashMap<String, ICachedMNode>();
        }
        this.childCache.put(name, node);
    }

    @Override
    public synchronized void evictMNode(String name) {
        this.removeFromMap(this.childCache, name);
    }

    public synchronized String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("CachedMNodeContainer:{");
        builder.append("childCache:[");
        for (ICachedMNode node : this.getValues(this.childCache)) {
            builder.append(node.getName()).append(",");
        }
        builder.append("];");
        builder.append("newChildBuffer:[");
        for (ICachedMNode node : this.getValues(this.newChildBuffer)) {
            builder.append(node.getName()).append(",");
        }
        builder.append("];");
        builder.append("updateChildBuffer:[");
        for (ICachedMNode node : this.getValues(this.updatedChildBuffer)) {
            builder.append(node.getName()).append(",");
        }
        builder.append("];");
        builder.append("}");
        return builder.toString();
    }

    private static class EmptyContainer
    extends AbstractMap<String, ICachedMNode>
    implements IMNodeContainer<ICachedMNode> {
        private EmptyContainer() {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean containsKey(Object key) {
            return false;
        }

        @Override
        public boolean containsValue(Object value) {
            return false;
        }

        @Override
        public ICachedMNode get(Object key) {
            return null;
        }

        @Override
        @NotNull
        public Set<String> keySet() {
            return Collections.emptySet();
        }

        @Override
        @NotNull
        public Collection<ICachedMNode> values() {
            return Collections.emptySet();
        }

        @Override
        @NotNull
        public Set<Map.Entry<String, ICachedMNode>> entrySet() {
            return Collections.emptySet();
        }

        @Override
        public boolean equals(Object o) {
            return o == this;
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }
    }

    private class BufferIterator
    implements Iterator<ICachedMNode> {
        Iterator<ICachedMNode> iterator;
        Iterator<ICachedMNode> newBufferIterator;
        Iterator<ICachedMNode> updateBufferIterator;
        byte status = 0;

        BufferIterator() {
            this.newBufferIterator = CachedMNodeContainer.this.getNewChildBuffer().values().iterator();
            this.updateBufferIterator = CachedMNodeContainer.this.getUpdatedChildBuffer().values().iterator();
            this.iterator = this.newBufferIterator;
        }

        @Override
        public boolean hasNext() {
            if (this.iterator.hasNext()) {
                return true;
            }
            while (!this.iterator.hasNext()) {
                if (this.changeStatus()) continue;
                return false;
            }
            return true;
        }

        @Override
        public ICachedMNode next() {
            return this.iterator.next();
        }

        private boolean changeStatus() {
            if (this.status == 0) {
                this.iterator = this.updateBufferIterator;
                this.status = 1;
                return true;
            }
            return false;
        }
    }

    private class CachedMNodeContainerIterator
    implements Iterator<ICachedMNode> {
        Iterator<ICachedMNode> iterator;
        byte status = 0;

        CachedMNodeContainerIterator() {
            this.iterator = CachedMNodeContainer.this.getChildCache().values().iterator();
        }

        @Override
        public boolean hasNext() {
            if (this.iterator.hasNext()) {
                return true;
            }
            while (!this.iterator.hasNext()) {
                if (this.changeStatus()) continue;
                return false;
            }
            return true;
        }

        @Override
        public ICachedMNode next() {
            return this.iterator.next();
        }

        private boolean changeStatus() {
            switch (this.status) {
                case 0: {
                    this.iterator = CachedMNodeContainer.this.getNewChildBuffer().values().iterator();
                    this.status = 1;
                    return true;
                }
                case 1: {
                    this.iterator = CachedMNodeContainer.this.getUpdatedChildBuffer().values().iterator();
                    this.status = (byte)2;
                    return true;
                }
            }
            return false;
        }
    }
}

