/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.schemaengine.schemaregion.view;

import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.exception.metadata.view.UnsupportedViewException;
import org.apache.iotdb.db.exception.metadata.view.ViewContainsAggregationException;
import org.apache.iotdb.db.queryengine.plan.expression.Expression;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.TimeSeriesOperand;
import org.apache.iotdb.db.queryengine.plan.expression.visitor.CollectAggregationExpressionsVisitor;
import org.apache.iotdb.db.schemaengine.schemaregion.view.ViewPathType;
import org.apache.iotdb.tsfile.utils.Pair;

public class ViewPaths {
    public ViewPathType viewPathType = ViewPathType.FULL_PATH_LIST;
    public List<PartialPath> fullPathList = null;
    public PartialPath prefixOfPathsGroup = null;
    public List<PartialPath> suffixOfPathsGroup = null;
    public List<Expression> expressionsList = null;

    public void addPath(PartialPath path) {
        if (this.fullPathList == null) {
            this.fullPathList = new ArrayList<PartialPath>();
            this.fullPathList.add(path);
        } else {
            this.fullPathList.add(path);
        }
    }

    public void setFullPathList(List<PartialPath> pathList) {
        this.fullPathList = pathList;
    }

    public void setPrefixOfPathsGroup(PartialPath path) {
        this.prefixOfPathsGroup = path;
    }

    public void setSuffixOfPathsGroup(List<PartialPath> pathList) {
        this.suffixOfPathsGroup = pathList;
    }

    public void setViewPathType(ViewPathType viewPathType) {
        this.viewPathType = viewPathType;
    }

    public void generateFullPathsFromPathsGroup() {
        if (this.prefixOfPathsGroup != null && this.suffixOfPathsGroup != null) {
            this.fullPathList = new ArrayList<PartialPath>();
            for (PartialPath suffixPath : this.suffixOfPathsGroup) {
                PartialPath pathToAdd = this.prefixOfPathsGroup.concatPath(suffixPath);
                this.addPath(pathToAdd);
            }
        }
    }

    public void generateExpressionsIfNecessary() {
        if (this.viewPathType == ViewPathType.FULL_PATH_LIST || this.viewPathType == ViewPathType.PATHS_GROUP) {
            if (this.fullPathList != null) {
                this.expressionsList = new ArrayList<Expression>();
                for (PartialPath path : this.fullPathList) {
                    TimeSeriesOperand tsExpression = new TimeSeriesOperand(path);
                    this.expressionsList.add(tsExpression);
                }
            }
        } else if (this.viewPathType == ViewPathType.QUERY_STATEMENT || this.viewPathType == ViewPathType.BATCH_GENERATION) {
            // empty if block
        }
    }

    public static Pair<Boolean, UnsupportedViewException> checkExpressionList(List<Expression> expressionsList) {
        CollectAggregationExpressionsVisitor collectAggExpVisitor = new CollectAggregationExpressionsVisitor();
        for (Expression expression : expressionsList) {
            List aggList = (List)collectAggExpVisitor.process(expression, null);
            if (aggList.isEmpty()) continue;
            return new Pair((Object)false, (Object)new ViewContainsAggregationException(((Expression)aggList.get(0)).toString()));
        }
        return new Pair((Object)true, null);
    }

    public void setExpressionsList(List<Expression> expressionsList) {
        this.expressionsList = expressionsList;
    }
}

