/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.schemaengine.schemaregion.write.req.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.schemaengine.schemaregion.write.req.ICreateAlignedTimeSeriesPlan;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;

public class CreateAlignedTimeSeriesPlanImpl
implements ICreateAlignedTimeSeriesPlan {
    private PartialPath devicePath;
    private List<String> measurements;
    private List<TSDataType> dataTypes;
    private List<TSEncoding> encodings;
    private List<CompressionType> compressors;
    private List<String> aliasList;
    private List<Map<String, String>> tagsList;
    private List<Map<String, String>> attributesList;
    private List<Long> tagOffsets = null;

    public CreateAlignedTimeSeriesPlanImpl() {
    }

    public CreateAlignedTimeSeriesPlanImpl(PartialPath devicePath, List<String> measurements, List<TSDataType> dataTypes, List<TSEncoding> encodings, List<CompressionType> compressors, List<String> aliasList, List<Map<String, String>> tagsList, List<Map<String, String>> attributesList) {
        this.devicePath = devicePath;
        this.measurements = measurements;
        this.dataTypes = dataTypes;
        this.encodings = encodings;
        this.compressors = compressors;
        this.aliasList = aliasList;
        this.tagsList = tagsList;
        this.attributesList = attributesList;
    }

    public CreateAlignedTimeSeriesPlanImpl(PartialPath devicePath, String measurement, MeasurementSchema schema) {
        this.devicePath = devicePath;
        this.measurements = Collections.singletonList(measurement);
        this.dataTypes = Collections.singletonList(schema.getType());
        this.encodings = Collections.singletonList(schema.getEncodingType());
        this.compressors = Collections.singletonList(schema.getCompressor());
    }

    @Override
    public PartialPath getDevicePath() {
        return this.devicePath;
    }

    @Override
    public void setDevicePath(PartialPath devicePath) {
        this.devicePath = devicePath;
    }

    @Override
    public List<String> getMeasurements() {
        return this.measurements;
    }

    @Override
    public void setMeasurements(List<String> measurements) {
        this.measurements = measurements;
    }

    @Override
    public List<TSDataType> getDataTypes() {
        return this.dataTypes;
    }

    @Override
    public void setDataTypes(List<TSDataType> dataTypes) {
        this.dataTypes = dataTypes;
    }

    @Override
    public List<TSEncoding> getEncodings() {
        return this.encodings;
    }

    @Override
    public void setEncodings(List<TSEncoding> encodings) {
        this.encodings = encodings;
    }

    @Override
    public List<CompressionType> getCompressors() {
        return this.compressors;
    }

    @Override
    public void setCompressors(List<CompressionType> compressors) {
        this.compressors = compressors;
    }

    @Override
    public List<String> getAliasList() {
        return this.aliasList;
    }

    @Override
    public void setAliasList(List<String> aliasList) {
        this.aliasList = aliasList;
    }

    @Override
    public List<Map<String, String>> getTagsList() {
        return this.tagsList;
    }

    @Override
    public void setTagsList(List<Map<String, String>> tagsList) {
        this.tagsList = tagsList;
    }

    @Override
    public List<Map<String, String>> getAttributesList() {
        return this.attributesList;
    }

    @Override
    public void setAttributesList(List<Map<String, String>> attributesList) {
        this.attributesList = attributesList;
    }

    @Override
    public List<Long> getTagOffsets() {
        if (this.tagOffsets == null) {
            this.tagOffsets = new ArrayList<Long>();
            for (int i = 0; i < this.measurements.size(); ++i) {
                this.tagOffsets.add(Long.parseLong("-1"));
            }
        }
        return this.tagOffsets;
    }

    @Override
    public void setTagOffsets(List<Long> tagOffsets) {
        this.tagOffsets = tagOffsets;
    }
}

