/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.schemaengine.template.alter;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.iotdb.db.schemaengine.template.alter.TemplateAlterInfo;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class TemplateExtendInfo
extends TemplateAlterInfo {
    private List<String> measurements;
    private List<TSDataType> dataTypes;
    private List<TSEncoding> encodings;
    private List<CompressionType> compressors;

    public TemplateExtendInfo() {
    }

    public TemplateExtendInfo(String templateName) {
        this.templateName = templateName;
    }

    public TemplateExtendInfo(String templateName, List<String> measurements, List<TSDataType> dataTypes, List<TSEncoding> encodings, List<CompressionType> compressors) {
        this.templateName = templateName;
        this.measurements = measurements;
        this.dataTypes = dataTypes;
        this.encodings = encodings;
        this.compressors = compressors;
    }

    @Override
    public String getTemplateName() {
        return this.templateName;
    }

    public List<String> getMeasurements() {
        return this.measurements;
    }

    public List<TSDataType> getDataTypes() {
        return this.dataTypes;
    }

    public List<TSEncoding> getEncodings() {
        return this.encodings;
    }

    public List<CompressionType> getCompressors() {
        return this.compressors;
    }

    public void addMeasurement(String measurement, TSDataType dataType, TSEncoding encoding, CompressionType compressionType) {
        if (this.measurements == null) {
            this.measurements = new ArrayList<String>();
        }
        this.measurements.add(measurement);
        if (this.dataTypes == null) {
            this.dataTypes = new ArrayList<TSDataType>();
        }
        this.dataTypes.add(dataType);
        if (this.encodings == null) {
            this.encodings = new ArrayList<TSEncoding>();
        }
        this.encodings.add(encoding);
        if (this.compressors == null) {
            this.compressors = new ArrayList<CompressionType>();
        }
        this.compressors.add(compressionType);
    }

    public String getFirstDuplicateMeasurement() {
        if (this.measurements != null) {
            HashSet<String> set = new HashSet<String>();
            for (String measurement : this.measurements) {
                if (set.contains(measurement)) {
                    return measurement;
                }
                set.add(measurement);
            }
        }
        return null;
    }

    public TemplateExtendInfo deduplicate() {
        if (this.measurements == null || this.measurements.isEmpty()) {
            return new TemplateExtendInfo();
        }
        HashSet<String> set = new HashSet<String>();
        TemplateExtendInfo result = new TemplateExtendInfo();
        for (int i = 0; i < this.measurements.size(); ++i) {
            if (set.contains(this.measurements.get(i))) continue;
            set.add(this.measurements.get(i));
            result.addMeasurement(this.measurements.get(i), this.dataTypes.get(i), this.encodings.get(i), this.compressors.get(i));
        }
        return result;
    }

    public List<String> updateAsDifferenceAndGetIntersection(Set<String> targetMeasurementSet) {
        ArrayList<String> removedMeasurements = new ArrayList<String>();
        ArrayList<String> updatedMeasurements = new ArrayList<String>();
        ArrayList<TSDataType> updatedDataTypes = new ArrayList<TSDataType>();
        ArrayList<TSEncoding> updatedEncodings = this.encodings == null ? null : new ArrayList<TSEncoding>();
        ArrayList<CompressionType> updatedCompressors = this.compressors == null ? null : new ArrayList<CompressionType>();
        for (int i = 0; i < this.measurements.size(); ++i) {
            if (targetMeasurementSet.contains(this.measurements.get(i))) {
                removedMeasurements.add(this.measurements.get(i));
                continue;
            }
            updatedMeasurements.add(this.measurements.get(i));
            updatedDataTypes.add(this.dataTypes.get(i));
            if (this.encodings != null) {
                updatedEncodings.add(this.encodings.get(i));
            }
            if (this.compressors == null) continue;
            updatedCompressors.add(this.compressors.get(i));
        }
        this.measurements = updatedMeasurements;
        this.dataTypes = updatedDataTypes;
        this.encodings = updatedEncodings;
        this.compressors = updatedCompressors;
        return removedMeasurements;
    }

    public boolean isEmpty() {
        return this.measurements == null || this.measurements.isEmpty();
    }

    @Override
    public void serialize(OutputStream outputStream) throws IOException {
        super.serialize(outputStream);
        ReadWriteIOUtils.write((int)this.measurements.size(), (OutputStream)outputStream);
        for (String measurement : this.measurements) {
            ReadWriteIOUtils.write((String)measurement, (OutputStream)outputStream);
        }
        for (TSDataType dataType : this.dataTypes) {
            ReadWriteIOUtils.write((TSDataType)dataType, (OutputStream)outputStream);
        }
        if (this.encodings == null || this.encodings.isEmpty()) {
            ReadWriteIOUtils.write((byte)0, (OutputStream)outputStream);
        } else {
            ReadWriteIOUtils.write((byte)1, (OutputStream)outputStream);
            for (TSEncoding encoding : this.encodings) {
                ReadWriteIOUtils.write((TSEncoding)encoding, (OutputStream)outputStream);
            }
        }
        if (this.compressors == null || this.compressors.isEmpty()) {
            ReadWriteIOUtils.write((byte)0, (OutputStream)outputStream);
        } else {
            ReadWriteIOUtils.write((byte)1, (OutputStream)outputStream);
            for (CompressionType compressionType : this.compressors) {
                ReadWriteIOUtils.write((CompressionType)compressionType, (OutputStream)outputStream);
            }
        }
    }

    @Override
    public void deserialize(ByteBuffer buffer) {
        int i;
        super.deserialize(buffer);
        int size = ReadWriteIOUtils.readInt((ByteBuffer)buffer);
        this.measurements = new ArrayList<String>(size);
        for (i = 0; i < size; ++i) {
            this.measurements.add(ReadWriteIOUtils.readString((ByteBuffer)buffer));
        }
        this.dataTypes = new ArrayList<TSDataType>(size);
        for (i = 0; i < size; ++i) {
            this.dataTypes.add(ReadWriteIOUtils.readDataType((ByteBuffer)buffer));
        }
        if (ReadWriteIOUtils.readByte((ByteBuffer)buffer) == 1) {
            this.encodings = new ArrayList<TSEncoding>(size);
            for (i = 0; i < size; ++i) {
                this.encodings.add(ReadWriteIOUtils.readEncoding((ByteBuffer)buffer));
            }
        }
        if (ReadWriteIOUtils.readByte((ByteBuffer)buffer) == 1) {
            this.compressors = new ArrayList<CompressionType>(size);
            for (i = 0; i < size; ++i) {
                this.compressors.add(ReadWriteIOUtils.readCompressionType((ByteBuffer)buffer));
            }
        }
    }
}

