/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.service.metrics;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iotdb.commons.service.metric.enums.Metric;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.db.storageengine.dataregion.compaction.constant.CompactionTaskStatus;
import org.apache.iotdb.db.storageengine.dataregion.compaction.constant.CompactionTaskType;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.CompactionTaskSummary;
import org.apache.iotdb.db.storageengine.dataregion.compaction.schedule.CompactionScheduleSummary;
import org.apache.iotdb.db.storageengine.dataregion.compaction.schedule.CompactionTaskManager;
import org.apache.iotdb.db.storageengine.dataregion.compaction.schedule.constant.CompactionIoDataType;
import org.apache.iotdb.db.storageengine.dataregion.compaction.schedule.constant.CompactionType;
import org.apache.iotdb.db.storageengine.rescon.memory.SystemInfo;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.impl.DoNothingMetricManager;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.type.Counter;
import org.apache.iotdb.metrics.type.Gauge;
import org.apache.iotdb.metrics.type.Histogram;
import org.apache.iotdb.metrics.type.Timer;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;

public class CompactionMetrics
implements IMetricSet {
    private static final String NOT_ALIGNED = "not_aligned";
    private static final String ALIGNED = "aligned";
    private static final String METADATA = "metadata";
    private static final List<String> TYPES = Arrays.asList("aligned", "not_aligned");
    private static final CompactionMetrics INSTANCE = new CompactionMetrics();
    private long lastUpdateTime = 0L;
    private static final long UPDATE_INTERVAL = 10000L;
    private final AtomicInteger waitingSeqInnerCompactionTaskNum = new AtomicInteger(0);
    private final AtomicInteger waitingUnseqInnerCompactionTaskNum = new AtomicInteger(0);
    private final AtomicInteger waitingCrossCompactionTaskNum = new AtomicInteger(0);
    private final AtomicInteger waitingInsertionCompactionTaskNum = new AtomicInteger(0);
    private final AtomicInteger runningSeqInnerCompactionTaskNum = new AtomicInteger(0);
    private final AtomicInteger runningUnseqInnerCompactionTaskNum = new AtomicInteger(0);
    private final AtomicInteger runningCrossCompactionTaskNum = new AtomicInteger(0);
    private final AtomicInteger runningInsertionCompactionTaskNum = new AtomicInteger(0);
    private final AtomicInteger finishSeqInnerCompactionTaskNum = new AtomicInteger(0);
    private final AtomicInteger finishUnseqInnerCompactionTaskNum = new AtomicInteger(0);
    private final AtomicInteger finishCrossCompactionTaskNum = new AtomicInteger(0);
    private final AtomicInteger finishInsertionCompactionTaskNum = new AtomicInteger(0);
    private final Map<String, Counter[]> writeCounters = new ConcurrentHashMap<String, Counter[]>();
    private final Map<String, Counter[]> readCounters = new ConcurrentHashMap<String, Counter[]>();
    private Counter totalCompactionWriteInfoCounter = DoNothingMetricManager.DO_NOTHING_COUNTER;
    private Counter totalCompactionReadInfoCounter = DoNothingMetricManager.DO_NOTHING_COUNTER;
    private Counter totalCompactedPointCounter = DoNothingMetricManager.DO_NOTHING_COUNTER;
    private Counter totalCompactedChunkCounter = DoNothingMetricManager.DO_NOTHING_COUNTER;
    private Counter totalDirectlyFlushChunkCounter = DoNothingMetricManager.DO_NOTHING_COUNTER;
    private Counter totalDeserializedChunkCounter = DoNothingMetricManager.DO_NOTHING_COUNTER;
    private Counter totalMergedChunkCounter = DoNothingMetricManager.DO_NOTHING_COUNTER;
    private Timer seqCompactionCostTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer unSeqCompactionCostTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer crossCompactionCostTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer insertionCompactionCostTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Histogram seqInnerSpaceCompactionTaskMemory = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;
    private Histogram unseqInnerSpaceCompactionTaskMemory = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;
    private Histogram crossSpaceCompactionTaskMemory = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;
    private Gauge seqInnerSpaceCompactionTaskSelectedNum = DoNothingMetricManager.DO_NOTHING_GAUGE;
    private Gauge unseqInnerSpaceCompactionTaskSelectedNum = DoNothingMetricManager.DO_NOTHING_GAUGE;
    private Gauge crossInnerSpaceCompactionTaskSelectedNum = DoNothingMetricManager.DO_NOTHING_GAUGE;
    private Gauge insertionCrossSpaceCompactionTaskSelectedNum = DoNothingMetricManager.DO_NOTHING_GAUGE;
    private Histogram seqSpaceCompactionTaskSelectionTimeCost = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;
    private Histogram unseqSpaceCompactionTaskSelectionTimeCost = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;
    private Histogram crossSpaceCompactionTaskSelectionTimeCost = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;
    private Histogram insertionCrossSpaceCompactionTaskSelectionTimeCost = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;
    private Histogram seqInnerSpaceCompactionTaskSelectedFileNum = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;
    private Histogram unseqInnerSpaceCompactionTaskSelectedFileNum = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;
    private Histogram crossSpaceCompactionTaskSelectedFileNum = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;

    private CompactionMetrics() {
        for (String type : TYPES) {
            this.readCounters.put(type, new Counter[]{DoNothingMetricManager.DO_NOTHING_COUNTER, DoNothingMetricManager.DO_NOTHING_COUNTER, DoNothingMetricManager.DO_NOTHING_COUNTER});
            this.writeCounters.put(type, new Counter[]{DoNothingMetricManager.DO_NOTHING_COUNTER, DoNothingMetricManager.DO_NOTHING_COUNTER, DoNothingMetricManager.DO_NOTHING_COUNTER});
        }
    }

    private void bindWriteInfo(AbstractMetricService metricService) {
        for (CompactionType compactionType : CompactionType.values()) {
            this.writeCounters.put(compactionType.toString(), new Counter[]{metricService.getOrCreateCounter(Metric.DATA_WRITTEN.toString(), MetricLevel.IMPORTANT, new String[]{Tag.TYPE.toString(), compactionType.toString(), Tag.NAME.toString(), NOT_ALIGNED}), metricService.getOrCreateCounter(Metric.DATA_WRITTEN.toString(), MetricLevel.IMPORTANT, new String[]{Tag.TYPE.toString(), compactionType.toString(), Tag.NAME.toString(), ALIGNED}), metricService.getOrCreateCounter(Metric.DATA_WRITTEN.toString(), MetricLevel.IMPORTANT, new String[]{Tag.TYPE.toString(), compactionType.toString(), Tag.NAME.toString(), METADATA})});
        }
        this.totalCompactionWriteInfoCounter = metricService.getOrCreateCounter(Metric.DATA_WRITTEN.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), "compaction", Tag.TYPE.toString(), "total"});
    }

    private void unbindWriteInfo(AbstractMetricService metricService) {
        for (CompactionType compactionType : CompactionType.values()) {
            metricService.remove(MetricType.COUNTER, Metric.DATA_WRITTEN.toString(), new String[]{Tag.TYPE.toString(), compactionType.toString(), Tag.NAME.toString(), NOT_ALIGNED});
            metricService.remove(MetricType.COUNTER, Metric.DATA_WRITTEN.toString(), new String[]{Tag.TYPE.toString(), compactionType.toString(), Tag.NAME.toString(), ALIGNED});
            metricService.remove(MetricType.COUNTER, Metric.DATA_WRITTEN.toString(), new String[]{Tag.TYPE.toString(), compactionType.toString(), Tag.NAME.toString(), METADATA});
        }
        metricService.remove(MetricType.COUNTER, Metric.DATA_WRITTEN.toString(), new String[]{Tag.NAME.toString(), "compaction", Tag.TYPE.toString(), "total"});
    }

    public void recordWriteInfo(CompactionType compactionType, CompactionIoDataType dataType, long byteNum) {
        Counter[] counters = this.writeCounters.get(compactionType.toString());
        if (counters != null) {
            counters[dataType.getValue()].inc(byteNum);
        }
        this.totalCompactionWriteInfoCounter.inc(byteNum);
    }

    private void bindReadInfo(AbstractMetricService metricService) {
        for (CompactionType compactionType : CompactionType.values()) {
            this.readCounters.put(compactionType.toString(), new Counter[]{metricService.getOrCreateCounter(Metric.DATA_READ.toString(), MetricLevel.IMPORTANT, new String[]{Tag.TYPE.toString(), compactionType.toString(), Tag.NAME.toString(), NOT_ALIGNED}), metricService.getOrCreateCounter(Metric.DATA_READ.toString(), MetricLevel.IMPORTANT, new String[]{Tag.TYPE.toString(), compactionType.toString(), Tag.NAME.toString(), ALIGNED}), metricService.getOrCreateCounter(Metric.DATA_READ.toString(), MetricLevel.IMPORTANT, new String[]{Tag.TYPE.toString(), compactionType.toString(), Tag.NAME.toString(), METADATA})});
        }
        this.totalCompactionReadInfoCounter = metricService.getOrCreateCounter(Metric.DATA_READ.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), "compaction"});
    }

    private void unbindReadInfo(AbstractMetricService metricService) {
        for (CompactionType compactionType : CompactionType.values()) {
            metricService.remove(MetricType.COUNTER, Metric.DATA_READ.toString(), new String[]{Tag.TYPE.toString(), compactionType.toString(), Tag.NAME.toString(), NOT_ALIGNED});
            metricService.remove(MetricType.COUNTER, Metric.DATA_READ.toString(), new String[]{Tag.TYPE.toString(), compactionType.toString(), Tag.NAME.toString(), ALIGNED});
            metricService.remove(MetricType.COUNTER, Metric.DATA_READ.toString(), new String[]{Tag.TYPE.toString(), compactionType.toString(), Tag.NAME.toString(), METADATA});
        }
        metricService.remove(MetricType.COUNTER, Metric.DATA_READ.toString(), new String[]{Tag.NAME.toString(), "compaction"});
    }

    public void recordReadInfo(CompactionType compactionType, CompactionIoDataType dataType, long byteNum) {
        Counter[] counters = this.readCounters.get(compactionType.toString());
        if (counters != null) {
            counters[dataType.getValue()].inc(byteNum);
        }
        this.totalCompactionReadInfoCounter.inc(byteNum);
    }

    private void bindPerformanceInfo(AbstractMetricService metricService) {
        this.totalCompactedPointCounter = metricService.getOrCreateCounter("compacted_point_num", MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), "compaction"});
        this.totalCompactedChunkCounter = metricService.getOrCreateCounter("compacted_chunk_num", MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), "compaction"});
        this.totalDirectlyFlushChunkCounter = metricService.getOrCreateCounter("directly_flush_chunk_num", MetricLevel.NORMAL, new String[]{Tag.NAME.toString(), "compaction"});
        this.totalDeserializedChunkCounter = metricService.getOrCreateCounter("deserialized_chunk_num", MetricLevel.NORMAL, new String[]{Tag.NAME.toString(), "compaction"});
        this.totalMergedChunkCounter = metricService.getOrCreateCounter("merged_chunk_num", MetricLevel.NORMAL, new String[]{Tag.NAME.toString(), "compaction"});
    }

    private void unbindPerformanceInfo(AbstractMetricService metricService) {
        metricService.remove(MetricType.COUNTER, "compacted_point_num", new String[]{Tag.NAME.toString(), "compaction"});
        metricService.remove(MetricType.COUNTER, "compacted_chunk_num", new String[]{Tag.NAME.toString(), "compaction"});
        metricService.remove(MetricType.COUNTER, "directly_flush_chunk_num", new String[]{Tag.NAME.toString(), "compaction"});
        metricService.remove(MetricType.COUNTER, "deserialized_chunk_num", new String[]{Tag.NAME.toString(), "compaction"});
        metricService.remove(MetricType.COUNTER, "merged_chunk_num", new String[]{Tag.NAME.toString(), "compaction"});
    }

    public void recordSummaryInfo(CompactionTaskSummary summary) {
        this.totalCompactedPointCounter.inc(summary.getProcessPointNum());
        this.totalCompactedChunkCounter.inc((long)summary.getProcessChunkNum());
        this.totalDirectlyFlushChunkCounter.inc((long)summary.getDirectlyFlushChunkNum());
        this.totalDeserializedChunkCounter.inc((long)summary.getDeserializeChunkCount());
        this.totalMergedChunkCounter.inc((long)summary.getMergedChunkNum());
    }

    public void recordTaskFinishOrAbort(CompactionTaskType type, long timeCost) {
        switch (type) {
            case CROSS: {
                this.finishCrossCompactionTaskNum.incrementAndGet();
                this.crossCompactionCostTimer.update(timeCost, TimeUnit.MILLISECONDS);
                break;
            }
            case INSERTION: {
                this.finishInsertionCompactionTaskNum.incrementAndGet();
                this.insertionCompactionCostTimer.update(timeCost, TimeUnit.MILLISECONDS);
                break;
            }
            case INNER_SEQ: {
                this.finishSeqInnerCompactionTaskNum.incrementAndGet();
                this.seqCompactionCostTimer.update(timeCost, TimeUnit.MILLISECONDS);
                break;
            }
            case INNER_UNSEQ: {
                this.finishUnseqInnerCompactionTaskNum.incrementAndGet();
                this.unSeqCompactionCostTimer.update(timeCost, TimeUnit.MILLISECONDS);
            }
        }
    }

    private void bindTaskInfo(AbstractMetricService metricService) {
        this.seqCompactionCostTimer = metricService.getOrCreateTimer(Metric.COST_TASK.toString(), MetricLevel.CORE, new String[]{Tag.NAME.toString(), "inner_seq_compaction"});
        this.unSeqCompactionCostTimer = metricService.getOrCreateTimer(Metric.COST_TASK.toString(), MetricLevel.CORE, new String[]{Tag.NAME.toString(), "inner_unseq_compaction"});
        this.crossCompactionCostTimer = metricService.getOrCreateTimer(Metric.COST_TASK.toString(), MetricLevel.CORE, new String[]{Tag.NAME.toString(), "cross_compaction"});
        this.insertionCompactionCostTimer = metricService.getOrCreateTimer(Metric.COST_TASK.toString(), MetricLevel.CORE, new String[]{Tag.NAME.toString(), "insertion_compaction"});
        metricService.createAutoGauge(Metric.QUEUE.toString(), MetricLevel.IMPORTANT, (Object)this, metrics -> {
            this.updateCompactionTaskInfo();
            return this.waitingCrossCompactionTaskNum.get();
        }, new String[]{Tag.NAME.toString(), "compaction_cross", Tag.STATUS.toString(), "waiting"});
        metricService.createAutoGauge(Metric.QUEUE.toString(), MetricLevel.IMPORTANT, (Object)this, metrics -> {
            this.updateCompactionTaskInfo();
            return this.waitingInsertionCompactionTaskNum.get();
        }, new String[]{Tag.NAME.toString(), "compaction_insertion", Tag.STATUS.toString(), "waiting"});
        metricService.createAutoGauge(Metric.QUEUE.toString(), MetricLevel.IMPORTANT, (Object)this, metrics -> {
            this.updateCompactionTaskInfo();
            return this.waitingSeqInnerCompactionTaskNum.get();
        }, new String[]{Tag.NAME.toString(), "compaction_inner_seq", Tag.STATUS.toString(), "waiting"});
        metricService.createAutoGauge(Metric.QUEUE.toString(), MetricLevel.IMPORTANT, (Object)this, metrics -> {
            this.updateCompactionTaskInfo();
            return this.waitingUnseqInnerCompactionTaskNum.get();
        }, new String[]{Tag.NAME.toString(), "compaction_inner_unseq", Tag.STATUS.toString(), "waiting"});
        metricService.createAutoGauge(Metric.QUEUE.toString(), MetricLevel.IMPORTANT, (Object)this, metrics -> {
            this.updateCompactionTaskInfo();
            return this.runningCrossCompactionTaskNum.get();
        }, new String[]{Tag.NAME.toString(), "compaction_cross", Tag.STATUS.toString(), "running"});
        metricService.createAutoGauge(Metric.QUEUE.toString(), MetricLevel.IMPORTANT, (Object)this, metrics -> {
            this.updateCompactionTaskInfo();
            return this.runningInsertionCompactionTaskNum.get();
        }, new String[]{Tag.NAME.toString(), "compaction_insertion", Tag.STATUS.toString(), "running"});
        metricService.createAutoGauge(Metric.QUEUE.toString(), MetricLevel.IMPORTANT, (Object)this, metrics -> {
            this.updateCompactionTaskInfo();
            return this.runningSeqInnerCompactionTaskNum.get();
        }, new String[]{Tag.NAME.toString(), "compaction_inner_seq", Tag.STATUS.toString(), "running"});
        metricService.createAutoGauge(Metric.QUEUE.toString(), MetricLevel.IMPORTANT, (Object)this, metrics -> {
            this.updateCompactionTaskInfo();
            return this.runningUnseqInnerCompactionTaskNum.get();
        }, new String[]{Tag.NAME.toString(), "compaction_inner_unseq", Tag.STATUS.toString(), "running"});
        metricService.createAutoGauge(Metric.COMPACTION_TASK_COUNT.toString(), MetricLevel.IMPORTANT, (Object)this, metrics -> {
            this.updateCompactionTaskInfo();
            return this.finishSeqInnerCompactionTaskNum.get();
        }, new String[]{Tag.NAME.toString(), "inner_seq"});
        metricService.createAutoGauge(Metric.COMPACTION_TASK_COUNT.toString(), MetricLevel.IMPORTANT, (Object)this, metrics -> {
            this.updateCompactionTaskInfo();
            return this.finishUnseqInnerCompactionTaskNum.get();
        }, new String[]{Tag.NAME.toString(), "inner_unseq"});
        metricService.createAutoGauge(Metric.COMPACTION_TASK_COUNT.toString(), MetricLevel.IMPORTANT, (Object)this, metrics -> {
            this.updateCompactionTaskInfo();
            return this.finishCrossCompactionTaskNum.get();
        }, new String[]{Tag.NAME.toString(), "cross"});
        metricService.createAutoGauge(Metric.COMPACTION_TASK_COUNT.toString(), MetricLevel.IMPORTANT, (Object)this, metrics -> {
            this.updateCompactionTaskInfo();
            return this.finishInsertionCompactionTaskNum.get();
        }, new String[]{Tag.NAME.toString(), "insertion"});
    }

    private void unbindTaskInfo(AbstractMetricService metricService) {
        this.seqCompactionCostTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.unSeqCompactionCostTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.crossCompactionCostTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        metricService.remove(MetricType.TIMER, Metric.COST_TASK.toString(), new String[]{Tag.NAME.toString(), "inner_seq_compaction"});
        metricService.remove(MetricType.TIMER, Metric.COST_TASK.toString(), new String[]{Tag.NAME.toString(), "inner_unseq_compaction"});
        metricService.remove(MetricType.TIMER, Metric.COST_TASK.toString(), new String[]{Tag.NAME.toString(), "cross_compaction"});
        metricService.remove(MetricType.TIMER, Metric.COST_TASK.toString(), new String[]{Tag.NAME.toString(), "insertion_compaction"});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.QUEUE.toString(), new String[]{Tag.NAME.toString(), "compaction_cross", Tag.STATUS.toString(), "waiting"});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.QUEUE.toString(), new String[]{Tag.NAME.toString(), "compaction_insertion", Tag.STATUS.toString(), "waiting"});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.QUEUE.toString(), new String[]{Tag.NAME.toString(), "compaction_inner_seq", Tag.STATUS.toString(), "waiting"});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.QUEUE.toString(), new String[]{Tag.NAME.toString(), "compaction_inner_unseq", Tag.STATUS.toString(), "waiting"});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.QUEUE.toString(), new String[]{Tag.NAME.toString(), "compaction_cross", Tag.STATUS.toString(), "running"});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.QUEUE.toString(), new String[]{Tag.NAME.toString(), "compaction_insertion", Tag.STATUS.toString(), "running"});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.QUEUE.toString(), new String[]{Tag.NAME.toString(), "compaction_inner_seq", Tag.STATUS.toString(), "running"});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.QUEUE.toString(), new String[]{Tag.NAME.toString(), "compaction_inner_unseq", Tag.STATUS.toString(), "running"});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.COMPACTION_TASK_COUNT.toString(), new String[]{Tag.NAME.toString(), "inner_seq"});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.COMPACTION_TASK_COUNT.toString(), new String[]{Tag.NAME.toString(), "inner_unseq"});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.COMPACTION_TASK_COUNT.toString(), new String[]{Tag.NAME.toString(), "cross"});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.COMPACTION_TASK_COUNT.toString(), new String[]{Tag.NAME.toString(), "insertion"});
    }

    public void updateCompactionMemoryMetrics(CompactionTaskType taskType, long memory) {
        switch (taskType) {
            case INNER_SEQ: {
                this.seqInnerSpaceCompactionTaskMemory.update(memory);
                break;
            }
            case INNER_UNSEQ: {
                this.unseqInnerSpaceCompactionTaskMemory.update(memory);
                break;
            }
            case CROSS: {
                this.crossSpaceCompactionTaskMemory.update(memory);
                break;
            }
        }
    }

    private void bindCompactionTaskMemory(AbstractMetricService metricService) {
        this.seqInnerSpaceCompactionTaskMemory = metricService.getOrCreateHistogram(Metric.COMPACTION_TASK_MEMORY.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), "seq"});
        this.unseqInnerSpaceCompactionTaskMemory = metricService.getOrCreateHistogram(Metric.COMPACTION_TASK_MEMORY.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), "unseq"});
        this.crossSpaceCompactionTaskMemory = metricService.getOrCreateHistogram(Metric.COMPACTION_TASK_MEMORY.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), "cross"});
        metricService.createAutoGauge(Metric.COMPACTION_TASK_MEMORY_DISTRIBUTION.toString(), MetricLevel.IMPORTANT, (Object)this, metrics -> SystemInfo.getInstance().getCompactionMemoryCost().get(), new String[]{Tag.NAME.toString(), "total_usage"});
        metricService.createAutoGauge(Metric.COMPACTION_TASK_MEMORY_DISTRIBUTION.toString(), MetricLevel.IMPORTANT, (Object)this, metrics -> SystemInfo.getInstance().getSeqInnerSpaceCompactionMemoryCost().get(), new String[]{Tag.NAME.toString(), "seq"});
        metricService.createAutoGauge(Metric.COMPACTION_TASK_MEMORY_DISTRIBUTION.toString(), MetricLevel.IMPORTANT, (Object)this, metrics -> SystemInfo.getInstance().getUnseqInnerSpaceCompactionMemoryCost().get(), new String[]{Tag.NAME.toString(), "unseq"});
        metricService.createAutoGauge(Metric.COMPACTION_TASK_MEMORY_DISTRIBUTION.toString(), MetricLevel.IMPORTANT, (Object)this, metrics -> SystemInfo.getInstance().getCrossSpaceCompactionMemoryCost().get(), new String[]{Tag.NAME.toString(), "cross"});
    }

    private void unbindCompactionTaskMemory(AbstractMetricService metricService) {
        metricService.remove(MetricType.HISTOGRAM, Metric.COMPACTION_TASK_MEMORY.toString(), new String[]{Tag.NAME.toString(), "seq"});
        metricService.remove(MetricType.HISTOGRAM, Metric.COMPACTION_TASK_MEMORY.toString(), new String[]{Tag.NAME.toString(), "unseq"});
        metricService.remove(MetricType.HISTOGRAM, Metric.COMPACTION_TASK_MEMORY.toString(), new String[]{Tag.NAME.toString(), "cross"});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.COMPACTION_TASK_MEMORY_DISTRIBUTION.toString(), new String[]{Tag.NAME.toString(), "total"});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.COMPACTION_TASK_MEMORY_DISTRIBUTION.toString(), new String[]{Tag.NAME.toString(), "cross"});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.COMPACTION_TASK_MEMORY_DISTRIBUTION.toString(), new String[]{Tag.NAME.toString(), "seq"});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.COMPACTION_TASK_MEMORY_DISTRIBUTION.toString(), new String[]{Tag.NAME.toString(), "unseq"});
    }

    public void updateCompactionTaskSelectionNum(CompactionScheduleSummary summary) {
        this.seqInnerSpaceCompactionTaskSelectedNum.set((long)summary.getSubmitSeqInnerSpaceCompactionTaskNum());
        this.unseqInnerSpaceCompactionTaskSelectedNum.set((long)summary.getSubmitUnseqInnerSpaceCompactionTaskNum());
        this.crossInnerSpaceCompactionTaskSelectedNum.set((long)summary.getSubmitCrossSpaceCompactionTaskNum());
        this.insertionCrossSpaceCompactionTaskSelectedNum.set((long)summary.getSubmitInsertionCrossSpaceCompactionTaskNum());
    }

    public void updateCompactionTaskSelectionTimeCost(CompactionTaskType taskType, long time) {
        switch (taskType) {
            case INNER_SEQ: {
                this.seqSpaceCompactionTaskSelectionTimeCost.update(time);
                break;
            }
            case INNER_UNSEQ: {
                this.unseqSpaceCompactionTaskSelectionTimeCost.update(time);
                break;
            }
            case CROSS: {
                this.crossSpaceCompactionTaskSelectionTimeCost.update(time);
                break;
            }
            case INSERTION: {
                this.insertionCrossSpaceCompactionTaskSelectionTimeCost.update(time);
                break;
            }
        }
    }

    public void updateCompactionTaskSelectedFileNum(CompactionTaskType taskType, int selectedFileNum) {
        switch (taskType) {
            case INNER_SEQ: {
                this.seqInnerSpaceCompactionTaskSelectedFileNum.update((long)selectedFileNum);
                break;
            }
            case INNER_UNSEQ: {
                this.unseqInnerSpaceCompactionTaskSelectedFileNum.update((long)selectedFileNum);
                break;
            }
            case CROSS: {
                this.crossSpaceCompactionTaskSelectedFileNum.update((long)selectedFileNum);
                break;
            }
        }
    }

    private void bindCompactionTaskSelection(AbstractMetricService metricService) {
        this.seqInnerSpaceCompactionTaskSelectedNum = metricService.getOrCreateGauge(Metric.COMPACTION_TASK_SELECTION.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), "seq"});
        this.unseqInnerSpaceCompactionTaskSelectedNum = metricService.getOrCreateGauge(Metric.COMPACTION_TASK_SELECTION.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), "unseq"});
        this.crossInnerSpaceCompactionTaskSelectedNum = metricService.getOrCreateGauge(Metric.COMPACTION_TASK_SELECTION.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), "cross"});
        this.insertionCrossSpaceCompactionTaskSelectedNum = metricService.getOrCreateGauge(Metric.COMPACTION_TASK_SELECTION.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), "insertion"});
        this.seqSpaceCompactionTaskSelectionTimeCost = metricService.getOrCreateHistogram(Metric.COMPACTION_TASK_SELECTION_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), "seq"});
        this.unseqSpaceCompactionTaskSelectionTimeCost = metricService.getOrCreateHistogram(Metric.COMPACTION_TASK_SELECTION_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), "unseq"});
        this.crossSpaceCompactionTaskSelectionTimeCost = metricService.getOrCreateHistogram(Metric.COMPACTION_TASK_SELECTION_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), "cross"});
        this.insertionCrossSpaceCompactionTaskSelectionTimeCost = metricService.getOrCreateHistogram(Metric.COMPACTION_TASK_SELECTION_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), "insertion"});
        this.seqInnerSpaceCompactionTaskSelectedFileNum = metricService.getOrCreateHistogram(Metric.COMPACTION_TASK_SELECTED_FILE.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), "seq"});
        this.unseqInnerSpaceCompactionTaskSelectedFileNum = metricService.getOrCreateHistogram(Metric.COMPACTION_TASK_SELECTED_FILE.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), "unseq"});
        this.crossSpaceCompactionTaskSelectedFileNum = metricService.getOrCreateHistogram(Metric.COMPACTION_TASK_SELECTED_FILE.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), "cross"});
    }

    private void unbindCompactionTaskSelection(AbstractMetricService metricService) {
        metricService.remove(MetricType.GAUGE, Metric.COMPACTION_TASK_SELECTION.toString(), new String[]{Tag.NAME.toString(), "seq"});
        metricService.remove(MetricType.GAUGE, Metric.COMPACTION_TASK_SELECTION.toString(), new String[]{Tag.NAME.toString(), "unseq"});
        metricService.remove(MetricType.GAUGE, Metric.COMPACTION_TASK_SELECTION.toString(), new String[]{Tag.NAME.toString(), "cross"});
        metricService.remove(MetricType.GAUGE, Metric.COMPACTION_TASK_SELECTION.toString(), new String[]{Tag.NAME.toString(), "insertion"});
        metricService.remove(MetricType.HISTOGRAM, Metric.COMPACTION_TASK_SELECTION_COST.toString(), new String[]{Tag.NAME.toString(), "seq"});
        metricService.remove(MetricType.HISTOGRAM, Metric.COMPACTION_TASK_SELECTION_COST.toString(), new String[]{Tag.NAME.toString(), "unseq"});
        metricService.remove(MetricType.HISTOGRAM, Metric.COMPACTION_TASK_SELECTION_COST.toString(), new String[]{Tag.NAME.toString(), "cross"});
        metricService.remove(MetricType.HISTOGRAM, Metric.COMPACTION_TASK_SELECTION_COST.toString(), new String[]{Tag.NAME.toString(), "insertion"});
        metricService.remove(MetricType.HISTOGRAM, Metric.COMPACTION_TASK_SELECTED_FILE.toString(), new String[]{Tag.NAME.toString(), "seq"});
        metricService.remove(MetricType.HISTOGRAM, Metric.COMPACTION_TASK_SELECTED_FILE.toString(), new String[]{Tag.NAME.toString(), "unseq"});
        metricService.remove(MetricType.HISTOGRAM, Metric.COMPACTION_TASK_SELECTED_FILE.toString(), new String[]{Tag.NAME.toString(), "cross"});
    }

    public void bindTo(AbstractMetricService metricService) {
        this.bindTaskInfo(metricService);
        this.bindWriteInfo(metricService);
        this.bindReadInfo(metricService);
        this.bindPerformanceInfo(metricService);
        this.bindCompactionTaskMemory(metricService);
        this.bindCompactionTaskSelection(metricService);
    }

    public void unbindFrom(AbstractMetricService metricService) {
        this.unbindTaskInfo(metricService);
        this.unbindWriteInfo(metricService);
        this.unbindReadInfo(metricService);
        this.unbindPerformanceInfo(metricService);
        this.unbindCompactionTaskMemory(metricService);
        this.unbindCompactionTaskSelection(metricService);
    }

    private void updateCompactionTaskInfo() {
        if (System.currentTimeMillis() - this.lastUpdateTime < 10000L) {
            return;
        }
        this.lastUpdateTime = System.currentTimeMillis();
        Map<CompactionTaskType, Map<CompactionTaskStatus, Integer>> compactionTaskStatisticMap = CompactionTaskManager.getInstance().getCompactionTaskStatistic();
        this.waitingSeqInnerCompactionTaskNum.set(compactionTaskStatisticMap.getOrDefault((Object)CompactionTaskType.INNER_SEQ, Collections.emptyMap()).getOrDefault((Object)CompactionTaskStatus.WAITING, 0));
        this.waitingUnseqInnerCompactionTaskNum.set(compactionTaskStatisticMap.getOrDefault((Object)CompactionTaskType.INNER_UNSEQ, Collections.emptyMap()).getOrDefault((Object)CompactionTaskStatus.WAITING, 0));
        this.waitingCrossCompactionTaskNum.set(compactionTaskStatisticMap.getOrDefault((Object)CompactionTaskType.CROSS, Collections.emptyMap()).getOrDefault((Object)CompactionTaskStatus.WAITING, 0));
        this.waitingInsertionCompactionTaskNum.set(compactionTaskStatisticMap.getOrDefault((Object)CompactionTaskType.INSERTION, Collections.emptyMap()).getOrDefault((Object)CompactionTaskStatus.WAITING, 0));
        this.runningSeqInnerCompactionTaskNum.set(compactionTaskStatisticMap.getOrDefault((Object)CompactionTaskType.INNER_SEQ, Collections.emptyMap()).getOrDefault((Object)CompactionTaskStatus.RUNNING, 0));
        this.runningUnseqInnerCompactionTaskNum.set(compactionTaskStatisticMap.getOrDefault((Object)CompactionTaskType.INNER_UNSEQ, Collections.emptyMap()).getOrDefault((Object)CompactionTaskStatus.RUNNING, 0));
        this.runningCrossCompactionTaskNum.set(compactionTaskStatisticMap.getOrDefault((Object)CompactionTaskType.CROSS, Collections.emptyMap()).getOrDefault((Object)CompactionTaskStatus.RUNNING, 0));
        this.runningInsertionCompactionTaskNum.set(compactionTaskStatisticMap.getOrDefault((Object)CompactionTaskType.INSERTION, Collections.emptyMap()).getOrDefault((Object)CompactionTaskStatus.RUNNING, 0));
    }

    public static CompactionMetrics getInstance() {
        return INSTANCE;
    }
}

