/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.service.metrics;

import java.util.List;
import org.apache.iotdb.db.service.metrics.file.CompactionFileMetrics;
import org.apache.iotdb.db.service.metrics.file.ModsFileMetrics;
import org.apache.iotdb.db.service.metrics.file.SystemRelatedFileMetrics;
import org.apache.iotdb.db.service.metrics.file.TsFileMetrics;
import org.apache.iotdb.db.service.metrics.file.WalFileMetrics;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.metricsets.IMetricSet;

public class FileMetrics
implements IMetricSet {
    private static final TsFileMetrics TS_FILE_METRICS = new TsFileMetrics();
    private static final ModsFileMetrics MODS_FILE_METRICS = new ModsFileMetrics();
    private static final CompactionFileMetrics COMPACTION_FILE_METRICS = new CompactionFileMetrics();
    private static final WalFileMetrics WAL_FILE_METRICS = new WalFileMetrics();
    private static final SystemRelatedFileMetrics SYSTEM_RELATED_FILE_METRICS = new SystemRelatedFileMetrics();

    public void bindTo(AbstractMetricService metricService) {
        TS_FILE_METRICS.bindTo(metricService);
        MODS_FILE_METRICS.bindTo(metricService);
        COMPACTION_FILE_METRICS.bindTo(metricService);
        WAL_FILE_METRICS.bindTo(metricService);
        SYSTEM_RELATED_FILE_METRICS.bindTo(metricService);
    }

    public void unbindFrom(AbstractMetricService metricService) {
        TS_FILE_METRICS.unbindFrom(metricService);
        MODS_FILE_METRICS.unbindFrom(metricService);
        COMPACTION_FILE_METRICS.unbindFrom(metricService);
        WAL_FILE_METRICS.unbindFrom(metricService);
        SYSTEM_RELATED_FILE_METRICS.unbindFrom(metricService);
    }

    public void addTsFile(String database, String regionId, long size, boolean seq, String name) {
        TS_FILE_METRICS.addTsFile(database, regionId, size, seq, name);
    }

    public void deleteTsFile(boolean seq, List<TsFileResource> tsFileResourceList) {
        TS_FILE_METRICS.deleteFile(seq, tsFileResourceList);
    }

    public void deleteRegion(String database, String regionId) {
        TS_FILE_METRICS.deleteRegion(database, regionId);
    }

    public void increaseModFileNum(int num) {
        MODS_FILE_METRICS.increaseModFileNum(num);
    }

    public void decreaseModFileNum(int num) {
        MODS_FILE_METRICS.decreaseModFileNum(num);
    }

    public void increaseModFileSize(long size) {
        MODS_FILE_METRICS.increaseModFileSize(size);
    }

    public void decreaseModFileSize(long size) {
        MODS_FILE_METRICS.decreaseModFileSize(size);
    }

    public static FileMetrics getInstance() {
        return FileMetricsInstanceHolder.INSTANCE;
    }

    public long getFileCount(boolean seq) {
        return TS_FILE_METRICS.getFileCount(seq);
    }

    private static class FileMetricsInstanceHolder {
        private static final FileMetrics INSTANCE = new FileMetrics();

        private FileMetricsInstanceHolder() {
        }
    }
}

