/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iotdb.db.storageengine.dataregion.DeviceLastFlushTime;
import org.apache.iotdb.db.storageengine.dataregion.ILastFlushTime;
import org.apache.iotdb.db.storageengine.dataregion.ILastFlushTimeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HashLastFlushTimeMap
implements ILastFlushTimeMap {
    private static final Logger logger = LoggerFactory.getLogger(HashLastFlushTimeMap.class);
    long STRING_BASE_SIZE = 40L;
    long LONG_SIZE = 24L;
    long HASHMAP_NODE_BASIC_SIZE = 14L + this.STRING_BASE_SIZE + this.LONG_SIZE;
    private final Map<Long, ILastFlushTime> partitionLatestFlushedTime = new ConcurrentHashMap<Long, ILastFlushTime>();
    private final Map<String, Long> globalLatestFlushedTimeForEachDevice = new ConcurrentHashMap<String, Long>();
    private final Map<Long, Long> memCostForEachPartition = new ConcurrentHashMap<Long, Long>();

    @Override
    public void updateOneDeviceFlushedTime(long timePartitionId, String deviceId, long time) {
        ILastFlushTime flushTimeMapForPartition = this.partitionLatestFlushedTime.computeIfAbsent(timePartitionId, id -> new DeviceLastFlushTime());
        long lastFlushTime = flushTimeMapForPartition.getLastFlushTime(deviceId);
        if (lastFlushTime == Long.MIN_VALUE) {
            long memCost = this.HASHMAP_NODE_BASIC_SIZE + 2L * (long)deviceId.length();
            this.memCostForEachPartition.compute(timePartitionId, (k1, v1) -> v1 == null ? memCost : v1 + memCost);
        }
        flushTimeMapForPartition.updateLastFlushTime(deviceId, time);
    }

    @Override
    public void updateMultiDeviceFlushedTime(long timePartitionId, Map<String, Long> flushedTimeMap) {
        ILastFlushTime flushTimeMapForPartition = this.partitionLatestFlushedTime.computeIfAbsent(timePartitionId, id -> new DeviceLastFlushTime());
        long memIncr = 0L;
        for (Map.Entry<String, Long> entry : flushedTimeMap.entrySet()) {
            if (flushTimeMapForPartition.getLastFlushTime(entry.getKey()) == Long.MIN_VALUE) {
                memIncr += this.HASHMAP_NODE_BASIC_SIZE + 2L * (long)entry.getKey().length();
            }
            flushTimeMapForPartition.updateLastFlushTime(entry.getKey(), entry.getValue());
        }
        long finalMemIncr = memIncr;
        this.memCostForEachPartition.compute(timePartitionId, (k1, v1) -> v1 == null ? finalMemIncr : v1 + finalMemIncr);
    }

    @Override
    public void updateOneDeviceGlobalFlushedTime(String path, long time) {
        this.globalLatestFlushedTimeForEachDevice.compute(path, (k, v) -> v == null ? time : Math.max(v, time));
    }

    @Override
    public void updateMultiDeviceGlobalFlushedTime(Map<String, Long> globalFlushedTimeMap) {
        for (Map.Entry<String, Long> entry : globalFlushedTimeMap.entrySet()) {
            this.globalLatestFlushedTimeForEachDevice.merge(entry.getKey(), entry.getValue(), Math::max);
        }
    }

    @Override
    public boolean checkAndCreateFlushedTimePartition(long timePartitionId) {
        if (!this.partitionLatestFlushedTime.containsKey(timePartitionId)) {
            this.partitionLatestFlushedTime.put(timePartitionId, new DeviceLastFlushTime());
            return false;
        }
        return true;
    }

    @Override
    public void updateLatestFlushTime(long partitionId, Map<String, Long> updateMap) {
        for (Map.Entry<String, Long> entry : updateMap.entrySet()) {
            this.partitionLatestFlushedTime.computeIfAbsent(partitionId, id -> new DeviceLastFlushTime()).updateLastFlushTime(entry.getKey(), entry.getValue());
            if (this.globalLatestFlushedTimeForEachDevice.getOrDefault(entry.getKey(), Long.MIN_VALUE) >= entry.getValue()) continue;
            this.globalLatestFlushedTimeForEachDevice.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public long getFlushedTime(long timePartitionId, String deviceId) {
        return this.partitionLatestFlushedTime.get(timePartitionId).getLastFlushTime(deviceId);
    }

    @Override
    public long getGlobalFlushedTime(String path) {
        return this.globalLatestFlushedTimeForEachDevice.getOrDefault(path, Long.MIN_VALUE);
    }

    @Override
    public void clearFlushedTime() {
        this.partitionLatestFlushedTime.clear();
    }

    @Override
    public void clearGlobalFlushedTime() {
        this.globalLatestFlushedTimeForEachDevice.clear();
    }

    @Override
    public void degradeLastFlushTime(long partitionId) {
        this.partitionLatestFlushedTime.computeIfPresent(partitionId, (id, lastFlushTime) -> lastFlushTime.degradeLastFlushTime());
        this.memCostForEachPartition.put(partitionId, 8L);
    }

    @Override
    public long getMemSize(long partitionId) {
        if (this.memCostForEachPartition.containsKey(partitionId)) {
            return this.memCostForEachPartition.get(partitionId);
        }
        return 0L;
    }
}

